/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.math.BigDecimal;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentTemplatePrinter;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentTemplateTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testDefaults() {
        Lookup reportType = TestHelper.getLookup("lookup.reportType", "OTHER");
        reportType.setDefaultLookup(true);
        this.save((IMObject)reportType);
        Entity entity = this.create("entity.documentTemplate", Entity.class);
        DocumentTemplate template = new DocumentTemplate(entity, (ArchetypeService)this.getArchetypeService());
        Assert.assertNull((Object)template.getName());
        Assert.assertNull((Object)template.getDescription());
        Assert.assertTrue((boolean)template.isActive());
        Assert.assertNull((Object)template.getType());
        Assert.assertEquals((Object)"0", (Object)template.getUserLevel());
        Assert.assertEquals((Object)reportType.getCode(), (Object)template.getReportType());
        Assert.assertEquals((Object)DocumentTemplate.PrintMode.CHECK_OUT, (Object)template.getPrintMode());
        Assert.assertNull((Object)template.getPaperSize());
        Assert.assertEquals((Object)"PORTRAIT", (Object)template.getOrientation());
        Assert.assertEquals((long)1L, (long)template.getCopies());
        this.checkEquals(BigDecimal.ZERO, template.getPaperHeight());
        this.checkEquals(BigDecimal.ZERO, template.getPaperWidth());
        Assert.assertEquals((Object)"MM", (Object)template.getPaperUnits());
        Assert.assertNull((Object)template.getSMSTemplate());
        Assert.assertNull((Object)template.getMediaSize());
        Assert.assertEquals((Object)OrientationRequested.PORTRAIT, (Object)template.getOrientationRequested());
        Assert.assertTrue((boolean)template.getPrinters().isEmpty());
        Assert.assertNull((Object)template.getFileNameExpression());
    }

    @Test
    public void testAccessors() {
        BigDecimal height = new BigDecimal("10.00");
        BigDecimal width = new BigDecimal("5.00");
        TestDocumentTemplateBuilder builder = this.documentFactory.newTemplate();
        Entity entity = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)builder.name("test name")).description("test description")).active(false)).type("REPORT").userLevel("1").reportType("XX_REPORT_TYPE").printMode(DocumentTemplate.PrintMode.IMMEDIATE).paperSize("A5").orientation("LANDSCAPE").copies(5).paperHeight(height).paperWidth(width).paperUnits("MM").build();
        DocumentTemplate template = new DocumentTemplate(entity, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)"test name", (Object)template.getName());
        Assert.assertEquals((Object)"test description", (Object)template.getDescription());
        Assert.assertFalse((boolean)template.isActive());
        Assert.assertEquals((Object)"REPORT", (Object)template.getType());
        Assert.assertEquals((Object)"1", (Object)template.getUserLevel());
        Assert.assertEquals((Object)"XX_REPORT_TYPE", (Object)template.getReportType());
        Assert.assertEquals((Object)DocumentTemplate.PrintMode.IMMEDIATE, (Object)template.getPrintMode());
        Assert.assertEquals((Object)"A5", (Object)template.getPaperSize());
        Assert.assertEquals((Object)"LANDSCAPE", (Object)template.getOrientation());
        Assert.assertEquals((long)5L, (long)template.getCopies());
        this.checkEquals(height, template.getPaperHeight());
        this.checkEquals(width, template.getPaperWidth());
        Assert.assertEquals((Object)"MM", (Object)template.getPaperUnits());
        Assert.assertEquals((Object)MediaSizeName.ISO_A5, (Object)template.getMediaSize());
        Assert.assertEquals((Object)OrientationRequested.LANDSCAPE, (Object)template.getOrientationRequested());
    }

    @Test
    public void testGetPrinter() {
        TestDocumentTemplateBuilder builder = this.documentFactory.newTemplate();
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        Party practice = TestHelper.getPractice();
        Entity entity = (Entity)builder.printer().location(location1).add().printer().location(practice).add().build(false);
        IMObjectBean bean = this.getBean((IMObject)entity);
        EntityRelationship printer1 = (EntityRelationship)bean.getValue("printers", EntityRelationship.class, Predicates.targetEquals((IMObject)location1));
        EntityRelationship printer2 = (EntityRelationship)bean.getValue("printers", EntityRelationship.class, Predicates.targetEquals((IMObject)practice));
        DocumentTemplate template = new DocumentTemplate(entity, (ArchetypeService)this.getArchetypeService());
        DocumentTemplatePrinter location1Printer = new DocumentTemplatePrinter(printer1, (ArchetypeService)this.getArchetypeService());
        DocumentTemplatePrinter practicePrinter = new DocumentTemplatePrinter(printer2, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)location1Printer, (Object)template.getPrinter((Entity)location1));
        Assert.assertEquals((Object)practicePrinter, (Object)template.getPrinter((Entity)practice));
        Assert.assertNull((Object)template.getPrinter((Entity)location2));
        Assert.assertEquals((long)2L, (long)template.getPrinters().size());
        Assert.assertTrue((boolean)template.getPrinters().contains(location1Printer));
        Assert.assertTrue((boolean)template.getPrinters().contains(practicePrinter));
    }

    @Test
    public void testGetFileNameExpression() {
        Entity entity = this.create("entity.documentTemplate", Entity.class);
        Lookup lookup = this.create("lookup.fileNameFormat", Lookup.class);
        DocumentTemplate template = new DocumentTemplate(entity, (ArchetypeService)this.getArchetypeService());
        Assert.assertNull((Object)template.getFileNameExpression());
        IMObjectBean bean = this.getBean((IMObject)lookup);
        String expression = "concat($file, ' - ', date:format(java.util.Date.new(), 'd MMM yyyy'))";
        bean.setValue("expression", (Object)expression);
        entity.addClassification(lookup);
        Assert.assertEquals((Object)expression, (Object)template.getFileNameExpression());
    }

    @Test
    public void testIsForm() {
        Assert.assertTrue((boolean)DocumentTemplate.isForm((String)"act.customerDocumentForm"));
        Assert.assertTrue((boolean)DocumentTemplate.isForm((String)"act.patientDocumentForm"));
        Assert.assertTrue((boolean)DocumentTemplate.isForm((String)"act.supplierDocumentForm"));
        Assert.assertFalse((boolean)DocumentTemplate.isForm((String)"act.customerDocumentLetter"));
        Assert.assertFalse((boolean)DocumentTemplate.isForm((String)"act.patientDocumentLetter"));
        Assert.assertFalse((boolean)DocumentTemplate.isForm((String)"act.supplierDocumentLetter"));
    }

    @Test
    public void testIsLetter() {
        Assert.assertTrue((boolean)DocumentTemplate.isLetter((String)"act.customerDocumentLetter"));
        Assert.assertTrue((boolean)DocumentTemplate.isLetter((String)"act.patientDocumentLetter"));
        Assert.assertTrue((boolean)DocumentTemplate.isLetter((String)"act.supplierDocumentLetter"));
        Assert.assertFalse((boolean)DocumentTemplate.isLetter((String)"act.customerDocumentForm"));
        Assert.assertFalse((boolean)DocumentTemplate.isLetter((String)"act.patientDocumentForm"));
        Assert.assertFalse((boolean)DocumentTemplate.isLetter((String)"act.supplierDocumentForm"));
    }

    @Test
    public void testIsReport() {
        Assert.assertTrue((boolean)DocumentTemplate.isReport((String)"REPORT"));
        Assert.assertTrue((boolean)DocumentTemplate.isReport((String)"SUBREPORT"));
        Assert.assertFalse((boolean)DocumentTemplate.isReport((String)"act.patientDocumentForm"));
    }
}

