/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestLetterheadBuilder;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DocumentRules rules;
    @Autowired
    private LaboratoryRules laboratoryRules;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestUserFactory userFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testSupportsVersions() {
        DocumentAct image = this.create("act.patientDocumentImage", DocumentAct.class);
        Assert.assertTrue((boolean)this.rules.supportsVersions(image));
        DocumentAct form = this.create("act.patientDocumentForm", DocumentAct.class);
        Assert.assertFalse((boolean)this.rules.supportsVersions(form));
    }

    @Test
    public void testAddDocument() {
        Party patient = this.patientFactory.createPatient();
        Act event = this.create("act.patientClinicalEvent", Act.class);
        IMObjectBean eventBean = this.getBean((IMObject)event);
        eventBean.setTarget("patient", (IMObject)patient);
        eventBean.save();
        DocumentAct act = this.create("act.patientDocumentImage", DocumentAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        eventBean.addTarget("items", (IMObject)act, "event");
        this.save((IMObject[])new Act[]{act, event});
        org.openvpms.component.model.document.Document document1 = this.createDocument();
        List objects = this.rules.addDocument(act, document1);
        this.save(objects);
        Assert.assertEquals((Object)document1.getObjectReference(), (Object)act.getDocument());
        org.openvpms.component.model.document.Document document2 = this.createDocument();
        objects = this.rules.addDocument(act, document2);
        this.save(objects);
        Assert.assertEquals((Object)document2.getObjectReference(), (Object)act.getDocument());
        List acts = bean.getTargets("versions", DocumentAct.class);
        Assert.assertEquals((long)1L, (long)acts.size());
        DocumentAct old = (DocumentAct)acts.get(0);
        Assert.assertEquals((Object)document1.getObjectReference(), (Object)old.getDocument());
        org.openvpms.component.model.document.Document document3 = this.createDocument();
        objects = this.rules.addDocument(act, document3);
        this.save(objects);
        Assert.assertEquals((Object)document3.getObjectReference(), (Object)act.getDocument());
        acts = bean.getTargets("versions", DocumentAct.class);
        Assert.assertEquals((long)2L, (long)acts.size());
        HashSet<Reference> docs = new HashSet<Reference>();
        for (DocumentAct version : acts) {
            Assert.assertEquals((long)1L, (long)version.getActRelationships().size());
            docs.add(version.getDocument());
        }
        Assert.assertTrue((boolean)docs.contains(document1.getObjectReference()));
        Assert.assertTrue((boolean)docs.contains(document2.getObjectReference()));
    }

    @Test
    public void testAddDocumentForInvestigation() {
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        User clinician = this.userFactory.createClinician();
        Product product = this.productFactory.createService();
        Entity laboratory = this.laboratoryFactory.createLaboratory();
        Entity investigationType = this.laboratoryFactory.createInvestigationType(laboratory);
        Entity device = this.laboratoryFactory.createDevice(laboratory);
        Party location = this.practiceFactory.createLocation();
        DocumentAct investigation = (DocumentAct)((TestInvestigationBuilder)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationType).products(product).laboratory(laboratory).location(location)).device(device).clinician(clinician)).build();
        Act order = this.laboratoryRules.createOrder((Act)investigation);
        IMObjectBean bean = this.getBean((IMObject)investigation);
        investigation.addIdentity(TestHelper.createActIdentity("actIdentity.laboratoryReportTest", "12456612"));
        Act results = this.create("act.patientInvestigationResults", Act.class);
        IMObjectBean resultsBean = this.getBean((IMObject)results);
        resultsBean.setValue("resultsId", (Object)"1");
        bean.addTarget("results", (IMObject)results, "investigation");
        this.save((IMObject[])new Act[]{investigation, results, order});
        ((TestVisitBuilder)this.patientFactory.newVisit().patient(patient)).addItem((Act)investigation).build();
        org.openvpms.component.model.document.Document document1 = this.createDocument();
        List objects = this.rules.addDocument(investigation, document1);
        this.save(objects);
        Assert.assertEquals((Object)document1.getObjectReference(), (Object)investigation.getDocument());
        org.openvpms.component.model.document.Document document2 = this.createDocument();
        objects = this.rules.addDocument(investigation, document2);
        this.save(objects);
        Assert.assertEquals((Object)document2.getObjectReference(), (Object)investigation.getDocument());
        List acts = bean.getTargets("versions", DocumentAct.class);
        Assert.assertEquals((long)1L, (long)acts.size());
        DocumentAct old = (DocumentAct)acts.get(0);
        Assert.assertEquals((Object)document1.getObjectReference(), (Object)old.getDocument());
        org.openvpms.component.model.document.Document document3 = this.createDocument();
        objects = this.rules.addDocument(investigation, document3);
        this.save(objects);
        Assert.assertEquals((Object)document3.getObjectReference(), (Object)investigation.getDocument());
        acts = bean.getTargets("versions", DocumentAct.class);
        Assert.assertEquals((long)2L, (long)acts.size());
        HashSet<Reference> docs = new HashSet<Reference>();
        for (DocumentAct version : acts) {
            Assert.assertEquals((long)1L, (long)version.getActRelationships().size());
            Assert.assertEquals((long)0L, (long)version.getIdentities().size());
            docs.add(version.getDocument());
        }
        Assert.assertTrue((boolean)docs.contains(document1.getObjectReference()));
        Assert.assertTrue((boolean)docs.contains(document2.getObjectReference()));
    }

    @Test
    public void testCreatePatientDocumentVersion() {
        this.checkCreatePatientVersion("act.patientDocumentAttachment", "act.patientDocumentAttachmentVersion");
        this.checkCreatePatientVersion("act.patientDocumentImage", "act.patientDocumentImageVersion");
        this.checkCreatePatientVersion("act.patientDocumentLetter", "act.patientDocumentLetterVersion");
        this.checkCreatePatientVersion("act.patientInvestigation", "act.patientInvestigationVersion");
    }

    @Test
    public void testCreateCustomerDocumentVersion() {
        this.checkCreateCustomerSupplierVersion("act.customerDocumentAttachment", "act.customerDocumentAttachmentVersion");
        this.checkCreateCustomerSupplierVersion("act.customerDocumentLetter", "act.customerDocumentLetterVersion");
    }

    @Test
    public void testCreateSupplierDocumentVersion() {
        this.checkCreateCustomerSupplierVersion("act.supplierDocumentAttachment", "act.supplierDocumentAttachmentVersion");
        this.checkCreateCustomerSupplierVersion("act.supplierDocumentLetter", "act.supplierDocumentLetterVersion");
    }

    @Test
    public void testIsDuplicate() {
        Party patient = this.patientFactory.createPatient();
        DocumentAct act = this.create("act.patientDocumentImage", DocumentAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        org.openvpms.component.model.document.Document document1 = this.createDocument();
        Assert.assertNotEquals((long)0L, (long)document1.getSize());
        Assert.assertNotEquals((long)0L, (long)document1.getChecksum());
        List objects = this.rules.addDocument(act, document1);
        this.save(objects);
        Assert.assertTrue((boolean)this.rules.isDuplicate(act, document1));
        document1.setChecksum(0L);
        this.save((IMObject)document1);
        Assert.assertFalse((boolean)this.rules.isDuplicate(act, document1));
        org.openvpms.component.model.document.Document document2 = this.createDocument();
        Assert.assertNotEquals((long)0L, (long)document2.getSize());
        Assert.assertNotEquals((long)0L, (long)document2.getChecksum());
        Assert.assertFalse((boolean)this.rules.isDuplicate(act, document2));
        document1.setChecksum(1L);
        this.save((IMObject)document1);
        document2.setSize(document1.getSize());
        document2.setChecksum(document1.getChecksum());
        Assert.assertTrue((boolean)this.rules.isDuplicate(act, document2));
    }

    @Test
    public void testGetLogo() {
        Entity letterhead1 = (Entity)this.documentFactory.newLetterhead().build();
        Assert.assertNull((Object)this.rules.getLogo(letterhead1));
        TestLetterheadBuilder builder = this.documentFactory.newLetterhead();
        Entity letterhead2 = (Entity)builder.logo(this.createDocument()).build();
        DocumentAct logo = builder.getLogo();
        Assert.assertEquals((Object)logo, (Object)this.rules.getLogo(letterhead2));
    }

    @Test
    public void testCopyDocument() {
        org.openvpms.component.model.document.Document image = this.documentFactory.createImage();
        Assert.assertTrue((boolean)image.isA("document.image"));
        org.openvpms.component.model.document.Document copy = this.rules.copy(image);
        Assert.assertNotEquals((long)image.getId(), (long)copy.getId());
        this.documentFactory.newImageVerifier().initialise(image).verify(copy);
        Assert.assertNotSame((Object)((Document)image).getContents(), (Object)((Document)copy).getContents());
    }

    private void checkCreatePatientVersion(String actShortName, String expectedVersion) {
        DocumentAct act = this.create(actShortName, DocumentAct.class);
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        User clinician = this.userFactory.createClinician();
        Entity investigationType = act.isA("act.patientInvestigation") ? this.laboratoryFactory.createInvestigationType() : null;
        Product product = null;
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("clinician", (IMObject)clinician);
        if (investigationType != null) {
            bean.setTarget("investigationType", (IMObject)investigationType);
        }
        if (bean.hasNode("product")) {
            product = this.productFactory.createService();
            bean.setTarget("product", (IMObject)product);
        }
        bean.save();
        ((TestVisitBuilder)this.patientFactory.newVisit().patient(patient)).addItem((Act)act).build();
        DocumentAct version1 = this.checkCreateVersionForPatientDocument(act, expectedVersion, clinician, investigationType, product);
        bean.addTarget("versions", (IMObject)version1, "parent");
        bean.save(new IMObject[]{version1});
        this.checkCreateVersionForPatientDocument(act, expectedVersion, clinician, investigationType, product);
    }

    private DocumentAct checkCreateVersionForPatientDocument(DocumentAct act, String expectedVersion, User clinician, Entity investigationType, Product product) {
        DocumentAct version = this.checkCreateVersion(act, expectedVersion);
        IMObjectBean versionBean = this.getBean((IMObject)version);
        Assert.assertEquals((Object)clinician, (Object)versionBean.getTarget("clinician"));
        if (versionBean.hasNode("product")) {
            Assert.assertEquals((Object)product, (Object)versionBean.getTarget("product"));
        }
        if (act.isA("act.patientInvestigation")) {
            Assert.assertEquals((Object)investigationType, (Object)versionBean.getTarget("investigationType"));
        }
        Assert.assertEquals((long)0L, (long)version.getSourceActRelationships().size());
        Assert.assertEquals((long)0L, (long)version.getTargetActRelationships().size());
        return version;
    }

    private void checkCreateCustomerSupplierVersion(String actShortName, String expectedVersion) {
        DocumentAct act = this.create(actShortName, DocumentAct.class);
        this.checkCreateVersion(act, expectedVersion);
    }

    private DocumentAct checkCreateVersion(DocumentAct act, String expectedVersion) {
        act.setPrinted(true);
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertTrue((boolean)bean.hasNode("document"));
        org.openvpms.component.model.document.Document document = this.createDocument();
        this.save((IMObject)document);
        act.setDocument(document.getObjectReference());
        Assert.assertNotNull((Object)act);
        DocumentAct version = this.rules.createVersion(act);
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)expectedVersion, (Object)version.getArchetype());
        Assert.assertEquals((Object)document.getObjectReference(), (Object)version.getDocument());
        Assert.assertEquals((Object)act.getMimeType(), (Object)version.getMimeType());
        Assert.assertEquals((Object)act.getFileName(), (Object)version.getFileName());
        Assert.assertEquals((Object)act.isPrinted(), (Object)version.isPrinted());
        IMObjectBean versionBean = this.getBean((IMObject)version);
        Assert.assertTrue((boolean)versionBean.hasNode("document"));
        return version;
    }

    private org.openvpms.component.model.document.Document createDocument() {
        return (org.openvpms.component.model.document.Document)((TestDocumentBuilder)this.documentFactory.newDocument().name(ValueStrategy.suffix(".png"))).content(RandomUtils.nextBytes((int)10)).build();
    }
}

