/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentException;

public class DocumentExceptionTestCase {
    @Test
    public void testMessages() {
        Assert.assertEquals((String)"Need to update tests to incorporate new messages", (long)14L, (long)DocumentException.ErrorCode.values().length);
        this.checkException(DocumentException.ErrorCode.UnsupportedDoc, "File 'foo' has an unsupported content type: bar", "foo", "bar");
        this.checkException(DocumentException.ErrorCode.ReadError, "Failed to read foo", "foo");
        this.checkException(DocumentException.ErrorCode.WriteError, "Failed to write foo", "foo");
        this.checkException(DocumentException.ErrorCode.RenameError, "Failed to rename foo to bar", "foo", "bar");
        this.checkException(DocumentException.ErrorCode.NotFound, "Foo has no document", "Foo");
        this.checkException(DocumentException.ErrorCode.DocumentRefNotFound, "Document not found", new Object[0]);
        this.checkException(DocumentException.ErrorCode.InvalidUnits, "Invalid units: foo", "foo");
        this.checkException(DocumentException.ErrorCode.InvalidOrientation, "Invalid orientation: foo", "foo");
        this.checkException(DocumentException.ErrorCode.InvalidMediaTray, "Invalid media tray: foo", "foo");
        this.checkException(DocumentException.ErrorCode.InvalidPaperSize, "Invalid paper size: foo", "foo");
        this.checkException(DocumentException.ErrorCode.InvalidSides, "Invalid sides: foo", "foo");
        this.checkException(DocumentException.ErrorCode.TemplateHasNoDocument, "Document Template 'foo' has no document", "foo");
        this.checkException(DocumentException.ErrorCode.DocumentHasNoTemplate, "Form has no template. This is needed to generate the document", "Form");
        this.checkException(DocumentException.ErrorCode.DocumentGenerationRequired, "Letter needs to be generated before it can be downloaded.", "Letter");
    }

    private void checkException(DocumentException.ErrorCode code, String expected, Object ... args) {
        DocumentException exception = new DocumentException(code, args);
        Assert.assertEquals((Object)code, (Object)exception.getErrorCode());
        Assert.assertEquals((Object)expected, (Object)exception.getMessage());
    }
}

