/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.i18n.time;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.i18n.time.DurationFormatter;
import org.openvpms.archetype.i18n.time.DurationFormatterTestHelper;
import org.openvpms.archetype.i18n.time.LookupDateDurationFormatter;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.service.archetype.ArchetypeService;

public class LookupDateDurationFormatterTestCase
extends ArchetypeServiceTest {
    @Test
    public void testFormat() {
        Lookup formats = DurationFormatterTestHelper.createDurationFormats();
        DurationFormatterTestHelper.addFormat(formats, 6, DateUnits.DAYS, false, false, false, true);
        DurationFormatterTestHelper.addFormat(formats, 90, DateUnits.DAYS, false, false, true, false);
        DurationFormatterTestHelper.addFormat(formats, 1, DateUnits.YEARS, false, true, false, false);
        DurationFormatterTestHelper.addFormat(formats, 2, DateUnits.YEARS, true, true, false, false);
        LookupDateDurationFormatter formatter = new LookupDateDurationFormatter(formats, this.getLookupService(), (ArchetypeService)this.getArchetypeService());
        Date from = TestHelper.getDate("2011-01-01");
        Date to1 = TestHelper.getDate("2011-01-07");
        Date to2 = TestHelper.getDate("2011-01-08");
        Date to3 = TestHelper.getDate("2012-01-01");
        Date to4 = TestHelper.getDate("2013-02-01");
        this.checkFormat("6 Days", from, to1, (DurationFormatter)formatter);
        this.checkFormat("1 Week", from, to2, (DurationFormatter)formatter);
        this.checkFormat("12 Months", from, to3, (DurationFormatter)formatter);
        this.checkFormat("2 Years 1 Month", from, to4, (DurationFormatter)formatter);
    }

    private void checkFormat(String expected, Date from, Date to, DurationFormatter formatter) {
        String result = formatter.format(from, to);
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

