/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.i18n.time;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.i18n.time.DateDurationFormatter;
import org.openvpms.archetype.test.TestHelper;

public class DateDurationFormatterTestCase {
    @Test
    public void testYears() {
        Date from = TestHelper.getDate("2008-01-01");
        Date to1 = TestHelper.getDate("2008-12-31");
        Date to2 = TestHelper.getDate("2009-01-01");
        Date to3 = TestHelper.getDate("2011-05-01");
        this.checkFormat("0 Years", from, from, true, false, false, false);
        this.checkFormat("0 Years", from, to1, true, false, false, false);
        this.checkFormat("1 Year", from, to2, true, false, false, false);
        this.checkFormat("3 Years", from, to3, true, false, false, false);
    }

    @Test
    public void testMonths() {
        Date from = TestHelper.getDate("2008-06-01");
        Date to1 = TestHelper.getDate("2008-12-31");
        Date to2 = TestHelper.getDate("2009-01-01");
        Date to3 = TestHelper.getDate("2010-06-01");
        this.checkFormat("0 Months", from, from, false, true, false, false);
        this.checkFormat("6 Months", from, to1, false, true, false, false);
        this.checkFormat("7 Months", from, to2, false, true, false, false);
        this.checkFormat("24 Months", from, to3, false, true, false, false);
    }

    @Test
    public void testMonthsWithFromDayGreaterThanToDay() {
        Date from1 = TestHelper.getDate("2008-01-31");
        Date to1 = TestHelper.getDate("2008-02-29");
        this.checkFormat("1 Month", from1, to1, false, true, false, false);
        Date from2 = TestHelper.getDate("2008-01-16");
        Date to2 = TestHelper.getDate("2008-02-15");
        this.checkFormat("0 Months", from2, to2, false, true, false, false);
    }

    @Test
    public void testMonthsDaysWithFromDayGreaterThanToDay() {
        Date from1 = TestHelper.getDate("2008-01-31");
        Date to1 = TestHelper.getDate("2008-02-29");
        this.checkFormat("1 Month", from1, to1, false, true, false, true);
        Date from2 = TestHelper.getDate("2008-01-16");
        Date to2 = TestHelper.getDate("2008-02-15");
        this.checkFormat("30 Days", from2, to2, false, true, false, true);
        Date from3 = TestHelper.getDate("2008-01-16");
        Date to3 = TestHelper.getDate("2008-03-15");
        this.checkFormat("1 Month 28 Days", from3, to3, false, true, false, true);
    }

    @Test
    public void testWeeksForCurrentYear() {
        Date from = TestHelper.getDate("2011-01-01");
        Date to1 = TestHelper.getDate("2011-02-01");
        Date to2 = TestHelper.getDate("2011-03-01");
        Date to3 = TestHelper.getDate("2011-04-01");
        Date to4 = TestHelper.getDate("2011-05-01");
        this.checkFormat("0 Weeks", from, from, false, false, true, false);
        this.checkFormat("4 Weeks", from, to1, false, false, true, false);
        this.checkFormat("8 Weeks", from, to2, false, false, true, false);
        this.checkFormat("12 Weeks", from, to3, false, false, true, false);
        this.checkFormat("17 Weeks", from, to4, false, false, true, false);
    }

    @Test
    public void testWeeksForPastYear() {
        Date from = TestHelper.getDate("2008-05-01");
        Date year1 = TestHelper.getDate("2009-05-01");
        Date year2 = TestHelper.getDate("2010-05-01");
        Date year3 = TestHelper.getDate("2011-05-01");
        Date to2 = TestHelper.getDate("2009-04-01");
        Date to3 = TestHelper.getDate("2010-04-01");
        this.checkFormat("52 Weeks", from, year1, false, false, true, false);
        this.checkFormat("52 Weeks", year1, year2, false, false, true, false);
        this.checkFormat("104 Weeks", from, year2, false, false, true, false);
        this.checkFormat("52 Weeks", year2, year3, false, false, true, false);
        this.checkFormat("156 Weeks", from, year3, false, false, true, false);
        this.checkFormat("47 Weeks", from, to2, false, false, true, false);
        this.checkFormat("100 Weeks", from, to3, false, false, true, false);
    }

    @Test
    public void testDays() {
        Date from = TestHelper.getDate("2008-05-01");
        Date date1 = TestHelper.getDate("2008-06-01");
        Date date2 = TestHelper.getDate("2009-05-01");
        Date date3 = TestHelper.getDate("2009-05-02");
        this.checkFormat("0 Days", from, from, false, false, false, true);
        this.checkFormat("31 Days", from, date1, false, false, false, true);
        this.checkFormat("365 Days", from, date2, false, false, false, true);
        this.checkFormat("366 Days", from, date3, false, false, false, true);
    }

    @Test
    public void testDaysWithFromDayGreaterThanToDay() {
        Date from1 = TestHelper.getDate("2008-01-31");
        Date to1 = TestHelper.getDate("2008-02-29");
        this.checkFormat("29 Days", from1, to1, false, false, false, true);
        Date from2 = TestHelper.getDate("2008-01-16");
        Date to2 = TestHelper.getDate("2008-02-15");
        this.checkFormat("30 Days", from2, to2, false, false, false, true);
        Date from3 = TestHelper.getDate("2008-01-16");
        Date to3 = TestHelper.getDate("2008-03-15");
        this.checkFormat("59 Days", from3, to3, false, false, false, true);
    }

    @Test
    public void testYearsMonths() {
        Date from = TestHelper.getDate("2008-05-01");
        Date to1 = TestHelper.getDate("2009-06-01");
        Date to2 = TestHelper.getDate("2010-06-01");
        Date to3 = TestHelper.getDate("2010-04-01");
        this.checkFormat("0 Months", from, from, true, true, false, false);
        this.checkFormat("1 Year 1 Month", from, to1, true, true, false, false);
        this.checkFormat("2 Years 1 Month", from, to2, true, true, false, false);
        this.checkFormat("1 Year 11 Months", from, to3, true, true, false, false);
    }

    @Test
    public void testYearsMonthsWithFromDayGreaterThanToDay() {
        Date from1 = TestHelper.getDate("2007-01-31");
        Date to1 = TestHelper.getDate("2008-02-29");
        this.checkFormat("1 Year 1 Month", from1, to1, true, true, false, false);
        Date from2 = TestHelper.getDate("2007-01-16");
        Date to2 = TestHelper.getDate("2008-02-15");
        this.checkFormat("1 Year", from2, to2, true, true, false, false);
        Date from3 = TestHelper.getDate("2007-01-16");
        Date to3 = TestHelper.getDate("2008-03-15");
        this.checkFormat("1 Year 1 Month", from3, to3, true, true, false, false);
    }

    @Test
    public void testYearsMonthsWeeks() {
        Date from = TestHelper.getDate("2008-05-01");
        Date to1 = TestHelper.getDate("2009-06-08");
        Date to2 = TestHelper.getDate("2010-06-07");
        Date to3 = TestHelper.getDate("2010-04-22");
        this.checkFormat("0 Weeks", from, from, true, true, true, false);
        this.checkFormat("1 Year 1 Month 1 Week", from, to1, true, true, true, false);
        this.checkFormat("2 Years 1 Month", from, to2, true, true, true, false);
        this.checkFormat("1 Year 11 Months 3 Weeks", from, to3, true, true, true, false);
    }

    @Test
    public void testYearsMonthsWeeksWithFromDayGreaterThanToDay() {
        Date from1 = TestHelper.getDate("2007-01-31");
        Date to1 = TestHelper.getDate("2008-02-29");
        this.checkFormat("1 Year 1 Month", from1, to1, true, true, true, true);
        Date from2 = TestHelper.getDate("2007-01-16");
        Date to2 = TestHelper.getDate("2008-02-15");
        this.checkFormat("1 Year 4 Weeks 2 Days", from2, to2, true, true, true, true);
        Date from3 = TestHelper.getDate("2007-01-16");
        Date to3 = TestHelper.getDate("2008-03-15");
        this.checkFormat("1 Year 1 Month 4 Weeks", from3, to3, true, true, true, true);
    }

    @Test
    public void testYearsMonthsWeeksDays() {
        Date from = TestHelper.getDate("2008-05-01");
        Date to1 = TestHelper.getDate("2009-06-08");
        Date to2 = TestHelper.getDate("2010-06-07");
        Date to3 = TestHelper.getDate("2010-04-22");
        this.checkFormat("0 Days", from, from, true, true, true, true);
        this.checkFormat("1 Year 1 Month 1 Week", from, to1, true, true, true, true);
        this.checkFormat("2 Years 1 Month 6 Days", from, to2, true, true, true, true);
        this.checkFormat("1 Year 11 Months 3 Weeks", from, to3, true, true, true, true);
    }

    @Test
    public void testYearsMonthsDaysWeeksWithFromDayGreaterThanToDay() {
        Date from1 = TestHelper.getDate("2007-01-31");
        Date to1 = TestHelper.getDate("2008-02-29");
        this.checkFormat("1 Year 1 Month", from1, to1, true, true, true, true);
        Date from2 = TestHelper.getDate("2007-01-16");
        Date to2 = TestHelper.getDate("2008-02-15");
        this.checkFormat("1 Year 4 Weeks 2 Days", from2, to2, true, true, true, true);
        Date from3 = TestHelper.getDate("2007-01-16");
        Date to3 = TestHelper.getDate("2008-03-15");
        this.checkFormat("1 Year 1 Month 4 Weeks", from3, to3, true, true, true, true);
    }

    @Test
    public void testMonthsWeeks() {
        Date from = TestHelper.getDate("2010-07-16");
        Date to1 = TestHelper.getDate("2011-07-03");
        Date to2 = TestHelper.getDate("2011-08-03");
        Date to3 = TestHelper.getDate("2011-08-16");
        Date to4 = TestHelper.getDate("2011-08-23");
        this.checkFormat("0 Weeks", from, from, false, true, true, false);
        this.checkFormat("11 Months 2 Weeks", from, to1, false, true, true, false);
        this.checkFormat("12 Months 2 Weeks", from, to2, false, true, true, false);
        this.checkFormat("13 Months", from, to3, false, true, true, false);
        this.checkFormat("13 Months 1 Week", from, to4, false, true, true, false);
    }

    @Test
    public void testMonthsWeeksWithFromDayGreaterThanToDay() {
        Date from1 = TestHelper.getDate("2007-01-31");
        Date to1 = TestHelper.getDate("2008-02-29");
        this.checkFormat("13 Months", from1, to1, false, true, true, false);
        Date from2 = TestHelper.getDate("2007-01-16");
        Date to2 = TestHelper.getDate("2008-02-15");
        this.checkFormat("12 Months 4 Weeks", from2, to2, false, true, true, false);
        Date from3 = TestHelper.getDate("2007-01-16");
        Date to3 = TestHelper.getDate("2008-03-15");
        this.checkFormat("13 Months 4 Weeks", from3, to3, false, true, true, false);
    }

    @Test
    public void testMonthsWeeksDays() {
        Date from = TestHelper.getDate("2008-05-01");
        Date to1 = TestHelper.getDate("2009-06-08");
        Date to2 = TestHelper.getDate("2009-06-09");
        Date to3 = TestHelper.getDate("2010-06-07");
        Date to4 = TestHelper.getDate("2010-04-22");
        this.checkFormat("0 Days", from, from, false, true, true, true);
        this.checkFormat("13 Months 1 Week", from, to1, false, true, true, true);
        this.checkFormat("13 Months 1 Week 1 Day", from, to2, false, true, true, true);
        this.checkFormat("25 Months 6 Days", from, to3, false, true, true, true);
        this.checkFormat("23 Months 3 Weeks", from, to4, false, true, true, true);
    }

    @Test
    public void testMonthsWeeksDaysWithFromDayGreaterThanToDay() {
        Date from1 = TestHelper.getDate("2007-01-31");
        Date to1 = TestHelper.getDate("2008-02-29");
        this.checkFormat("13 Months", from1, to1, false, true, true, true);
        Date from2 = TestHelper.getDate("2007-01-16");
        Date to2 = TestHelper.getDate("2008-02-15");
        this.checkFormat("12 Months 4 Weeks 2 Days", from2, to2, false, true, true, true);
        Date from3 = TestHelper.getDate("2007-01-16");
        Date to3 = TestHelper.getDate("2008-03-15");
        this.checkFormat("13 Months 4 Weeks", from3, to3, false, true, true, true);
    }

    @Test
    public void testEmpty() {
        Date from = TestHelper.getDate("2008-01-01");
        this.checkFormat("", from, from, false, false, false, false);
    }

    private void checkFormat(String expected, Date from, Date to, boolean showYears, boolean showMonths, boolean showWeeks, boolean showDays) {
        DateDurationFormatter formatter = new DateDurationFormatter(showYears, showMonths, showWeeks, showDays);
        String result = formatter.format(from, to);
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

