/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.user;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.openvpms.archetype.function.expression.ExpressionFunctions;
import org.openvpms.archetype.function.user.CachingUserFunctions;
import org.openvpms.archetype.function.user.UserFunctions;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.ImageService;
import org.openvpms.archetype.rules.doc.TestImageService;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.user.TestUserBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class UserFunctionsTestCase
extends ArchetypeServiceTest {
    @Rule
    public TemporaryFolder dir = new TemporaryFolder();
    @Autowired
    private DocumentHandlers documentHandlers;
    @Autowired
    private UserRules userRules;
    @Autowired
    private TestUserFactory userFactory;
    private PracticeService practiceService;
    private Party practice;

    @Before
    public void setUp() {
        this.practice = this.create("party.organisationPractice", Party.class);
        this.practiceService = (PracticeService)Mockito.mock(PracticeService.class);
        Mockito.when((Object)this.practiceService.getPractice()).thenReturn((Object)this.practice);
    }

    @Test
    public void testFormat() {
        User user1 = this.createUser("Dr Jo Bloggs Name", "Dr Jo Bloggs Desc, BVSc MVS", "Dr", "Jo", "Bloggs", "BVSc MVS");
        User user2 = this.createUser("Fred Smith Name", "Fred Smith Desc", null, "Fred", "Smith", null);
        User user3 = this.createUser("M Foo", "Dr M Foo, BVSc MVS", null, null, null, null);
        Lookup shortFormat = this.createUserNameFormat("NAME", "expr:ifempty(expr:concatIf($firstName, ' ', $lastName), $name)");
        Lookup mediumFormat = this.createUserNameFormat("TITLE_NAME", "concat(\n     expr:concatIf($title,' '), \n     expr:ifempty(expr:concatIf($firstName, ' ', $lastName), $name))\n");
        Lookup longFormat = this.createUserNameFormat("TITLE_NAME_QUALIFICATIONS", "concat(\n     expr:concatIf($title,' '), \n     expr:ifempty(expr:concatIf($firstName, ' ', $lastName), $name),\n     expr:concatIf(', ', $qualifications))\n");
        IMObjectBean bean = this.getBean((IMObject)this.practice);
        bean.setValue("shortUserNameFormat", (Object)shortFormat.getCode());
        bean.setValue("mediumUserNameFormat", (Object)mediumFormat.getCode());
        bean.setValue("longUserNameFormat", (Object)longFormat.getCode());
        this.checkFormat(user1, "short", "Jo Bloggs");
        this.checkFormat(user1, "medium", "Dr Jo Bloggs");
        this.checkFormat(user1, "long", "Dr Jo Bloggs, BVSc MVS");
        this.checkFormat(user2, "short", "Fred Smith");
        this.checkFormat(user2, "medium", "Fred Smith");
        this.checkFormat(user2, "long", "Fred Smith");
        this.checkFormat(user3, "short", "M Foo");
        this.checkFormat(user3, "medium", "M Foo");
        this.checkFormat(user3, "long", "M Foo");
    }

    @Test
    public void testUsername() {
        User user = this.userFactory.createUser();
        Lookup shortFormat = this.createUserNameFormat("USERNAME", "$username");
        IMObjectBean bean = this.getBean((IMObject)this.practice);
        bean.setValue("shortUserNameFormat", (Object)shortFormat.getCode());
        this.checkFormat(user, "short", user.getUsername());
    }

    @Test
    public void testDescription() {
        User user = this.createUser("Dr Jo Bloggs Name", "Dr Jo Bloggs Desc, BVSc MVS", "Dr", "Jo", "Bloggs", "BVSc MVS");
        Lookup shortFormat = this.createUserNameFormat("DESCRIPTION", "$description");
        IMObjectBean bean = this.getBean((IMObject)this.practice);
        bean.setValue("longUserNameFormat", (Object)shortFormat.getCode());
        this.checkFormat(user, "long", "Dr Jo Bloggs Desc, BVSc MVS");
    }

    @Test
    public void testSignature() throws MalformedURLException {
        User user1 = this.userFactory.createUser();
        User user2 = (User)this.userFactory.newUser().signature().build();
        JXPathContext context = JXPathHelper.newContext((Object)new Object(), (Functions)this.createFunctions(false));
        context.getVariables().declareVariable("user1", (Object)user1);
        context.getVariables().declareVariable("user2", (Object)user2);
        Assert.assertNull((Object)context.getValue("user:signature(.)"));
        Assert.assertNull((Object)context.getValue("user:signature($user1)"));
        Assert.assertNull((Object)context.getValue("user:signature(" + user1.getId() + ")"));
        DocumentAct signature = this.userRules.getSignature(user2);
        Assert.assertNotNull((Object)signature);
        URL expected = new URL(this.dir.getRoot().toURI().toURL(), signature.getId() + "_" + signature.getVersion() + "_" + signature.getName());
        Assert.assertEquals((Object)expected, (Object)context.getValue("user:signature($user2)"));
        Assert.assertEquals((Object)expected, (Object)context.getValue("user:signature(" + user2.getId() + ")"));
    }

    private void checkFormat(User user, String style, String expected) {
        this.checkFormat(user, style, expected, false);
        this.checkFormat(user, style, expected, true);
    }

    private void checkFormat(User user, String style, String expected, boolean cache) {
        Functions functions = this.createFunctions(cache);
        JXPathContext context1 = JXPathHelper.newContext((Object)user, (Functions)functions);
        Assert.assertEquals((Object)expected, (Object)context1.getValue("user:format(., '" + style + "')"));
        JXPathContext context2 = JXPathHelper.newContext((Object)new Object(), (Functions)functions);
        Assert.assertEquals((Object)expected, (Object)context2.getValue("user:format(" + user.getId() + ", '" + style + "')"));
    }

    private Functions createFunctions(boolean cache) {
        TestImageService imageService;
        FunctionLibrary library = new FunctionLibrary();
        try {
            imageService = new TestImageService(this.dir.getRoot(), this.documentHandlers, (ArchetypeService)this.getArchetypeService());
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to create image service: " + exception.getMessage(), exception);
        }
        if (cache) {
            library.addFunctions((Functions)new CachingUserFunctions(this.userRules, (ArchetypeService)this.getArchetypeService(), this.practiceService, this.getLookupService(), (ImageService)imageService, (Functions)library, 1024));
        } else {
            library.addFunctions((Functions)new UserFunctions(this.userRules, (ArchetypeService)this.getArchetypeService(), this.practiceService, this.getLookupService(), (ImageService)imageService, (Functions)library));
        }
        library.addFunctions((Functions)new ExpressionFunctions("expr"));
        return library;
    }

    private Lookup createUserNameFormat(String code, String expression) {
        Lookup lookup = TestHelper.getLookup("lookup.userNameFormat", code, false);
        IMObjectBean bean = this.getBean((IMObject)lookup);
        bean.setValue("expression", (Object)expression);
        bean.save();
        return lookup;
    }

    private User createUser(String name, String description, String title, String firstName, String lastName, String qualifications) {
        return (User)((TestUserBuilder)((TestUserBuilder)this.userFactory.newUser().title(title != null ? title.toUpperCase() : null).name(name)).description(description)).firstName(firstName).lastName(lastName).qualifications(qualifications).build();
    }
}

