/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.patient;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.function.date.DateFunctions;
import org.openvpms.archetype.function.patient.PatientFunctions;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientAgeFormatter;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientAlertBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientAlertTypeBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.patient.TestWeightBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.component.business.service.archetype.ArchetypeServiceFunctions;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientFunctionsTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;

    @Test
    public void testAge() {
        Date today = DateRules.getToday();
        Date yearAgo = DateRules.getDate((Date)today, (int)-1, (DateUnits)DateUnits.YEARS);
        Date monthAgo = DateRules.getDate((Date)today, (int)-1, (DateUnits)DateUnits.MONTHS);
        Date threeMonthsAgo = DateRules.getDate((Date)today, (int)-3, (DateUnits)DateUnits.MONTHS);
        Date fiveMonthsAgo = DateRules.getDate((Date)today, (int)-5, (DateUnits)DateUnits.MONTHS);
        Party patient = (Party)this.patientFactory.newPatient().dateOfBirth(yearAgo).build();
        Act event = this.patientFactory.createVisit(patient);
        JXPathContext context1 = this.createContext(patient);
        JXPathContext context2 = this.createContext(event);
        JXPathContext context3 = this.createContext(null);
        JXPathContext context4 = this.createContext(this.create("act.patientClinicalEvent"));
        context1.getVariables().declareVariable("date1", (Object)monthAgo);
        context1.getVariables().declareVariable("anull", null);
        context2.getVariables().declareVariable("date1", (Object)monthAgo);
        context1.getVariables().declareVariable("date2", (Object)fiveMonthsAgo);
        context2.getVariables().declareVariable("date2", (Object)fiveMonthsAgo);
        context3.getVariables().declareVariable("anull", null);
        context4.getVariables().declareVariable("anull", null);
        Assert.assertEquals((Object)"12 Months", (Object)context1.getValue("patient:age()"));
        Assert.assertEquals((Object)"12 Months", (Object)context1.getValue("patient:age(.)"));
        Assert.assertEquals((Object)"12 Months", (Object)context2.getValue("patient:age(openvpms:get(., 'patient.entity'))"));
        Assert.assertEquals((Object)"11 Months", (Object)context1.getValue("patient:age(., $date1)"));
        Assert.assertEquals((Object)"12 Months", (Object)context1.getValue("patient:age(., $anull)"));
        Assert.assertEquals((Object)"11 Months", (Object)context2.getValue("patient:age(openvpms:get(., 'patient.entity'), $date1)"));
        this.patientFactory.updatePatient(patient).dateOfDeath(threeMonthsAgo).build();
        Assert.assertEquals((Object)"9 Months", (Object)context1.getValue("patient:age()"));
        Assert.assertEquals((Object)"9 Months", (Object)context1.getValue("patient:age(.)"));
        Assert.assertEquals((Object)"9 Months", (Object)context2.getValue("patient:age(openvpms:get(., 'patient.entity'))"));
        Assert.assertEquals((Object)"9 Months", (Object)context1.getValue("patient:age(., $date1)"));
        Assert.assertEquals((Object)"9 Months", (Object)context1.getValue("patient:age(., null)"));
        Assert.assertEquals((Object)"9 Months", (Object)context1.getValue("patient:age(., $anull)"));
        Assert.assertEquals((Object)"9 Months", (Object)context2.getValue("patient:age(openvpms:get(., 'patient.entity'), $date1)"));
        Assert.assertEquals((Object)"7 Months", (Object)context1.getValue("patient:age(., $date2)"));
        Assert.assertEquals((Object)"7 Months", (Object)context2.getValue("patient:age(openvpms:get(., 'patient.entity'), $date2)"));
        Assert.assertNull((Object)context3.getValue("patient:age()"));
        Assert.assertNull((Object)context3.getValue("patient:age(.)"));
        Assert.assertNull((Object)context3.getValue("patient:age(., null)"));
        Assert.assertNull((Object)context3.getValue("patient:age(., $anull)"));
        Assert.assertNull((Object)context4.getValue("patient:age()"));
        Assert.assertNull((Object)context4.getValue("patient:age(openvpms:get(., 'patient.entity'))"));
        Assert.assertNull((Object)context4.getValue("patient:age(openvpms:get(., 'patient.entity', $anull))"));
        Assert.assertNull((Object)context4.getValue("patient:age(openvpms:get(., 'patient.entity', null))"));
    }

    @Test
    public void testAlerts() {
        Party patient = this.patientFactory.createPatient();
        Act event = this.patientFactory.createVisit(patient);
        Date date1 = DateRules.getDate((Date)DateRules.getToday(), (int)-12, (DateUnits)DateUnits.MONTHS);
        Date date2 = DateRules.getDate((Date)DateRules.getToday(), (int)-9, (DateUnits)DateUnits.MONTHS);
        Date date3 = DateRules.getDate((Date)DateRules.getToday(), (int)-6, (DateUnits)DateUnits.MONTHS);
        Date date4 = DateRules.getDate((Date)DateRules.getToday(), (int)-3, (DateUnits)DateUnits.MONTHS);
        this.checkIterable(patient, "patient:alerts()", new Object[0]);
        this.checkIterable(patient, "patient:alerts(.)", new Object[0]);
        this.checkIterable(event, "patient:alerts(patient:get())", new Object[0]);
        this.checkIterable(event, "patient:alerts()", new Object[0]);
        Act alert1 = this.createAlert(patient, date1, this.createAlertType("Z Alert 1"));
        Act alert2 = this.createAlert(patient, date2, this.createAlertType("Z Alert 2"));
        Act alert3 = this.createAlert(patient, date3, this.createAlertType("Z Alert 3"));
        Act alert4 = this.createAlert(patient, date4, this.createAlertType("Z Alert 3"));
        this.checkIterable(patient, "patient:alerts()", alert1, alert2, alert3, alert4);
        this.checkIterable(patient, "patient:alerts(.)", alert1, alert2, alert3, alert4);
        this.checkIterable(event, "patient:alerts(patient:get())", alert1, alert2, alert3, alert4);
        alert3.setStatus("COMPLETED");
        this.save((IMObject)alert3);
        this.checkIterable(patient, "patient:alerts()", alert1, alert2, alert4);
        this.checkIterable(patient, "patient:alerts(.)", alert1, alert2, alert4);
        this.checkIterable(event, "patient:alerts(patient:get())", alert1, alert2, alert4);
        alert1.setActivityStartTime(DateRules.getYesterday());
        alert1.setActivityEndTime(DateRules.getToday());
        this.save((IMObject)alert1);
        this.checkIterable(patient, "patient:alerts()", alert2, alert4);
        this.checkIterable(patient, "patient:alerts(.)", alert2, alert4);
        this.checkIterable(event, "patient:alerts(patient:get())", alert2, alert4);
        alert4.setActivityStartTime(DateRules.getTomorrow());
        alert4.setActivityEndTime(DateRules.getNextDate((Date)DateRules.getTomorrow()));
        this.save((IMObject)alert4);
        this.checkIterable(patient, "patient:alerts()", alert2);
        this.checkIterable(patient, "patient:alerts(.)", alert2);
        this.checkIterable(event, "patient:alerts(patient:get())", alert2);
        this.checkIterable(null, "patient:alerts()", new Object[0]);
        this.checkIterable(null, "patient:alerts(.)", new Object[0]);
        this.checkIterable(this.create("act.patientClinicalEvent"), "patient:alerts(patient:get())", new Object[0]);
    }

    @Test
    public void testAppointments() {
        Party customer1 = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(customer1);
        Party customer2 = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient();
        Party location = this.practiceFactory.createLocation();
        Entity schedule = this.schedulingFactory.createSchedule(location);
        Date now = new Date();
        Act act1a = ScheduleTestHelper.createAppointment(DateRules.getDate((Date)now, (int)-1, (DateUnits)DateUnits.HOURS), schedule, customer1, patient1, "PENDING");
        Act act1b = ScheduleTestHelper.createAppointment(DateRules.getDate((Date)now, (int)6, (DateUnits)DateUnits.MONTHS), schedule, customer1, patient1, "PENDING");
        Act act1c = ScheduleTestHelper.createAppointment(DateRules.getDate((Date)now, (int)9, (DateUnits)DateUnits.MONTHS), schedule, customer1, null, "PENDING");
        Act act1d = ScheduleTestHelper.createAppointment(DateRules.getDate((Date)now, (int)2, (DateUnits)DateUnits.YEARS), schedule, customer1, patient1, "PENDING");
        Act act2a = ScheduleTestHelper.createAppointment(DateRules.getDate((Date)now, (int)-1, (DateUnits)DateUnits.YEARS), schedule, customer2, patient2, "PENDING");
        Act act2b = ScheduleTestHelper.createAppointment(DateRules.getDate((Date)now, (int)1, (DateUnits)DateUnits.MONTHS), schedule, customer2, patient2, "PENDING");
        Act act2c = ScheduleTestHelper.createAppointment(DateRules.getDate((Date)now, (int)6, (DateUnits)DateUnits.MONTHS), schedule, customer2, patient2, "PENDING");
        act2b.setStatus("CANCELLED");
        this.save((IMObject[])new Act[]{act1a, act1b, act1c, act1d, act2a, act2b, act2c});
        this.checkIterable(customer1, "patient:appointments(., 1, 'YEARS')", new Object[0]);
        this.checkIterable(patient1, "patient:appointments(., 3, 'YEARS')", act1b, act1d);
        this.checkIterable(patient2, "patient:appointments(., 1, 'YEARS')", act2c);
        this.checkIterable(null, "patient:appointments(., 1, 'YEARS')", new Object[0]);
        this.checkIterable(patient2, "patient:appointments(null, 1, 'YEARS')", new Object[0]);
    }

    @Test
    public void testGet() {
        Party patient = this.patientFactory.createPatient();
        Party customer = this.customerFactory.createCustomer();
        Act event = this.patientFactory.createVisit(patient);
        JXPathContext context1 = this.createContext(patient);
        JXPathContext context2 = this.createContext(event);
        JXPathContext context3 = this.createContext(customer);
        JXPathContext context4 = this.createContext(null);
        Assert.assertEquals((Object)patient, (Object)context1.getValue("patient:get()"));
        Assert.assertEquals((Object)patient, (Object)context1.getValue("patient:get(.)"));
        Assert.assertEquals((Object)patient, (Object)context2.getValue("patient:get()"));
        Assert.assertEquals((Object)patient, (Object)context2.getValue("patient:get(.)"));
        Assert.assertNull((Object)context3.getValue("patient:get()"));
        Assert.assertNull((Object)context3.getValue("patient:get(.)"));
        Assert.assertNull((Object)context4.getValue("patient:get()"));
        Assert.assertNull((Object)context4.getValue("patient:get(.)"));
    }

    @Test
    public void testIdentity() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Act act = this.create("act.customerEstimationItem", Act.class);
        JXPathContext context1 = this.createContext(patient);
        JXPathContext context2 = this.createContext(act);
        JXPathContext context3 = this.createContext(null);
        Assert.assertNull((Object)context1.getValue("patient:identity('entityIdentity.petTag')"));
        Assert.assertNull((Object)context1.getValue("patient:identity(., 'entityIdentity.petTag')"));
        Assert.assertNull((Object)context2.getValue("patient:identity(patient:get(), 'entityIdentity.petTag')"));
        EntityIdentity tag = this.patientFactory.createPetTag("1234567");
        patient.addIdentity(tag);
        this.save((IMObject)patient);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        Assert.assertEquals((Object)tag, (Object)context1.getValue("patient:identity('entityIdentity.petTag')"));
        Assert.assertEquals((Object)tag, (Object)context1.getValue("patient:identity(., 'entityIdentity.petTag')"));
        Assert.assertEquals((Object)tag, (Object)context2.getValue("patient:identity(patient:get(), 'entityIdentity.petTag')"));
        Assert.assertNull((Object)context1.getValue("patient:identity(null)"));
        Assert.assertNull((Object)context3.getValue("patient:identity(null, 'entityIdentity.petTag')"));
        Assert.assertNull((Object)context3.getValue("patient:identity(., 'entityIdentity.petTag')"));
    }

    @Test
    public void testIdentities() {
        Party patient = this.patientFactory.createPatient();
        Act act = this.create("act.customerEstimationItem", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        this.checkIterable(patient, "patient:identities('entityIdentity.petTag')", new Object[0]);
        this.checkIterable(patient, "patient:identities(., 'entityIdentity.petTag')", new Object[0]);
        this.checkIterable(act, "patient:identities(patient:get(), 'entityIdentity.petTag')", new Object[0]);
        EntityIdentity tag1 = this.patientFactory.createPetTag("1234567");
        patient.addIdentity(tag1);
        this.save((IMObject)patient);
        EntityIdentity tag2 = this.patientFactory.createPetTag("9876543");
        patient.addIdentity(tag2);
        this.save((IMObject)patient);
        this.checkIterable(patient, "patient:identities('entityIdentity.petTag')", tag2, tag1);
        this.checkIterable(patient, "patient:identities(., 'entityIdentity.petTag')", tag2, tag1);
        this.checkIterable(act, "patient:identities(patient:get(), 'entityIdentity.petTag')", tag2, tag1);
        tag1.setActive(false);
        this.save((IMObject)patient);
        this.checkIterable(patient, "patient:identities('entityIdentity.petTag')", tag2);
        this.checkIterable(patient, "patient:identities(., 'entityIdentity.petTag')", tag2);
        this.checkIterable(act, "patient:identities(patient:get(), 'entityIdentity.petTag')", tag2);
        this.checkIterable(null, "patient:identities(null)", new Object[0]);
        this.checkIterable(null, "patient:identities('entityIdentity.petTag')", new Object[0]);
        this.checkIterable(act, "patient:identities(null)", new Object[0]);
    }

    @Test
    public void testLocation() {
        Party owner = this.customerFactory.createCustomer();
        Party customer1 = this.customerFactory.createCustomer();
        Party customer2 = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient();
        JXPathContext context1 = this.createContext(patient);
        Assert.assertNull((Object)context1.getValue("patient:location()"));
        Assert.assertNull((Object)context1.getValue("patient:location(.)"));
        this.patientFactory.updatePatient(patient).owner(owner).addLocation(customer1, DateRules.getYesterday(), DateRules.getToday()).addLocation(customer2, DateRules.getToday(), null).build();
        Assert.assertEquals((Object)customer2, (Object)context1.getValue("patient:location()"));
        Assert.assertEquals((Object)customer2, (Object)context1.getValue("patient:location(.)"));
        Assert.assertEquals((Object)customer1, (Object)context1.getValue("patient:location(., date:yesterday())"));
        Assert.assertEquals((Object)customer2, (Object)context1.getValue("patient:location(., date:now())"));
        Assert.assertEquals((Object)customer2, (Object)context1.getValue("patient:location(., null)"));
        Assert.assertNull((Object)context1.getValue("patient:location(null)"));
        Assert.assertNull((Object)context1.getValue("patient:location(null, null)"));
        Assert.assertEquals((Object)customer2, (Object)context1.getValue("patient:location()"));
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(customer2).active(false)).build();
        Assert.assertNull((Object)context1.getValue("patient:location()"));
        Assert.assertEquals((Object)customer2, (Object)context1.getValue("patient:location(., date:today())"));
    }

    @Test
    public void testMicrochip() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Act act = this.create("act.customerEstimationItem", Act.class);
        JXPathContext context1 = this.createContext(patient);
        JXPathContext context2 = this.createContext(act);
        JXPathContext context3 = this.createContext(null);
        Assert.assertNull((Object)context1.getValue("patient:microchip()"));
        Assert.assertNull((Object)context1.getValue("patient:microchip(.)"));
        Assert.assertNull((Object)context2.getValue("patient:microchip(patient:get())"));
        EntityIdentity microchip = this.patientFactory.createMicrochip("1234567");
        patient.addIdentity(microchip);
        this.save((IMObject)patient);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        Assert.assertEquals((Object)microchip, (Object)context1.getValue("patient:microchip()"));
        Assert.assertEquals((Object)microchip, (Object)context1.getValue("patient:microchip(.)"));
        Assert.assertEquals((Object)microchip, (Object)context2.getValue("patient:microchip(patient:get())"));
        Assert.assertNull((Object)context1.getValue("patient:microchip(null)"));
        Assert.assertNull((Object)context3.getValue("patient:microchip()"));
        Assert.assertNull((Object)context3.getValue("patient:microchip(.)"));
    }

    @Test
    public void testMicrochips() {
        Party patient = this.patientFactory.createPatient();
        Act act = this.create("act.customerEstimationItem", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        this.checkIterable(patient, "patient:microchips()", new Object[0]);
        this.checkIterable(patient, "patient:microchips(.)", new Object[0]);
        this.checkIterable(act, "patient:microchips(patient:get())", new Object[0]);
        EntityIdentity microchip1 = this.patientFactory.createMicrochip("1234567");
        patient.addIdentity(microchip1);
        this.save((IMObject)patient);
        EntityIdentity microchip2 = this.patientFactory.createMicrochip("9876543");
        patient.addIdentity(microchip2);
        this.save((IMObject)patient);
        this.checkIterable(patient, "patient:microchips()", microchip2, microchip1);
        this.checkIterable(patient, "patient:microchips(.)", microchip2, microchip1);
        this.checkIterable(act, "patient:microchips(patient:get())", microchip2, microchip1);
        microchip1.setActive(false);
        this.save((IMObject)patient);
        this.checkIterable(patient, "patient:microchips()", microchip2);
        this.checkIterable(patient, "patient:microchips(.)", microchip2);
        this.checkIterable(act, "patient:microchips(patient:get())", microchip2);
        this.checkIterable(null, "patient:microchips()", new Object[0]);
        this.checkIterable(null, "patient:microchips(.)", new Object[0]);
        this.checkIterable(act, "patient:microchips(null)", new Object[0]);
    }

    @Test
    public void testOwner() {
        Party customer1 = this.customerFactory.createCustomer();
        Party customer2 = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient();
        JXPathContext context1 = this.createContext(patient);
        Assert.assertNull((Object)context1.getValue("patient:owner()"));
        Assert.assertNull((Object)context1.getValue("patient:owner(.)"));
        this.patientFactory.updatePatient(patient).addOwner(customer1, DateRules.getYesterday(), DateRules.getToday()).addOwner(customer2, DateRules.getToday(), null).build();
        Assert.assertEquals((Object)customer2, (Object)context1.getValue("patient:owner()"));
        Assert.assertEquals((Object)customer2, (Object)context1.getValue("patient:owner(.)"));
        Assert.assertEquals((Object)customer1, (Object)context1.getValue("patient:owner(., date:yesterday())"));
        Assert.assertEquals((Object)customer2, (Object)context1.getValue("patient:owner(., date:now())"));
        Assert.assertNull((Object)context1.getValue("patient:owner(null)"));
        Assert.assertNull((Object)context1.getValue("patient:owner(null, null)"));
    }

    @Test
    public void testPetTag() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Act act = this.create("act.customerEstimationItem", Act.class);
        JXPathContext context1 = this.createContext(patient);
        JXPathContext context2 = this.createContext(act);
        JXPathContext context3 = this.createContext(null);
        Assert.assertNull((Object)context1.getValue("patient:petTag()"));
        Assert.assertNull((Object)context1.getValue("patient:petTag(.)"));
        Assert.assertNull((Object)context2.getValue("patient:petTag(patient:get())"));
        EntityIdentity tag = this.patientFactory.createPetTag("1234567");
        patient.addIdentity(tag);
        this.save((IMObject)patient);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        Assert.assertEquals((Object)tag, (Object)context1.getValue("patient:petTag()"));
        Assert.assertEquals((Object)tag, (Object)context1.getValue("patient:petTag(.)"));
        Assert.assertEquals((Object)tag, (Object)context2.getValue("patient:petTag(patient:get())"));
        Assert.assertNull((Object)context1.getValue("patient:petTag(null)"));
        Assert.assertNull((Object)context3.getValue("patient:petTag()"));
        Assert.assertNull((Object)context3.getValue("patient:petTag(.)"));
    }

    @Test
    public void testPetTags() {
        Party patient = this.patientFactory.createPatient();
        Act act = this.create("act.customerEstimationItem", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        this.checkIterable(patient, "patient:petTags()", new Object[0]);
        this.checkIterable(patient, "patient:petTags(.)", new Object[0]);
        this.checkIterable(act, "patient:petTags(patient:get())", new Object[0]);
        EntityIdentity tag1 = this.patientFactory.createPetTag("1234567");
        patient.addIdentity(tag1);
        this.save((IMObject)patient);
        EntityIdentity tag2 = this.patientFactory.createPetTag("9876543");
        patient.addIdentity(tag2);
        this.save((IMObject)patient);
        this.checkIterable(patient, "patient:petTags()", tag2, tag1);
        this.checkIterable(patient, "patient:petTags(.)", tag2, tag1);
        this.checkIterable(act, "patient:petTags(patient:get())", tag2, tag1);
        tag1.setActive(false);
        this.save((IMObject)patient);
        this.checkIterable(patient, "patient:petTags()", tag2);
        this.checkIterable(patient, "patient:petTags(.)", tag2);
        this.checkIterable(act, "patient:petTags(patient:get())", tag2);
        this.checkIterable(null, "patient:petTags()", new Object[0]);
        this.checkIterable(null, "patient:petTags(.)", new Object[0]);
        this.checkIterable(act, "patient:petTags(null)", new Object[0]);
    }

    @Test
    public void testRabiesTag() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Act act = this.create("act.customerEstimationItem", Act.class);
        JXPathContext context1 = this.createContext(patient);
        JXPathContext context2 = this.createContext(act);
        JXPathContext context3 = this.createContext(null);
        Assert.assertNull((Object)context1.getValue("patient:rabiesTag()"));
        Assert.assertNull((Object)context1.getValue("patient:rabiesTag(.)"));
        Assert.assertNull((Object)context2.getValue("patient:rabiesTag(patient:get())"));
        EntityIdentity tag = this.patientFactory.createRabiesTag("1234567");
        patient.addIdentity(tag);
        this.getArchetypeService().save((IMObject)patient, false);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        Assert.assertEquals((Object)tag, (Object)context1.getValue("patient:rabiesTag()"));
        Assert.assertEquals((Object)tag, (Object)context1.getValue("patient:rabiesTag(.)"));
        Assert.assertEquals((Object)tag, (Object)context2.getValue("patient:rabiesTag(patient:get())"));
        Assert.assertNull((Object)context1.getValue("patient:rabiesTag(null)"));
        Assert.assertNull((Object)context3.getValue("patient:rabiesTag()"));
        Assert.assertNull((Object)context3.getValue("patient:rabiesTag(.)"));
    }

    @Test
    public void testRabiesTags() {
        Party patient = this.patientFactory.createPatient();
        Act act = this.create("act.customerEstimationItem", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        this.checkIterable(patient, "patient:rabiesTags()", new Object[0]);
        this.checkIterable(patient, "patient:rabiesTags(.)", new Object[0]);
        this.checkIterable(act, "patient:rabiesTags(patient:get())", new Object[0]);
        EntityIdentity tag1 = this.patientFactory.createRabiesTag("1234567");
        patient.addIdentity(tag1);
        IArchetypeService service = this.getArchetypeService();
        service.save((IMObject)patient, false);
        EntityIdentity tag2 = this.patientFactory.createRabiesTag("9876543");
        patient.addIdentity(tag2);
        service.save((IMObject)patient, false);
        this.checkIterable(patient, "patient:rabiesTags()", tag2, tag1);
        this.checkIterable(patient, "patient:rabiesTags(.)", tag2, tag1);
        this.checkIterable(act, "patient:rabiesTags(patient:get())", tag2, tag1);
        tag1.setActive(false);
        service.save((IMObject)patient, false);
        this.checkIterable(patient, "patient:rabiesTags()", tag2);
        this.checkIterable(patient, "patient:rabiesTags(.)", tag2);
        this.checkIterable(act, "patient:rabiesTags(patient:get())", tag2);
        this.checkIterable(null, "patient:rabiesTags()", new Object[0]);
        this.checkIterable(null, "patient:rabiesTags(.)", new Object[0]);
        this.checkIterable(act, "patient:rabiesTags(null)", new Object[0]);
    }

    @Test
    public void testReferral() {
        Party patient = this.patientFactory.createPatient();
        Party vet = this.supplierFactory.createVet();
        Party practice = this.supplierFactory.createVetPractice();
        Act act = this.create("act.customerEstimationItem", Act.class);
        JXPathContext context1 = this.createContext(patient);
        JXPathContext context2 = this.createContext(act);
        Assert.assertNull((Object)context1.getValue("patient:referral()"));
        Assert.assertNull((Object)context1.getValue("patient:referral(.)"));
        Assert.assertNull((Object)context2.getValue("patient:referral(patient:get())"));
        IMObjectBean bean = this.getBean((IMObject)patient);
        PeriodRelationship referrals = (PeriodRelationship)bean.addTarget("referrals", "entityRelationship.referredFrom", (IMObject)vet);
        referrals.setActiveStartTime(DateRules.getToday());
        IMObjectBean practiceBean = this.getBean((IMObject)practice);
        PeriodRelationship veterinarians = (PeriodRelationship)practiceBean.addTarget("veterinarians", (IMObject)vet);
        veterinarians.setActiveStartTime(DateRules.getToday());
        this.save((IMObject[])new Party[]{patient, vet, practice});
        IMObjectBean actBean = this.getBean((IMObject)act);
        actBean.setTarget("patient", (IMObject)patient);
        Assert.assertEquals((Object)vet, (Object)context1.getValue("patient:referral()"));
        Assert.assertEquals((Object)vet, (Object)context1.getValue("patient:referral(.)"));
        Assert.assertEquals((Object)practice, (Object)context1.getValue("patient:referral(., true())"));
        Assert.assertEquals((Object)vet, (Object)context1.getValue("patient:referral(., false())"));
        Assert.assertEquals((Object)vet, (Object)context1.getValue("patient:referral(., date:today())"));
        Assert.assertEquals((Object)practice, (Object)context1.getValue("patient:referral(., true(), date:today())"));
        Assert.assertEquals((Object)vet, (Object)context1.getValue("patient:referral(., false(), date:today())"));
        Assert.assertNull((Object)context1.getValue("patient:referral(null)"));
        Assert.assertNull((Object)context1.getValue("patient:referral(., date:yesterday())"));
        Assert.assertNull((Object)context1.getValue("patient:referral(., true(), date:yesterday())"));
        Assert.assertNull((Object)context1.getValue("patient:referral(., false(), date:yesterday())"));
    }

    @Test
    public void testVisit() {
        Party patient = this.patientFactory.createPatient();
        JXPathContext context1 = this.createContext(patient);
        Assert.assertNull((Object)context1.getValue("patient:visit()"));
        Assert.assertNull((Object)context1.getValue("patient:visit(.)"));
        Act visit1 = (Act)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().startTime(DateRules.getYesterday())).patient(patient)).build();
        Assert.assertEquals((Object)visit1, (Object)context1.getValue("patient:visit()"));
        Assert.assertEquals((Object)visit1, (Object)context1.getValue("patient:visit(.)"));
        Act visit2 = (Act)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().startTime(DateRules.getToday())).patient(patient)).build();
        Assert.assertEquals((Object)visit2, (Object)context1.getValue("patient:visit()"));
        Assert.assertEquals((Object)visit2, (Object)context1.getValue("patient:visit(.)"));
        Assert.assertNull((Object)context1.getValue("patient:visit(null)"));
    }

    @Test
    public void testWeight() {
        Party patient = this.patientFactory.createPatient();
        Act visit = this.create("act.patientClinicalEvent", Act.class);
        IMObjectBean bean = this.getBean((IMObject)visit);
        bean.setTarget("patient", (IMObject)patient);
        JXPathContext context1 = this.createContext(patient);
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)context1.getValue("patient:weight()"));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)context1.getValue("patient:weight(.)"));
        Act weight1 = this.patientFactory.createWeight(patient, BigDecimal.ONE, WeightUnits.KILOGRAMS);
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("patient:weight()"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("patient:weight(.)"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("patient:weight(., 'KILOGRAMS')"));
        this.checkEquals(MathRules.ONE_THOUSAND, (BigDecimal)context1.getValue("patient:weight(., 'GRAMS')"));
        Assert.assertEquals((Object)new BigDecimal("2.20462262"), (Object)context1.getValue("patient:weight(., 'POUNDS')"));
        this.remove((IMObject)weight1);
        Act weight2 = this.patientFactory.createWeight(patient, MathRules.ONE_THOUSAND, WeightUnits.GRAMS);
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("patient:weight()"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("patient:weight(., 'KILOGRAMS')"));
        this.checkEquals(MathRules.ONE_THOUSAND, (BigDecimal)context1.getValue("patient:weight(., 'GRAMS')"));
        Assert.assertEquals((Object)new BigDecimal("2.20462262"), (Object)context1.getValue("patient:weight(., 'POUNDS')"));
        this.remove((IMObject)weight2);
        ((TestWeightBuilder)this.patientFactory.newWeight().patient(patient)).weight(BigDecimal.ONE, WeightUnits.POUNDS).build();
        this.checkEquals(Weight.ONE_POUND_IN_KILOS, (BigDecimal)context1.getValue("patient:weight()"));
        this.checkEquals(Weight.ONE_POUND_IN_KILOS, (BigDecimal)context1.getValue("patient:weight(.)"));
        this.checkEquals(Weight.ONE_POUND_IN_KILOS, (BigDecimal)context1.getValue("patient:weight(., 'KILOGRAMS')"));
        this.checkEquals(Weight.ONE_POUND_IN_GRAMS, (BigDecimal)context1.getValue("patient:weight(., 'GRAMS')"));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)context1.getValue("patient:weight(., 'POUNDS')"));
        this.checkEquals(BigDecimal.ZERO, (BigDecimal)context1.getValue("patient:weight(null)"));
        this.checkEquals(BigDecimal.ZERO, (BigDecimal)context1.getValue("patient:weight(null, 'KILOGRAMS')"));
    }

    private Entity createAlertType(String name) {
        return (Entity)((TestPatientAlertTypeBuilder)this.patientFactory.newAlertType().name(name)).build();
    }

    private Act createAlert(Party patient, Date date, Entity alertType) {
        return (Act)((TestPatientAlertBuilder)((TestPatientAlertBuilder)this.patientFactory.newAlert().patient(patient)).startTime(date)).alertType(alertType).build();
    }

    private <T> void checkIterable(Object object, String expression, T ... expected) {
        ArrayList actual = new ArrayList();
        JXPathContext context = this.createContext(object);
        Iterable value = (Iterable)context.getValue(expression);
        value.forEach(actual::add);
        Assert.assertArrayEquals((Object[])actual.toArray(), (Object[])expected);
    }

    private JXPathContext createContext(Object object) {
        IArchetypeService service = (IArchetypeService)this.applicationContext.getBean("archetypeService", IArchetypeService.class);
        LookupService lookups = this.getLookupService();
        PracticeRules practiceRules = (PracticeRules)Mockito.mock(PracticeRules.class);
        PracticeService practiceService = (PracticeService)Mockito.mock(PracticeService.class);
        PatientAgeFormatter formatter = new PatientAgeFormatter(this.getLookupService(), practiceRules, (ArchetypeService)service);
        PatientRules patientRules = new PatientRules(practiceRules, practiceService, service, this.getLookupService(), formatter);
        SupplierRules supplierRules = new SupplierRules(service);
        AppointmentRules appointmentRules = new AppointmentRules(service);
        MedicalRecordRules recordRules = new MedicalRecordRules(service);
        ArchetypeServiceFunctions functions = new ArchetypeServiceFunctions(service, lookups);
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new ObjectFunctions((Object)functions, "openvpms"));
        library.addFunctions((Functions)new PatientFunctions(patientRules, supplierRules, appointmentRules, recordRules, service));
        library.addFunctions((Functions)new ObjectFunctions((Object)new DateFunctions(), "date"));
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }
}

