/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.party;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.party.PartyFunctions;
import org.openvpms.archetype.rules.contact.AddressFormatter;
import org.openvpms.archetype.rules.contact.BasicAddressFormatter;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEstimateBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.party.TestContactFactory;
import org.openvpms.archetype.test.builder.party.TestLocationContactBuilder;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.ArchetypeServiceFunctions;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;
import org.springframework.beans.factory.annotation.Autowired;

public class PartyFunctionsTestCase
extends ArchetypeServiceTest {
    @Autowired
    private CustomerRules rules;
    @Autowired
    private PracticeService practiceService;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestContactFactory contactFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    private Party customer;
    private Party patient;
    private Act estimate;
    private Act item;

    @Before
    public void setUp() {
        this.customer = this.customerFactory.createCustomer("MR", "Foo", "Bar");
        this.patient = this.patientFactory.createPatient(this.customer);
        TestEstimateBuilder builder = this.accountFactory.newEstimate();
        this.estimate = (Act)builder.customer(this.customer).item().patient(this.patient).product(this.productFactory.createService()).highQuantity(1).fixedPrice(10).add().build();
        this.item = builder.getItems().get(0);
    }

    @Test
    public void testGetPartyFullName() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.estimate);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"Mr Foo Bar", (Object)context1.getValue("party:getPartyFullName()"));
        Assert.assertEquals((Object)"Mr Foo Bar", (Object)context2.getValue("party:getPartyFullName()"));
        Assert.assertEquals((Object)"Mr Foo Bar", (Object)context3.getValue("party:getPartyFullName()"));
        Assert.assertEquals((Object)"Mr Foo Bar", (Object)context1.getValue("party:getPartyFullName(.)"));
        Assert.assertEquals((Object)"Mr Foo Bar", (Object)context2.getValue("party:getPartyFullName(.)"));
        Assert.assertEquals((Object)"Mr Foo Bar", (Object)context3.getValue("party:getPartyFullName(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getPartyFullName(null)"));
    }

    @Test
    public void testGetPatientOwner() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)this.customer, (Object)context1.getValue("party:getPatientOwner()"));
        Assert.assertEquals((Object)this.customer, (Object)context2.getValue("party:getPatientOwner()"));
        Assert.assertEquals((Object)this.customer, (Object)context1.getValue("party:getPatientOwner(.)"));
        Assert.assertEquals((Object)this.customer, (Object)context2.getValue("party:getPatientOwner(.)"));
        Assert.assertNull((Object)context1.getValue("party:getPatientOwner(null)"));
    }

    @Test
    public void testGetTelephone() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.estimate);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getTelephone()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getTelephone()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getTelephone()"));
        this.customer.addContact(this.createPhone("12345", false, "HOME"));
        this.customer.addContact(this.createPhone("45678", true, null));
        this.save((org.openvpms.component.model.object.IMObject)this.customer);
        Assert.assertEquals((Object)"(03) 45678", (Object)context1.getValue("party:getTelephone(.)"));
        Assert.assertEquals((Object)"(03) 45678", (Object)context2.getValue("party:getTelephone(.)"));
        Assert.assertEquals((Object)"(03) 45678", (Object)context3.getValue("party:getTelephone(.)"));
        Assert.assertEquals((Object)"(03) 45678", (Object)context1.getValue("party:getTelephone()"));
        Assert.assertEquals((Object)"(03) 45678", (Object)context2.getValue("party:getTelephone()"));
        Assert.assertEquals((Object)"(03) 45678", (Object)context3.getValue("party:getTelephone()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getTelephone(null)"));
    }

    @Test
    public void testGetHomeTelephone() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.estimate);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getHomeTelephone()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getHomeTelephone()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getHomeTelephone()"));
        Contact home = this.createPhone("12345", true, "HOME");
        this.customer.addContact(home);
        this.save((org.openvpms.component.model.object.IMObject)this.customer);
        Assert.assertEquals((Object)"(03) 12345", (Object)context1.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"(03) 12345", (Object)context2.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"(03) 12345", (Object)context3.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"(03) 12345", (Object)context1.getValue("party:getHomeTelephone()"));
        Assert.assertEquals((Object)"(03) 12345", (Object)context2.getValue("party:getHomeTelephone()"));
        Assert.assertEquals((Object)"(03) 12345", (Object)context3.getValue("party:getHomeTelephone()"));
        this.customer.removeContact(home);
        this.save((org.openvpms.component.model.object.IMObject)this.customer);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getHomeTelephone()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getHomeTelephone()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getHomeTelephone()"));
        this.customer.addContact(this.createPhone("56789", true, "WORK"));
        this.save((org.openvpms.component.model.object.IMObject)this.customer);
        Assert.assertEquals((Object)"(03) 56789", (Object)context1.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context2.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context3.getValue("party:getHomeTelephone(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context1.getValue("party:getHomeTelephone()"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context2.getValue("party:getHomeTelephone()"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context3.getValue("party:getHomeTelephone()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getHomeTelephone(null)"));
    }

    @Test
    public void testGetWorkTelephone() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.estimate);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getWorkTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getWorkTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getWorkTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getWorkTelephone()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getWorkTelephone()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getWorkTelephone()"));
        this.customer.addContact(this.createPhone("56789", true, "WORK"));
        this.save((org.openvpms.component.model.object.IMObject)this.customer);
        Assert.assertEquals((Object)"(03) 56789", (Object)context1.getValue("party:getWorkTelephone(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context2.getValue("party:getWorkTelephone(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context3.getValue("party:getWorkTelephone(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context1.getValue("party:getWorkTelephone()"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context2.getValue("party:getWorkTelephone()"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context3.getValue("party:getWorkTelephone()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getWorkTelephone(null)"));
    }

    @Test
    public void testGetMobileTelephone() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.estimate);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getMobileTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getMobileTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getMobileTelephone(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getMobileTelephone()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getMobileTelephone()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getMobileTelephone()"));
        this.customer.addContact(this.createPhone("56789", true, "MOBILE"));
        this.save((org.openvpms.component.model.object.IMObject)this.customer);
        Assert.assertEquals((Object)"(03) 56789", (Object)context1.getValue("party:getMobileTelephone(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context2.getValue("party:getMobileTelephone(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context3.getValue("party:getMobileTelephone(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context1.getValue("party:getMobileTelephone()"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context2.getValue("party:getMobileTelephone()"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context3.getValue("party:getMobileTelephone()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getMobileTelephone(null)"));
    }

    @Test
    public void testGetFaxNumber() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.estimate);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getFaxNumber(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getFaxNumber(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getFaxNumber(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getFaxNumber()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getFaxNumber()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getFaxNumber()"));
        this.customer.addContact(this.createPhone("56789", true, "FAX"));
        this.save((org.openvpms.component.model.object.IMObject)this.customer);
        Assert.assertEquals((Object)"(03) 56789", (Object)context1.getValue("party:getFaxNumber(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context2.getValue("party:getFaxNumber(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context3.getValue("party:getFaxNumber(.)"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context1.getValue("party:getFaxNumber()"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context2.getValue("party:getFaxNumber()"));
        Assert.assertEquals((Object)"(03) 56789", (Object)context3.getValue("party:getFaxNumber()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getFaxNumber(null)"));
    }

    @Test
    public void testGetEmailAddress() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.estimate);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getEmailAddress(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getEmailAddress(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getEmailAddress(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getEmailAddress()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getEmailAddress()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getEmailAddress()"));
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(this.customer).addEmail("foo@bar.com", new String[0])).build();
        Assert.assertEquals((Object)"foo@bar.com", (Object)context1.getValue("party:getEmailAddress(.)"));
        Assert.assertEquals((Object)"foo@bar.com", (Object)context2.getValue("party:getEmailAddress(.)"));
        Assert.assertEquals((Object)"foo@bar.com", (Object)context3.getValue("party:getEmailAddress(.)"));
        Assert.assertEquals((Object)"foo@bar.com", (Object)context1.getValue("party:getEmailAddress()"));
        Assert.assertEquals((Object)"foo@bar.com", (Object)context2.getValue("party:getEmailAddress()"));
        Assert.assertEquals((Object)"foo@bar.com", (Object)context3.getValue("party:getEmailAddress()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getEmailAddress(null)"));
    }

    @Test
    public void testGetWebsite() {
        Party customer = this.customerFactory.createCustomer();
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)customer);
        Assert.assertEquals((Object)"", (Object)context.getValue("party:getWebsite(.)"));
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(customer).addWebsite("http://wwww.openvpms.org")).build();
        Assert.assertEquals((Object)"http://wwww.openvpms.org", (Object)context.getValue("party:getWebsite(.)"));
        Assert.assertEquals((Object)"", (Object)context.getValue("party:getWebsite(null)"));
    }

    @Test
    public void testGetContactPurposes() {
        Contact contact = this.contactFactory.createPhone("123456789");
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)contact);
        Assert.assertEquals((Object)"", (Object)context.getValue("party:getContactPurposes()"));
        ((TestPhoneContactBuilder)this.contactFactory.updatePhone(contact).purposes("HOME", "WORK")).build();
        Assert.assertEquals((Object)"(Home, Work)", (Object)context.getValue("party:getContactPurposes()"));
    }

    @Test
    public void testGetBillingAddress() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.estimate);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getBillingAddress(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getBillingAddress(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getBillingAddress(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getBillingAddress()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getBillingAddress()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getBillingAddress()"));
        this.lookupFactory.getState("NSW", "New South Wales");
        this.lookupFactory.getSuburb("SAWTELL", "Sawtell", "2452", "NSW");
        ((TestCustomerBuilder)((TestLocationContactBuilder)((TestCustomerBuilder)((TestLocationContactBuilder)this.customerFactory.updateCustomer(this.customer).newLocation("123 4th Avenue", "SAWTELL").purposes("BILLING", "HOME")).add()).newLocation("456 Main Rd", "SAWTELL").purposes("WORK")).add()).build();
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context1.getValue("party:getBillingAddress(.)"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context2.getValue("party:getBillingAddress(.)"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context3.getValue("party:getBillingAddress(.)"));
        Assert.assertEquals((Object)"123 4th Avenue, Sawtell New South Wales 2452", (Object)context1.getValue("party:getBillingAddress(., true())"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context1.getValue("party:getBillingAddress(., false())"));
        Assert.assertEquals((Object)"123 4th Avenue, Sawtell New South Wales 2452", (Object)context2.getValue("party:getBillingAddress(., true())"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context2.getValue("party:getBillingAddress(., false())"));
        Assert.assertEquals((Object)"123 4th Avenue, Sawtell New South Wales 2452", (Object)context3.getValue("party:getBillingAddress(., true())"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context3.getValue("party:getBillingAddress(., false())"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context1.getValue("party:getBillingAddress()"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context2.getValue("party:getBillingAddress()"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context3.getValue("party:getBillingAddress()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getBillingAddress(null)"));
    }

    @Test
    public void testGetCorrespondenceAddress() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.estimate);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getCorrespondenceAddress(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getCorrespondenceAddress(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getCorrespondenceAddress(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getCorrespondenceAddress()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getCorrespondenceAddress()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:getCorrespondenceAddress()"));
        this.lookupFactory.getState("NSW", "New South Wales");
        this.lookupFactory.getSuburb("SAWTELL", "Sawtell", "2452", "NSW");
        ((TestCustomerBuilder)((TestLocationContactBuilder)((TestCustomerBuilder)((TestLocationContactBuilder)this.customerFactory.updateCustomer(this.customer).newLocation("123 4th Avenue", "SAWTELL").purposes("CORRESPONDENCE", "HOME")).add()).newLocation("456 Main Rd", "SAWTELL").purposes("WORK")).add()).build();
        Assert.assertEquals((Object)"123 4th Avenue, Sawtell New South Wales 2452", (Object)context1.getValue("party:getCorrespondenceAddress(., true())"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context1.getValue("party:getCorrespondenceAddress(., false())"));
        Assert.assertEquals((Object)"123 4th Avenue, Sawtell New South Wales 2452", (Object)context2.getValue("party:getCorrespondenceAddress(., true())"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context2.getValue("party:getCorrespondenceAddress(., false())"));
        Assert.assertEquals((Object)"123 4th Avenue, Sawtell New South Wales 2452", (Object)context3.getValue("party:getCorrespondenceAddress(., true())"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context3.getValue("party:getCorrespondenceAddress(., false())"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context1.getValue("party:getCorrespondenceAddress()"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context2.getValue("party:getCorrespondenceAddress()"));
        Assert.assertEquals((Object)"123 4th Avenue\nSawtell New South Wales 2452", (Object)context3.getValue("party:getCorrespondenceAddress()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getCorrespondenceAddress(null)"));
    }

    @Test
    public void testGetPracticeAddress() {
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)new IMObject());
        ((TestPracticeBuilder)this.practiceFactory.newPractice().addAddress("123 Main Rd", "ELTHAM", "VIC", "3095", new String[0])).build();
        Assert.assertEquals((Object)"123 Main Rd, Eltham Vic 3095", (Object)context.getValue("party:getPracticeAddress()"));
        Assert.assertEquals((Object)"123 Main Rd, Eltham Vic 3095", (Object)context.getValue("party:getPracticeAddress(true())"));
        Assert.assertEquals((Object)"123 Main Rd\nEltham Vic 3095", (Object)context.getValue("party:getPracticeAddress(false())"));
    }

    @Test
    public void testIdentities() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        JXPathContext context3 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:identities(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:identities(.)"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:identities(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:identities()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:identities()"));
        Assert.assertEquals((Object)"", (Object)context3.getValue("party:identities()"));
        this.patientFactory.updatePatient(this.patient).addPetTag("1234567").build();
        this.customerFactory.updateCustomer(this.customer).addCodeIdentity("abc").addCodeIdentity("cdef").build();
        String petTag = "Pet Tag: 1234567";
        String code = "Code: abc, Code: cdef";
        Assert.assertEquals((Object)petTag, (Object)context1.getValue("party:identities(.)"));
        Assert.assertEquals((Object)petTag, (Object)context2.getValue("party:identities(.)"));
        Assert.assertEquals((Object)code, (Object)context3.getValue("party:identities(.)"));
        Assert.assertEquals((Object)petTag, (Object)context1.getValue("party:identities()"));
        Assert.assertEquals((Object)petTag, (Object)context2.getValue("party:identities()"));
        Assert.assertEquals((Object)code, (Object)context3.getValue("party:identities()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:identities(null)"));
    }

    @Test
    public void testGetPatientMicrochip() {
        Party patient = this.patientFactory.createPatient();
        JXPathContext ctx = this.createContext((org.openvpms.component.model.object.IMObject)patient);
        Assert.assertEquals((Object)"", (Object)ctx.getValue("party:getPatientMicrochip(.)"));
        Assert.assertEquals((Object)"", (Object)ctx.getValue("party:getPatientMicrochip()"));
        this.patientFactory.updatePatient(patient).addMicrochip("1234567").build();
        Assert.assertEquals((Object)"1234567", (Object)ctx.getValue("party:getPatientMicrochip(.)"));
        Assert.assertEquals((Object)"1234567", (Object)ctx.getValue("party:getPatientMicrochip()"));
        Assert.assertEquals((Object)"", (Object)ctx.getValue("party:getPatientMicrochip(null)"));
    }

    @Test
    public void testGetPatientMicrochips() {
        JXPathContext ctx = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        Assert.assertEquals((Object)"", (Object)ctx.getValue("party:getPatientMicrochips(.)"));
        this.patientFactory.updatePatient(this.patient).addMicrochip("123").build();
        Assert.assertEquals((Object)"123", (Object)ctx.getValue("party:getPatientMicrochips(.)"));
        this.patientFactory.updatePatient(this.patient).addMicrochip("456").build();
        Assert.assertEquals((Object)"456, 123", (Object)ctx.getValue("party:getPatientMicrochips(.)"));
        Assert.assertEquals((Object)"", (Object)ctx.getValue("party:getPatientMicrochips(null)"));
    }

    @Test
    public void testGetWeight() {
        Act visit = this.create("act.patientClinicalEvent", Act.class);
        IMObjectBean bean = this.getBean((org.openvpms.component.model.object.IMObject)visit);
        bean.setTarget("patient", (org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)visit);
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)context1.getValue("party:getWeight(.)"));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)context2.getValue("party:getWeight(.)"));
        Act weight1 = this.patientFactory.createWeight(this.patient, BigDecimal.ONE, WeightUnits.KILOGRAMS);
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("party:getWeight(.)"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("party:getWeight(., 'KILOGRAMS')"));
        this.checkEquals(MathRules.ONE_THOUSAND, (BigDecimal)context1.getValue("party:getWeight(., 'GRAMS')"));
        Assert.assertEquals((Object)new BigDecimal("2.20462262"), (Object)context1.getValue("party:getWeight(., 'POUNDS')"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context2.getValue("party:getWeight(.)"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context2.getValue("party:getWeight(., 'KILOGRAMS')"));
        this.checkEquals(MathRules.ONE_THOUSAND, (BigDecimal)context2.getValue("party:getWeight(., 'GRAMS')"));
        this.checkEquals("2.20462262", (BigDecimal)context2.getValue("party:getWeight(., 'POUNDS')"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("party:getWeight()"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context2.getValue("party:getWeight()"));
        this.checkEquals(BigDecimal.ZERO, (BigDecimal)context1.getValue("party:getWeight(null)"));
        this.checkEquals(BigDecimal.ZERO, (BigDecimal)context2.getValue("party:getWeight(null)"));
        this.checkEquals(BigDecimal.ZERO, (BigDecimal)context1.getValue("party:getWeight(null, 'KILOGRAMS')"));
        this.checkEquals(BigDecimal.ZERO, (BigDecimal)context2.getValue("party:getWeight(null, 'KILOGRAMS')"));
        this.remove((org.openvpms.component.model.object.IMObject)weight1);
        Act weight2 = this.patientFactory.createWeight(this.patient, MathRules.ONE_THOUSAND, WeightUnits.GRAMS);
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("party:getWeight(.)"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context1.getValue("party:getWeight(., 'KILOGRAMS')"));
        this.checkEquals(MathRules.ONE_THOUSAND, (BigDecimal)context1.getValue("party:getWeight(., 'GRAMS')"));
        this.checkEquals("2.20462262", (BigDecimal)context1.getValue("party:getWeight(., 'POUNDS')"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context2.getValue("party:getWeight(.)"));
        this.checkEquals(BigDecimal.ONE, (BigDecimal)context2.getValue("party:getWeight(., 'KILOGRAMS')"));
        this.checkEquals(MathRules.ONE_THOUSAND, (BigDecimal)context2.getValue("party:getWeight(., 'GRAMS')"));
        this.checkEquals("2.20462262", (BigDecimal)context2.getValue("party:getWeight(., 'POUNDS')"));
        this.remove((org.openvpms.component.model.object.IMObject)weight2);
        this.patientFactory.createWeight(this.patient, BigDecimal.ONE, WeightUnits.POUNDS);
        this.checkEquals(Weight.ONE_POUND_IN_KILOS, (BigDecimal)context1.getValue("party:getWeight(.)"));
        this.checkEquals(Weight.ONE_POUND_IN_KILOS, (BigDecimal)context1.getValue("party:getWeight(., 'KILOGRAMS')"));
        this.checkEquals(Weight.ONE_POUND_IN_GRAMS, (BigDecimal)context1.getValue("party:getWeight(., 'GRAMS')"));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)context1.getValue("party:getWeight(., 'POUNDS')"));
        this.checkEquals(Weight.ONE_POUND_IN_KILOS, (BigDecimal)context2.getValue("party:getWeight(.)"));
        this.checkEquals(Weight.ONE_POUND_IN_KILOS, (BigDecimal)context2.getValue("party:getWeight(., 'KILOGRAMS')"));
        this.checkEquals(Weight.ONE_POUND_IN_GRAMS, (BigDecimal)context2.getValue("party:getWeight(., 'GRAMS')"));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)context2.getValue("party:getWeight(., 'POUNDS')"));
    }

    @Test
    public void testGetPatientWeight() {
        Act visit = this.create("act.patientClinicalEvent", Act.class);
        IMObjectBean bean = this.getBean((org.openvpms.component.model.object.IMObject)visit);
        bean.setTarget("patient", (org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)visit);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getPatientWeight(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getPatientWeight(.)"));
        this.patientFactory.createWeight(this.patient, BigDecimal.ONE, WeightUnits.KILOGRAMS);
        Assert.assertEquals((Object)"1 Kilograms", (Object)context1.getValue("party:getPatientWeight(.)"));
        Assert.assertEquals((Object)"1 Kilograms", (Object)context2.getValue("party:getPatientWeight(.)"));
        Assert.assertEquals((Object)"1 Kilograms", (Object)context1.getValue("party:getPatientWeight()"));
        Assert.assertEquals((Object)"1 Kilograms", (Object)context2.getValue("party:getPatientWeight()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getPatientWeight(null)"));
    }

    @Test
    public void tesGetPatientMicrochip() {
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getPatientMicrochip(.)"));
        Assert.assertNull((Object)context1.getValue("party:getMicrochip(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getPatientMicrochip(.)"));
        Assert.assertNull((Object)context2.getValue("party:getMicrochip(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getPatientMicrochip()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getPatientMicrochip()"));
        Assert.assertNull((Object)context1.getValue("party:getMicrochip()"));
        Assert.assertNull((Object)context2.getValue("party:getMicrochip()"));
        this.patientFactory.updatePatient(this.patient).addMicrochip("1234567").build();
        EntityIdentity microchip = this.patient.getIdentities().stream().findFirst().orElse(null);
        Assert.assertEquals((Object)"1234567", (Object)context1.getValue("party:getPatientMicrochip(.)"));
        Assert.assertEquals((Object)microchip, (Object)context1.getValue("party:getMicrochip(.)"));
        Assert.assertEquals((Object)"1234567", (Object)context1.getValue("openvpms:get(party:getMicrochip(.), 'microchip')"));
        Assert.assertEquals((Object)"1234567", (Object)context2.getValue("party:getPatientMicrochip(.)"));
        Assert.assertEquals((Object)microchip, (Object)context2.getValue("party:getMicrochip(.)"));
        Assert.assertEquals((Object)"1234567", (Object)context2.getValue("openvpms:get(party:getMicrochip(.), 'microchip')"));
        Assert.assertEquals((Object)"1234567", (Object)context1.getValue("party:getPatientMicrochip()"));
        Assert.assertEquals((Object)microchip, (Object)context1.getValue("party:getMicrochip()"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getPatientMicrochip(null)"));
        Assert.assertNull((Object)context1.getValue("party:getMicrochip(null)"));
    }

    @Test
    public void testGetPatientReferralVet() {
        Party vet = this.supplierFactory.createVet();
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertNull((Object)context1.getValue("party:getPatientReferralVet()"));
        Assert.assertNull((Object)context1.getValue("party:getPatientReferralVet(.)"));
        Assert.assertNull((Object)context2.getValue("party:getPatientReferralVet()"));
        Assert.assertNull((Object)context2.getValue("party:getPatientReferralVet(.)"));
        this.patientFactory.updatePatient(this.patient).addReferredFrom(vet, DateRules.getYesterday()).build();
        Assert.assertEquals((Object)vet, (Object)context1.getValue("party:getPatientReferralVet()"));
        Assert.assertEquals((Object)vet, (Object)context1.getValue("party:getPatientReferralVet(.)"));
        Assert.assertEquals((Object)vet, (Object)context2.getValue("party:getPatientReferralVet()"));
        Assert.assertEquals((Object)vet, (Object)context2.getValue("party:getPatientReferralVet(.)"));
        Assert.assertNull((Object)context1.getValue("party:getPatientReferralVet(null)"));
    }

    @Test
    public void testGetPatientReferralVetPractice() {
        Party vet = this.supplierFactory.createVet();
        Party practice = this.supplierFactory.createVetPractice();
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)this.item);
        Assert.assertNull((Object)context1.getValue("party:getPatientReferralVetPractice()"));
        Assert.assertNull((Object)context1.getValue("party:getPatientReferralVetPractice(.)"));
        Assert.assertNull((Object)context2.getValue("party:getPatientReferralVetPractice()"));
        Assert.assertNull((Object)context2.getValue("party:getPatientReferralVetPractice(.)"));
        this.patientFactory.updatePatient(this.patient).addReferredFrom(vet, DateRules.getYesterday()).build();
        this.supplierFactory.updateVetPractice(practice).addVet(vet, DateRules.getYesterday()).build();
        Assert.assertEquals((Object)practice, (Object)context1.getValue("party:getPatientReferralVetPractice()"));
        Assert.assertEquals((Object)practice, (Object)context1.getValue("party:getPatientReferralVetPractice(.)"));
        Assert.assertEquals((Object)practice, (Object)context2.getValue("party:getPatientReferralVetPractice()"));
        Assert.assertEquals((Object)practice, (Object)context2.getValue("party:getPatientReferralVetPractice(.)"));
        Assert.assertNull((Object)context1.getValue("party:getPatientReferralVetPractice(null)"));
    }

    @Test
    public void testGetAccountBalance() {
        BigDecimal total = BigDecimal.valueOf(100L);
        JXPathContext ctx1 = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        this.checkEquals(BigDecimal.ZERO, (BigDecimal)ctx1.getValue("party:getAccountBalance(.)"));
        List<FinancialAct> invoice = FinancialTestHelper.createChargesInvoice(total, this.customer, this.patient, this.productFactory.createMedication(), "POSTED");
        this.save(invoice);
        this.checkEquals(total, (BigDecimal)ctx1.getValue("party:getAccountBalance(.)"));
        JXPathContext ctx2 = this.createContext((org.openvpms.component.model.object.IMObject)invoice.get(1));
        this.checkEquals(total, (BigDecimal)ctx2.getValue("party:getAccountBalance(.)"));
        this.checkEquals(BigDecimal.ZERO, (BigDecimal)ctx1.getValue("party:getAccountBalance(null)"));
    }

    @Test
    public void testGetPatientRabiesTag() {
        Act visit = this.create("act.patientClinicalEvent", Act.class);
        IMObjectBean bean = this.getBean((org.openvpms.component.model.object.IMObject)visit);
        bean.setTarget("patient", (org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context1 = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        JXPathContext context2 = this.createContext((org.openvpms.component.model.object.IMObject)visit);
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getPatientRabiesTag(.)"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getPatientRabiesTag(.)"));
        Assert.assertEquals((Object)"", (Object)context1.getValue("party:getPatientRabiesTag()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getPatientRabiesTag()"));
        this.patientFactory.updatePatient(this.patient).addRabiesTag("1234567890").build(false);
        this.getArchetypeService().save((org.openvpms.component.model.object.IMObject)this.patient, false);
        Assert.assertEquals((Object)"1234567890", (Object)context1.getValue("party:getPatientRabiesTag(.)"));
        Assert.assertEquals((Object)"1234567890", (Object)context2.getValue("party:getPatientRabiesTag(.)"));
        Assert.assertEquals((Object)"1234567890", (Object)context1.getValue("party:getPatientRabiesTag()"));
        Assert.assertEquals((Object)"1234567890", (Object)context2.getValue("party:getPatientRabiesTag()"));
        Assert.assertEquals((Object)"", (Object)context2.getValue("party:getPatientRabiesTag(null)"));
    }

    @Test
    public void testGetLetterheadContacts() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)new IMObject());
        context.getVariables().declareVariable("location", null);
        Assert.assertNull((Object)context.getValue("party:getLetterheadContacts($location)"));
        context.getVariables().declareVariable("location", (Object)location1);
        Assert.assertEquals((Object)location1, (Object)context.getValue("party:getLetterheadContacts($location)"));
        Entity letterhead = (Entity)this.documentFactory.newLetterhead().logoFile("logo.png").contacts(location1).build();
        this.practiceFactory.updateLocation(location1).letterhead(letterhead).build();
        Assert.assertEquals((Object)location1, (Object)context.getValue("party:getLetterheadContacts($location)"));
        this.documentFactory.updateLetterhead(letterhead).contacts(location2).build();
        Assert.assertEquals((Object)location2, (Object)context.getValue("party:getLetterheadContacts($location)"));
        Assert.assertNull((Object)context.getValue("party:getLetterheadContacts(null)"));
    }

    @Test
    public void testGetAppointments() {
        Party customer1 = this.customer;
        Party patient1 = this.patient;
        Party customer2 = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient();
        Party location = this.practiceFactory.createLocation();
        Entity schedule = this.schedulingFactory.createSchedule(location);
        Date now = new Date();
        Act act1a = this.createAppointment(schedule, customer1, patient1, DateRules.getDate((Date)now, (int)-1, (DateUnits)DateUnits.HOURS));
        Act act1b = this.createAppointment(schedule, customer1, patient1, DateRules.getDate((Date)now, (int)6, (DateUnits)DateUnits.MONTHS));
        Act act1c = this.createAppointment(schedule, customer1, null, DateRules.getDate((Date)now, (int)9, (DateUnits)DateUnits.MONTHS));
        Act act1d = this.createAppointment(schedule, customer1, patient1, DateRules.getDate((Date)now, (int)2, (DateUnits)DateUnits.YEARS));
        Act act2a = this.createAppointment(schedule, customer2, patient2, DateRules.getDate((Date)now, (int)-1, (DateUnits)DateUnits.YEARS));
        Act act2b = this.createAppointment(schedule, customer2, patient2, DateRules.getDate((Date)now, (int)1, (DateUnits)DateUnits.MONTHS));
        Act act2c = this.createAppointment(schedule, customer2, patient2, DateRules.getDate((Date)now, (int)6, (DateUnits)DateUnits.MONTHS));
        act1b.setStatus("CONFIRMED");
        act2b.setStatus("CANCELLED");
        this.save((org.openvpms.component.model.object.IMObject[])new Act[]{act1a, act1b, act1c, act1d, act2a, act2b, act2c});
        this.checkAppointments(customer1, "party:getAppointments(., 1, 'YEARS')", act1b, act1c);
        this.checkAppointments(patient1, "party:getAppointments(., 3, 'YEARS')", act1b, act1d);
        this.checkAppointments(customer2, "party:getAppointments(., 1, 'YEARS')", act2c);
    }

    @Test
    public void testGetAddress() {
        ((TestCustomerBuilder)((TestLocationContactBuilder)((TestLocationContactBuilder)((TestCustomerBuilder)((TestLocationContactBuilder)((TestLocationContactBuilder)this.customerFactory.updateCustomer(this.customer).newLocation("123 Main Rd", "KONGWAK", "VIC", "3058").purposes("BILLING")).preferred(true)).add()).newLocation("456 Smith St", "WONTHAGGI", "VIC", "3058").purposes("SHIPPING")).preferred(false)).add()).build();
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        Assert.assertEquals((Object)"123 Main Rd\nKongwak Vic 3058", (Object)context.getValue("party:getAddress(., 'BILLING')"));
        Assert.assertEquals((Object)"123 Main Rd\nKongwak Vic 3058", (Object)context.getValue("party:getAddress(., 'BILLING', false())"));
        Assert.assertEquals((Object)"123 Main Rd, Kongwak Vic 3058", (Object)context.getValue("party:getAddress(., 'BILLING', true())"));
        Assert.assertEquals((Object)"456 Smith St\nWonthaggi Vic 3058", (Object)context.getValue("party:getAddress(., 'SHIPPING')"));
        Assert.assertEquals((Object)"123 Main Rd\nKongwak Vic 3058", (Object)context.getValue("party:getAddress(., 'NO_SUCH_PURPOSE')"));
    }

    @Test
    public void testSetInactive() {
        Assert.assertTrue((boolean)this.patient.isActive());
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        context.getValue("party:setPatientInactive(.)");
        Party object = this.get(this.patient);
        Assert.assertFalse((boolean)object.isActive());
    }

    @Test
    public void testSetDeceased() {
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        context.getValue("party:setPatientDeceased(.)");
        Party object = this.get(this.patient);
        Assert.assertFalse((boolean)object.isActive());
        IMObjectBean bean = this.getBean((org.openvpms.component.model.object.IMObject)object);
        Assert.assertTrue((boolean)bean.getBoolean("deceased"));
        Assert.assertNotNull((Object)bean.getDate("deceasedDate"));
    }

    @Test
    public void testSetDesexed() {
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)this.patient);
        context.getValue("party:setPatientDesexed(.)");
        Party object = this.get(this.patient);
        IMObjectBean bean = this.getBean((org.openvpms.component.model.object.IMObject)object);
        Assert.assertTrue((boolean)bean.getBoolean("desexed"));
    }

    @Test
    public void testGetBpayId() {
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)this.customer);
        String expected = this.rules.getBpayId(this.customer);
        Assert.assertEquals((Object)expected, (Object)context.getValue("party:getBpayId(.)"));
        Assert.assertEquals((Object)expected, (Object)context.getValue("party:getBpayId()"));
        Assert.assertNull((String)expected, (Object)context.getValue("party:getBpayId(null)"));
    }

    private Act createAppointment(Entity schedule, Party customer, Party patient, Date startTime) {
        Entity appointmentType = this.schedulingFactory.createAppointmentType();
        return (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(startTime)).schedule(schedule).appointmentType(appointmentType).customer(customer)).patient(patient)).status("PENDING")).build();
    }

    private void checkAppointments(Party party, String expression, Act ... expected) {
        JXPathContext context = this.createContext((org.openvpms.component.model.object.IMObject)party);
        ArrayList result = new ArrayList();
        CollectionUtils.addAll(result, (Iterable)((Iterable)context.getValue(expression)));
        Assert.assertEquals((long)expected.length, (long)result.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], result.get(i));
        }
    }

    private Contact createPhone(String number, boolean preferred, String purpose) {
        TestPhoneContactBuilder builder = (TestPhoneContactBuilder)this.contactFactory.newPhone().areaCode("03").phone(number).preferred(preferred);
        if (purpose != null) {
            builder.purposes(purpose);
        }
        return builder.build();
    }

    private JXPathContext createContext(org.openvpms.component.model.object.IMObject object) {
        IArchetypeService service = (IArchetypeService)this.applicationContext.getBean("archetypeService", IArchetypeService.class);
        LookupService lookups = this.getLookupService();
        ArchetypeServiceFunctions functions = new ArchetypeServiceFunctions(service, lookups);
        PartyFunctions partyFunctions = new PartyFunctions(service, lookups, new PatientRules(null, this.practiceService, service, lookups), (AddressFormatter)new BasicAddressFormatter((ArchetypeService)service, lookups));
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new ObjectFunctions((Object)functions, "openvpms"));
        library.addFunctions((Functions)new ObjectFunctions((Object)partyFunctions, "party"));
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }
}

