/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.date;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.date.DateFunctions;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;

public class DateFunctionsTestCase {
    private Date dateTime;
    private JXPathContext context;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    @Before
    public void setUp() {
        ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)GMT));
        DateTime time = new DateTime(2006, 9, 20, 17, 54, 22, 0, (Chronology)chronology);
        this.dateTime = time.toDate();
        Locale locale = new Locale("en", "AU");
        this.context = this.createContext(new DateFunctions(locale, GMT));
    }

    @Test
    public void testNow() {
        Date before = new Date();
        Date now = (Date)this.evaluate("date:now()", this.context);
        Date after = new Date();
        Assert.assertTrue((before.compareTo(now) <= 0 && after.compareTo(now) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToday() {
        Assert.assertEquals((Object)DateRules.getToday(), this.evaluate("date:today()", this.context));
    }

    @Test
    public void testTomorrow() {
        Assert.assertEquals((Object)DateRules.getTomorrow(), this.evaluate("date:tomorrow()", this.context));
    }

    @Test
    public void testYesterday() {
        Assert.assertEquals((Object)DateRules.getYesterday(), this.evaluate("date:yesterday()", this.context));
    }

    @Test
    public void testAdd() {
        Assert.assertEquals((Object)DateRules.getDate((Date)this.dateTime, (int)1, (DateUnits)DateUnits.DAYS), this.evaluate("date:add(., '1d')", this.context));
        Assert.assertEquals((Object)DateRules.getDate((Date)this.dateTime, (int)-1, (DateUnits)DateUnits.DAYS), this.evaluate("date:add(., '-1d')", this.context));
        Assert.assertEquals((Object)DateRules.getDate((Date)this.dateTime, (int)1, (DateUnits)DateUnits.WEEKS), this.evaluate("date:add(., '1w')", this.context));
        Assert.assertEquals((Object)DateRules.getDate((Date)this.dateTime, (int)-1, (DateUnits)DateUnits.WEEKS), this.evaluate("date:add(., '-1w')", this.context));
        Assert.assertEquals((Object)DateRules.getDate((Date)this.dateTime, (int)1, (DateUnits)DateUnits.HOURS), this.evaluate("date:add(., '1h')", this.context));
        Assert.assertEquals((Object)DateRules.getDate((Date)this.dateTime, (int)-1, (DateUnits)DateUnits.HOURS), this.evaluate("date:add(., '-1h')", this.context));
        DateFunctions functions = new DateFunctions();
        Assert.assertNull((Object)functions.add(null, "1d"));
        Assert.assertNull((Object)functions.add(this.dateTime, null));
        Assert.assertNull((Object)functions.add(null, null));
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((Object)"Sep 2006", this.evaluate("date:format(., 'MMM yyyy')", this.context));
        Assert.assertEquals((Object)"September 2006", this.evaluate("date:format(., 'MMMM yyyy')", this.context));
        Assert.assertEquals((Object)"5:54 PM", this.evaluate("date:format(., 'h:mm a')", this.context));
        Assert.assertEquals((Object)"17:54 Sep 2006", this.evaluate("date:format(., 'H:mm MMM yyyy')", this.context));
        DateFunctions functions = new DateFunctions(new Locale("en", "AU"), GMT);
        Assert.assertNull((String)"September 2006", (Object)functions.format(null, null));
        Assert.assertNull((String)"September 2006", (Object)functions.format(null, "MMM yyyy"));
        String value = functions.format(this.dateTime, null);
        Assert.assertTrue(("20/09/2006 17:54:22".equals(value) || "20/09/2006 5:54:22 PM".equals(value) ? 1 : 0) != 0);
    }

    @Test
    public void testFormatDate() {
        Assert.assertEquals((Object)"20/09/2006", this.evaluate("date:formatDate(.)", this.context));
        Assert.assertEquals((Object)"20/09/06", this.evaluate("date:formatDate(., 'short')", this.context));
        Assert.assertEquals((Object)"20/09/2006", this.evaluate("date:formatDate(., 'medium')", this.context));
        Assert.assertEquals((Object)"20 September 2006", this.evaluate("date:formatDate(., 'long')", this.context));
        JXPathContext context2 = this.createContext(new DateFunctions(Locale.UK, GMT));
        Assert.assertEquals((Object)"20-Sep-2006", this.evaluate("date:formatDate(.)", context2));
        Assert.assertEquals((Object)"20/09/06", this.evaluate("date:formatDate(., 'short')", context2));
        Assert.assertEquals((Object)"20-Sep-2006", this.evaluate("date:formatDate(., 'medium')", context2));
        Assert.assertEquals((Object)"20 September 2006", this.evaluate("date:formatDate(., 'long')", context2));
    }

    @Test
    public void testFormatTime() {
        String defaultValue = (String)this.evaluate("date:formatTime(.)", this.context);
        Assert.assertTrue(("17:54:22".equals(defaultValue) || "5:54:22 PM".equals(defaultValue) ? 1 : 0) != 0);
        String shortValue = (String)this.evaluate("date:formatTime(., 'short')", this.context);
        Assert.assertTrue(("17:54".equals(shortValue) || "5:54 PM".equals(shortValue) ? 1 : 0) != 0);
        String mediumValue = (String)this.evaluate("date:formatTime(., 'medium')", this.context);
        Assert.assertTrue(("17:54:22".equals(mediumValue) || "5:54:22 PM".equals(mediumValue) ? 1 : 0) != 0);
        String longValue = (String)this.evaluate("date:formatTime(., 'long')", this.context);
        Assert.assertTrue(("17:54:22".equals(longValue) || "5:54:22 PM".equals(longValue) ? 1 : 0) != 0);
        JXPathContext context2 = this.createContext(new DateFunctions(Locale.UK, TimeZone.getTimeZone("GMT+4")));
        defaultValue = (String)this.evaluate("date:formatTime(.)", context2);
        Assert.assertTrue(("21:54:22".equals(defaultValue) || "9:54:22 PM".equals(defaultValue) ? 1 : 0) != 0);
        shortValue = (String)this.evaluate("date:formatTime(., 'short')", context2);
        Assert.assertTrue(("21:54".equals(shortValue) || "5:54 PM".equals(shortValue) ? 1 : 0) != 0);
        mediumValue = (String)this.evaluate("date:formatTime(., 'medium')", context2);
        Assert.assertTrue(("21:54:22".equals(mediumValue) || "9:54:22 PM".equals(mediumValue) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"21:54:22 GMT+04:00", this.evaluate("date:formatTime(., 'long')", context2));
    }

    @Test
    public void testFormatDateTime() {
        String defaultValue = (String)this.evaluate("date:formatDateTime(.)", this.context);
        Assert.assertTrue(("20/09/2006 17:54:22".equals(defaultValue) || "20/09/2006 5:54:22 PM".equals(defaultValue) ? 1 : 0) != 0);
        String shortValue = (String)this.evaluate("date:formatDateTime(., 'short')", this.context);
        Assert.assertTrue(("20/09/06 17:54".equals(shortValue) || "20/09/06 5:54 PM".equals(shortValue) ? 1 : 0) != 0);
        String mediumValue = (String)this.evaluate("date:formatDateTime(., 'medium')", this.context);
        Assert.assertTrue(("20/09/2006 17:54:22".equals(mediumValue) || "20/09/2006 5:54:22 PM".equals(mediumValue) ? 1 : 0) != 0);
        String longValue = (String)this.evaluate("date:formatDateTime(., 'long')", this.context);
        Assert.assertTrue(("20 September 2006 17:54:22".equals(longValue) || "20 September 2006 5:54:22 PM".equals(longValue) ? 1 : 0) != 0);
        shortValue = (String)this.evaluate("date:formatDateTime(., 'short', 'short')", this.context);
        Assert.assertTrue(("20/09/06 17:54".equals(shortValue) || "20/09/06 5:54 PM".equals(shortValue) ? 1 : 0) != 0);
        mediumValue = (String)this.evaluate("date:formatDateTime(., 'medium', 'medium')", this.context);
        Assert.assertTrue(("20/09/2006 17:54:22".equals(mediumValue) || "20/09/2006 5:54:22 PM".equals(mediumValue) ? 1 : 0) != 0);
        longValue = (String)this.evaluate("date:formatDateTime(., 'long', 'long')", this.context);
        Assert.assertTrue(("20 September 2006 17:54:22".equals(longValue) || "20 September 2006 5:54:22 PM".equals(longValue) ? 1 : 0) != 0);
        JXPathContext context2 = this.createContext(new DateFunctions(Locale.UK, GMT));
        Assert.assertEquals((Object)"20-Sep-2006 17:54:22", this.evaluate("date:formatDateTime(.)", context2));
        Assert.assertEquals((Object)"20/09/06 17:54", this.evaluate("date:formatDateTime(., 'short')", context2));
        Assert.assertEquals((Object)"20-Sep-2006 17:54:22", this.evaluate("date:formatDateTime(., 'medium')", context2));
        Assert.assertEquals((Object)"20 September 2006 17:54:22 GMT", this.evaluate("date:formatDateTime(., 'long')", context2));
        Assert.assertEquals((Object)"20/09/06 17:54", this.evaluate("date:formatDateTime(., 'short', 'short')", context2));
        Assert.assertEquals((Object)"20-Sep-2006 17:54:22", this.evaluate("date:formatDateTime(., 'medium', 'medium')", context2));
        Assert.assertEquals((Object)"20 September 2006 17:54:22 GMT", this.evaluate("date:formatDateTime(., 'long', 'long')", context2));
    }

    private <T> T evaluate(String expression, JXPathContext context) {
        return (T)context.getValue(expression);
    }

    private JXPathContext createContext(DateFunctions functions) {
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new ObjectFunctions((Object)functions, "date"));
        return JXPathHelper.newContext((Object)this.dateTime, (Functions)library);
    }
}

