/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.test.builder.paymentprocessor;

import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;

/**
 * Payment processor factory.
 *
 * @author Tim Anderson
 */
public class TestPaymentProcessorFactory {

    /**
     * The archetype service.
     */
    private final ArchetypeService service;

    /**
     * Constructs a {@link TestLaboratoryFactory}.
     *
     * @param service the archetype service
     */
    public TestPaymentProcessorFactory(ArchetypeService service) {
        this.service = service;
    }

    /**
     * Creates and saves a test payment processor.
     *
     * @return the payment processor
     */
    public Entity createPaymentProcessor() {
        return newPaymentProcessor().build();
    }

    /**
     * Returns a builder for a new test payment processor.
     *
     * @return a laboratory service builder
     */
    public TestPaymentProcessorBuilder newPaymentProcessor() {
        return new TestPaymentProcessorBuilder(service);
    }
}
