/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2024 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.test.builder.customer.account;

import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

import java.util.Set;

/**
 * Builds <em>act.customerAccountRefundOther</em> instances, for testing purposes.
 *
 * @author Tim Anderson
 */
public class TestOtherRefundItemBuilder
        extends TestPaymentRefundItemBuilder<TestRefundBuilder, TestOtherRefundItemBuilder> {

    /**
     * The payment type.
     */
    private ValueStrategy paymentType = ValueStrategy.unset();

    /**
     * Constructs a {@link TestOtherRefundItemBuilder}.
     *
     * @param parent  the parent builder
     * @param service the archetype service
     */
    public TestOtherRefundItemBuilder(TestRefundBuilder parent, ArchetypeService service) {
        super(parent, CustomerAccountArchetypes.REFUND_OTHER, service);
    }

    /**
     * Sets the payment type.
     *
     * @param paymentType the payment type
     * @return this
     */
    public TestOtherRefundItemBuilder paymentType(String paymentType) {
        this.paymentType = ValueStrategy.value(paymentType);
        return this;
    }

    /**
     * Builds the object.
     *
     * @param object   the object
     * @param bean     a bean wrapping the object
     * @param toSave   objects to save, if the object is to be saved
     * @param toRemove the objects to remove
     */
    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        setPaymentType(bean, paymentType);
    }
}
