/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.rules.workflow.roster;

import org.openvpms.archetype.rules.workflow.WorkflowStatus;

/**
 * Roster synchronisation status codes for <em>actIdentity.sync*</em> identities.
 *
 * @author Tim Anderson
 */
public class RosterSyncStatus {

    /**
     * Roster event is yet to sync.
     */
    public static final String PENDING = WorkflowStatus.PENDING;

    /**
     * Roster event has been synced.
     */
    public static final String SYNC = "SYNC";

    /**
     * Roster event failed to sync.
     */
    public static final String ERROR = "ERROR";


    /**
     * Default constructor.
     */
    private RosterSyncStatus() {
        // no-op
    }

}
