/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.rules.workflow;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.service.lookup.LookupService;


/**
 * Implementation of the {@link ScheduleService} for tasks.
 * <p>
 * This uses the supplied {@link EhcacheManager} to create a cache named "taskCache".
 *
 * @author Tim Anderson
 */
public class TaskService extends AbstractScheduleService {

    /**
     * Constructs a {@link TaskService}.
     *
     * @param service      the archetype service
     * @param lookups      the lookup service
     * @param cacheFactory the cache factory
     */
    public TaskService(IArchetypeService service, LookupService lookups, EhcacheManager cacheFactory) {
        super(new String[]{ScheduleArchetypes.TASK}, service, cacheFactory, "taskCache",
              new TaskFactory(service, lookups));
    }

}
