/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.rules.patient;


/**
 * Patient investigation archetypes.
 *
 * @author Tim Anderson
 */
public class InvestigationArchetypes {

    /**
     * Laboratory investigation identifier.
     */
    public static final String INVESTIGATION_ID = "actIdentity.patientInvestigation";

    /**
     * Investigation type participation short name.
     */
    public static final String INVESTIGATION_TYPE_PARTICIPATION = "participation.investigationType";

    /**
     * Patient investigation act short name.
     */
    public static final String PATIENT_INVESTIGATION = "act.patientInvestigation";

    /**
     * Investigation results archetype.
     */
    public static final String RESULTS = "act.patientInvestigationResults";

    /**
     * Text investigation result item archetype.
     */
    public static final String RESULT = "act.patientInvestigationResultItem";

    /**
     * Long text result archetype.
     */
    public static final String RESULT_TEXT = "act.patientInvestigationResultText";

    /**
     * Long note archetype.
     */
    public static final String RESULT_NOTE = "act.patientInvestigationResultNote";

    /**
     * Result image archetype.
     */
    public static final String RESULT_IMAGE = "act.patientInvestigationResultImage";

    /**
     * Patient investigation version act short name.
     */
    public static final String PATIENT_INVESTIGATION_VERSION = "act.patientInvestigationVersion";

    /**
     * Laboratory device participation.
     */
    public static final String DEVICE_PARTICIPATION = "participation.laboratoryDevice";


    /**
     * Default constructor.
     */
    private InvestigationArchetypes() {

    }
}
