/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.rules.finance.paymentprocessor;

import org.openvpms.archetype.rules.act.ActStatus;
import org.openvpms.archetype.rules.workflow.WorkflowStatus;

/**
 * Payment processor transaction status.
 *
 * @author Tim Anderson
 */
public class PaymentProcessorTransactionStatus {

    /**
     * Payment processor transaction hasn't been submitted.
     */
    public static final String PENDING = WorkflowStatus.PENDING;

    /**
     * Payment processor transaction has been prepared for submission.
     */
    public static final String IN_PROGRESS = ActStatus.IN_PROGRESS;

    /**
     * Payment processor transaction has been submitted.
     */
    public static final String SUBMITTED = "SUBMITTED";

    /**
     * Payment processor transaction has been successfully completed.
     */
    public static final String COMPLETED = WorkflowStatus.COMPLETED;

    /**
     * Payment processor transaction has been cancelled.
     */
    public static final String CANCELLED = WorkflowStatus.CANCELLED;

    /**
     * Payment processor transaction failed with an unrecoverable error.
     */
    public static final String ERROR = "ERROR";

    /**
     * Default constructor.
     */
    private PaymentProcessorTransactionStatus() {

    }
}
