/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2024 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.rules.customer;


/**
 * Customer archetypes.
 *
 * @author Tim Anderson
 */
public class CustomerArchetypes {

    /**
     * Customer short name.
     */
    public static final String PERSON = "party.customerperson";

    /**
     * 'Over the counter' short name.
     */
    public static final String OTC = "party.organisationOTC";

    /**
     * Title lookup archetype.
     */
    public static final String TITLE = "lookup.personTitle";

    /**
     * Customer participation short name.
     */
    public static final String CUSTOMER_PARTICIPATION = "participation.customer";

    /**
     * The customer alert act short name.
     */
    public static final String ALERT = "act.customerAlert";

    /**
     * The customer alert type archetype.
     */
    public static final String ALERT_TYPE = "lookup.customerAlertType";

    /**
     * The customer account type archetype.
     */
    public static final String ACCOUNT_TYPE = "lookup.customerAccountType";

    /**
     * The customer referral archetype.
     */
    public static final String CUSTOMER_REFERRAL = "lookup.customerReferral";

    /**
     * Customer document attachment act short name.
     */
    public static final String DOCUMENT_ATTACHMENT = "act.customerDocumentAttachment";

    /**
     * Customer document attachment version act short name.
     */
    public static final String DOCUMENT_ATTACHMENT_VERSION = "act.customerDocumentAttachmentVersion";

    /**
     * Customer document form act short name.
     */
    public static final String DOCUMENT_FORM = "act.customerDocumentForm";

    /**
     * Customer document letter act short name.
     */
    public static final String DOCUMENT_LETTER = "act.customerDocumentLetter";

    /**
     * Customer document letter version act short name.
     */
    public static final String DOCUMENT_LETTER_VERSION = "act.customerDocumentLetterVersion";

    /**
     * Code identity.
     */
    public static final String CODE_IDENTITY = "entityIdentity.code";

    /**
     * Default constructor.
     */
    private CustomerArchetypes() {

    }
}
