/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.cache.DayCaches;
import org.openvpms.archetype.rules.workflow.cache.Event;
import org.openvpms.archetype.rules.workflow.cache.EventHandle;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayCache {
    private final long entityId;
    private final Date from;
    private final Date to;
    @IgnoreSizeOf
    private DayCaches owner;
    private Map<Long, EventHandle> map;
    private List<Change> changes = new ArrayList<Change>();
    private long modHash;
    private static final Logger log = LoggerFactory.getLogger(DayCache.class);

    DayCache(long entityId, Date from, Date to) {
        this.entityId = entityId;
        this.from = from;
        this.to = to;
        this.modHash = RandomUtils.nextLong();
    }

    public Date getFrom() {
        return this.from;
    }

    public synchronized void setEvents(List<Event> events) {
        this.map = new HashMap<Long, EventHandle>();
        for (Event event : events) {
            EventHandle handle = event.getHandle(this.entityId, this.from, this.to);
            if (handle == null) continue;
            this.map.put(event.getId(), handle);
        }
        ++this.modHash;
        if (!this.changes.isEmpty()) {
            for (Change change : this.changes) {
                if (change.add) {
                    this.add(change.event);
                    continue;
                }
                this.remove(change.event);
            }
            this.changes.clear();
        }
    }

    public void addIfIntersects(Event event) {
        if (event.intersects(this.from, this.to)) {
            this.add(event);
        }
    }

    public void removeIfIntersects(Event event) {
        if (event.intersects(this.from, this.to)) {
            this.remove(event);
        }
    }

    public synchronized List<PropertySet> getEvents() {
        if (this.map == null) {
            return Collections.emptyList();
        }
        long id = this.owner.getId();
        ArrayList<PropertySet> result = new ArrayList<PropertySet>();
        Iterator<EventHandle> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            EventHandle handle = iterator.next();
            PropertySet event = handle.getEvent(id, this.from, this.to);
            if (event != null) {
                result.add((PropertySet)new ObjectSet(event));
                continue;
            }
            ++this.modHash;
            iterator.remove();
        }
        result.sort(EventComparator.INSTANCE);
        return result;
    }

    public synchronized ScheduleEvents getScheduleEvents() {
        List<PropertySet> events = this.getEvents();
        return new ScheduleEvents(events, this.modHash);
    }

    public synchronized long getModHash() {
        this.getEvents();
        return this.modHash;
    }

    public synchronized void add(Event event) {
        if (this.map != null) {
            EventHandle handle = event.getHandle(this.owner.getId(), this.from, this.to);
            if (handle != null) {
                this.map.put(event.getId(), handle);
                if (log.isDebugEnabled()) {
                    log.debug("DayCache.add, from={}, to={}, event={}", new Object[]{DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(this.from), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(this.to), event});
                }
            }
        } else {
            this.changes.add(new Change(event, true));
            if (log.isDebugEnabled()) {
                log.debug("DayCache.add - queue, from={}, to={}, event={}", new Object[]{DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(this.from), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(this.to), event});
            }
        }
        ++this.modHash;
    }

    public synchronized void remove(Event event) {
        if (this.map != null) {
            this.map.remove(event.getId());
            if (log.isDebugEnabled()) {
                log.debug("DayCache.remove, from={}, to={}, event={}", new Object[]{DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(this.from), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(this.to), event});
            }
        } else {
            this.changes.add(new Change(event, false));
            if (log.isDebugEnabled()) {
                log.debug("DayCache.remove - queue, from={}, to={}, event={}", new Object[]{DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(this.from), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(this.to), event});
            }
        }
        ++this.modHash;
    }

    void setOwner(DayCaches owner) {
        this.owner = owner;
    }

    private static class EventComparator
    implements Comparator<PropertySet> {
        public static final EventComparator INSTANCE = new EventComparator();

        private EventComparator() {
        }

        @Override
        public int compare(PropertySet o1, PropertySet o2) {
            Date startTime2;
            Date startTime1 = o1.getDate("act.startTime");
            int result = DateRules.compareTo(startTime1, startTime2 = o2.getDate("act.startTime"));
            if (result == 0) {
                IMObjectReference ref1 = o1.getReference("act.objectReference");
                IMObjectReference ref2 = o2.getReference("act.objectReference");
                result = Long.compare(ref1.getId(), ref2.getId());
            }
            return result;
        }
    }

    private static class Change {
        private final boolean add;
        private final Event event;

        Change(Event event, boolean add) {
            this.event = event;
            this.add = add;
        }
    }
}

