/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import org.openvpms.archetype.rules.workflow.ScheduleEventFactory;
import org.openvpms.archetype.rules.workflow.ScheduleEventQuery;
import org.openvpms.archetype.rules.workflow.TaskQuery;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertySet;

class TaskFactory
extends ScheduleEventFactory {
    TaskFactory(IArchetypeService service, LookupService lookups) {
        super("act.customerTask", service, lookups);
    }

    @Override
    protected void assemble(PropertySet target, IMObjectBean source) {
        super.assemble(target, source);
        Participation schedule = (Participation)source.getObject("worklist", Participation.class);
        this.populate(target, schedule, "schedule");
        Participation taskType = (Participation)source.getObject("taskType", Participation.class);
        this.populate(target, taskType, "scheduleType");
        String reason = ((Act)source.getObject(Act.class)).getReason();
        target.set("act.reason", (Object)reason);
        target.set("act.reasonName", (Object)reason);
        target.set("consultStartTime", (Object)source.getDate("consultStartTime"));
    }

    @Override
    protected ScheduleEventQuery createQuery(Entity entity, Date startTime, Date endTime) {
        return new TaskQuery(entity, startTime, endTime, this.getStatusNames(), this.getService());
    }
}

