/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.AbstractUntypedIteratorDecorator;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.joda.time.DateTime;
import org.joda.time.MutableDateTime;
import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ClinicianSchedule;
import org.openvpms.archetype.rules.workflow.Slot;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.RelationalOp;

class FreeSlotIterator
implements Iterator<Slot> {
    private final Date lowerBound;
    private final Date upperBound;
    private final Iterator<Slot> iterator;
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String SCHEDULE_ID = "scheduleId";

    FreeSlotIterator(Entity schedule, Date fromDate, Date toDate, Period fromTime, Period toTime, ClinicianSchedule clinicianSchedule, IArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)schedule);
        long scheduleStart = this.getScheduleTime(bean.getDate(START_TIME));
        long scheduleEnd = this.getScheduleTime(bean.getDate(END_TIME));
        int maxDuration = bean.getInt("maxDuration", -1);
        DateUnits units = DateUnits.fromString(bean.getString("maxDurationUnits"), null);
        if (maxDuration > 0 && units != null) {
            this.lowerBound = DateRules.getDate(fromDate, -maxDuration, units);
            this.upperBound = DateRules.getDate(toDate, maxDuration, units);
        } else {
            this.lowerBound = null;
            this.upperBound = null;
        }
        Iterator<ObjectSet> queryIterator = this.createFreeSlotIterator(schedule, fromDate, toDate, service);
        Iterator<Slot> slotIterator = this.createFreeSlotAdapter(queryIterator);
        Iterator<Slot> first = this.createFirstLastFreeSlotIterator(slotIterator, schedule, fromDate, toDate, service);
        if (scheduleStart != -1L || scheduleEnd != -1L) {
            first = new TimeRangeSlotIterator(first, scheduleStart, scheduleEnd);
        }
        if (fromTime != null || toTime != null) {
            long from = fromTime != null ? fromTime.toStandardDuration().getMillis() : -1L;
            long to = toTime != null ? toTime.toStandardDuration().getMillis() : -1L;
            first = new TimeRangeSlotIterator(first, from, to);
        }
        if (clinicianSchedule != null) {
            first = new ClinicianSlotIterator(first, schedule, clinicianSchedule);
        }
        this.iterator = first;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Slot next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Iterator<Slot> createFirstLastFreeSlotIterator(Iterator<Slot> iterator, Entity schedule, Date fromDate, Date toDate, IArchetypeService service) {
        IteratorChain result = new IteratorChain();
        Date appointmentBefore = this.getAppointmentBefore(schedule, fromDate, toDate, service);
        Date appointmentAfter = this.getAppointmentAfter(schedule, fromDate, toDate, service);
        if (appointmentBefore != null || appointmentAfter != null) {
            Slot slot;
            if (appointmentBefore != null && appointmentBefore.compareTo(fromDate) > 0) {
                slot = new Slot(schedule.getId(), fromDate, appointmentBefore);
                result.addIterator(Collections.singletonList(slot).iterator());
            }
            result.addIterator(iterator);
            if (appointmentAfter != null && appointmentAfter.compareTo(toDate) < 0) {
                slot = new Slot(schedule.getId(), appointmentAfter, toDate);
                result.addIterator(Collections.singletonList(slot).iterator());
            }
        } else {
            Slot slot = new Slot(schedule.getId(), fromDate, toDate);
            result.addIterator(Collections.singletonList(slot).iterator());
        }
        return result;
    }

    private Iterator<Slot> createFreeSlotAdapter(Iterator<ObjectSet> queryIterator) {
        return new AbstractUntypedIteratorDecorator<ObjectSet, Slot>(queryIterator){

            public Slot next() {
                ObjectSet set = (ObjectSet)this.getIterator().next();
                return new Slot(set.getLong(FreeSlotIterator.SCHEDULE_ID), set.getDate(FreeSlotIterator.START_TIME), set.getDate(FreeSlotIterator.END_TIME));
            }
        };
    }

    private Iterator<ObjectSet> createFreeSlotIterator(Entity schedule, Date fromDate, Date toDate, IArchetypeService service) {
        String name = this.lowerBound != null ? "findFreeSlotsBounded" : "findFreeSlots";
        NamedQuery query = new NamedQuery(name, new String[]{SCHEDULE_ID, START_TIME, END_TIME});
        query.setParameter("from", (Object)fromDate);
        query.setParameter("to", (Object)toDate);
        query.setParameter(SCHEDULE_ID, (Object)schedule.getId());
        if (this.lowerBound != null) {
            query.setParameter("lowerBound", (Object)this.lowerBound);
            query.setParameter("upperBound", (Object)this.upperBound);
        }
        return new ObjectSetQueryIterator(service, (IArchetypeQuery)query);
    }

    private Date getAppointmentBefore(Entity schedule, Date fromDate, Date toDate, IArchetypeService service) {
        Date result = null;
        ArchetypeQuery query = this.createAppointmentQuery(schedule, fromDate, toDate);
        query.add((IConstraint)Constraints.sort((String)START_TIME));
        ObjectSetQueryIterator iter = new ObjectSetQueryIterator(service, (IArchetypeQuery)query);
        if (iter.hasNext()) {
            ObjectSet set = (ObjectSet)iter.next();
            result = set.getDate("a.startTime");
        }
        return result;
    }

    private Date getAppointmentAfter(Entity schedule, Date fromDate, Date toDate, IArchetypeService service) {
        Date result = null;
        ArchetypeQuery query = this.createAppointmentQuery(schedule, fromDate, toDate);
        query.add((IConstraint)Constraints.sort((String)END_TIME, (boolean)false));
        ObjectSetQueryIterator iter = new ObjectSetQueryIterator(service, (IArchetypeQuery)query);
        if (iter.hasNext()) {
            ObjectSet set = (ObjectSet)iter.next();
            result = set.getDate("a.endTime");
        }
        return result;
    }

    private ArchetypeQuery createAppointmentQuery(Entity schedule, Date fromDate, Date toDate) {
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"a", (String)"act.customerAppointment"));
        query.add((IConstraint)new NodeSelectConstraint("a.startTime"));
        query.add((IConstraint)new NodeSelectConstraint("a.endTime"));
        query.add((IConstraint)Constraints.join((String)"schedule").add((IConstraint)Constraints.eq((String)"entity", (Object)schedule)));
        query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.between((String)START_TIME, (Object)fromDate, (Object)toDate), Constraints.between((String)END_TIME, (Object)fromDate, (Object)toDate)}));
        if (this.lowerBound != null) {
            query.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.GTE, (Object)this.lowerBound));
            query.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.LT, (Object)this.upperBound));
            query.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.GT, (Object)this.lowerBound));
            query.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.LTE, (Object)this.upperBound));
        }
        query.setMaxResults(1);
        return query;
    }

    private long getScheduleTime(Date date) {
        DateTime dateTime;
        long result = -1L;
        if (date != null && (dateTime = new DateTime((Object)date)).getDayOfMonth() < 2 && (result = (long)dateTime.getMillisOfDay()) == 0L) {
            result = -1L;
        }
        return result;
    }

    private static class ClinicianSlotIterator
    implements Iterator<Slot> {
        private final Iterator<Slot> iterator;
        private final Entity schedule;
        private final Deque<Slot> slots = new ArrayDeque<Slot>();
        private RangeSet<Date> shifts;
        private RangeSet<Date> appointments;

        ClinicianSlotIterator(Iterator<Slot> iterator, Entity schedule, ClinicianSchedule cache) {
            this.iterator = iterator;
            this.schedule = schedule;
            this.shifts = cache.getShifts(schedule);
            if (!this.shifts.isEmpty()) {
                this.appointments = cache.getAppointments();
            }
        }

        @Override
        public boolean hasNext() {
            boolean result = false;
            if (!this.shifts.isEmpty()) {
                while (this.slots.isEmpty() && this.iterator.hasNext()) {
                    Slot slot = this.iterator.next();
                    this.add(slot);
                }
                result = !this.slots.isEmpty();
            }
            return result;
        }

        @Override
        public Slot next() {
            return this.slots.pop();
        }

        private void add(Slot slot) {
            Date startTime = slot.getStartTime();
            Date endTime = slot.getEndTime();
            RangeSet intersectingShifts = this.shifts.subRangeSet(Range.closed((Comparable)startTime, (Comparable)endTime));
            for (Range shift : intersectingShifts.asRanges()) {
                Date end;
                Date start;
                if (shift.isEmpty() || (start = DateRules.max(startTime, (Date)shift.lowerEndpoint())).compareTo(end = DateRules.min(endTime, (Date)shift.upperEndpoint())) >= 0) continue;
                if (this.appointments != null && !this.appointments.isEmpty()) {
                    RangeSet intersects = this.appointments.subRangeSet(Range.closed((Comparable)start, (Comparable)end));
                    if (!intersects.isEmpty()) {
                        TreeRangeSet newRange = TreeRangeSet.create();
                        newRange.add(Range.closed((Comparable)start, (Comparable)end));
                        newRange.removeAll(intersects);
                        if (newRange.isEmpty()) continue;
                        for (Range range : newRange.asRanges()) {
                            if (range.isEmpty()) continue;
                            this.slots.add(new Slot(this.schedule.getId(), (Date)range.lowerEndpoint(), (Date)range.upperEndpoint()));
                        }
                        continue;
                    }
                    this.slots.add(new Slot(this.schedule.getId(), start, end));
                    continue;
                }
                this.slots.add(new Slot(this.schedule.getId(), start, end));
            }
        }
    }

    private static class TimeRangeSlotIterator
    implements Iterator<Slot> {
        private final Iterator<Slot> filter;
        private final Deque<Slot> slots = new ArrayDeque<Slot>();
        private final long rangeStart;
        private final long rangeEnd;

        public TimeRangeSlotIterator(Iterator<Slot> iterator, long rangeStart, long rangeEnd) {
            this.filter = new FilterIterator(iterator, (Predicate)new TimeRangePredicate());
            this.rangeStart = rangeStart;
            this.rangeEnd = rangeEnd;
        }

        @Override
        public boolean hasNext() {
            while (this.slots.isEmpty() && this.filter.hasNext()) {
                Slot slot = this.filter.next();
                this.add(slot);
            }
            return !this.slots.isEmpty();
        }

        @Override
        public Slot next() {
            return this.slots.pop();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void add(Slot slot) {
            Date to;
            Date from = DateRules.getDate(slot.getStartTime());
            if (from.compareTo(to = DateRules.getDate(slot.getEndTime())) != 0) {
                this.add(slot.getSchedule(), this.getSlotStart(slot.getStartTime()), this.getRangeEnd(from));
                while ((from = DateRules.getDate(from, 1, DateUnits.DAYS)).compareTo(to) < 0) {
                    this.add(slot.getSchedule(), this.getRangeStart(from), this.getRangeEnd(from));
                }
                this.add(slot.getSchedule(), this.getRangeStart(to), this.getSlotEnd(slot.getEndTime()));
            } else {
                this.add(slot.getSchedule(), this.getSlotStart(slot.getStartTime()), this.getSlotEnd(slot.getEndTime()));
            }
        }

        private void add(long scheduleId, Date slotStart, Date slotEnd) {
            if (slotStart.compareTo(slotEnd) < 0) {
                this.slots.add(new Slot(scheduleId, slotStart, slotEnd));
            }
        }

        private Date getRangeStart(Date date) {
            if (this.rangeStart == -1L) {
                return date;
            }
            return this.getDateTime(date, this.rangeStart);
        }

        private Date getRangeEnd(Date date) {
            if (this.rangeEnd == -1L) {
                return DateRules.getDate(date, 1, DateUnits.DAYS);
            }
            return this.getDateTime(date, this.rangeEnd);
        }

        private Date getSlotStart(Date startTime) {
            long slotStart;
            Date result = startTime;
            if (this.rangeStart != -1L && (slotStart = this.getTime(startTime)) < this.rangeStart) {
                result = this.getDateTime(startTime, this.rangeStart);
            }
            return result;
        }

        private Date getSlotEnd(Date endTime) {
            long slotEnd;
            Date result = endTime;
            if (this.rangeEnd != -1L && (slotEnd = this.getTime(endTime)) >= this.rangeEnd) {
                result = this.getDateTime(endTime, this.rangeEnd);
            }
            return result;
        }

        private Date getDateTime(Date date, long time) {
            MutableDateTime dateTime = new MutableDateTime((Object)date);
            dateTime.setMillisOfDay((int)time);
            return dateTime.toDate();
        }

        private long getTime(Date date) {
            if (date != null) {
                return new DateTime((Object)date).getMillisOfDay();
            }
            return -1L;
        }

        private class TimeRangePredicate
        implements Predicate<Slot> {
            private TimeRangePredicate() {
            }

            public boolean evaluate(Slot slot) {
                Date slotStart = slot.getStartTime();
                Date slotEnd = slot.getEndTime();
                Date start = TimeRangeSlotIterator.this.rangeStart != -1L ? TimeRangeSlotIterator.this.getRangeStart(slotStart) : DateRules.getDate(slotStart);
                Date end = TimeRangeSlotIterator.this.rangeEnd != -1L ? TimeRangeSlotIterator.this.getRangeEnd(slotEnd) : DateRules.getDate(DateRules.getDate(slotStart), 1, DateUnits.DAYS);
                return DateRules.intersects(slotStart, slotEnd, start, end);
            }
        }
    }
}

