/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import org.joda.time.DateMidnight;
import org.joda.time.Days;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.openvpms.archetype.rules.act.ActCopyHandler;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.archetype.rules.util.PeriodHelper;
import org.openvpms.archetype.rules.workflow.AppointmentReminderConfig;
import org.openvpms.archetype.rules.workflow.BoardingHelper;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.IterableIMObjectQuery;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.RelationalOp;

public class AppointmentRules {
    public static final String APPOINTMENT_REMINDER_JOB = "entity.jobAppointmentReminder";
    private final IArchetypeService service;
    private static final int DAY_IN_MINUTES = 1440;
    private static final String PATIENT = "patient";
    private static final String ENTITY = "entity";
    private static final String STATUS = "status";
    private static final String START_TIME = "startTime";

    public AppointmentRules(IArchetypeService service) {
        this.service = service;
    }

    public Entity getScheduleView(Party location, Entity schedule) {
        IMObjectBean bean = this.service.getBean((IMObject)location);
        Policy policy = Policies.newPolicy(SequencedRelationship.class).orderBySequence().active().build();
        for (Entity view : bean.getTargets("scheduleViews", Entity.class, policy)) {
            IMObjectBean viewBean = this.service.getBean((IMObject)view);
            if (!viewBean.hasTarget("schedules", (IMObject)schedule)) continue;
            return view;
        }
        return null;
    }

    public Party getLocation(Entity schedule) {
        IMObjectBean bean = this.service.getBean((IMObject)schedule);
        return (Party)bean.getTarget("location", Party.class);
    }

    public int getSlotSize(Entity schedule) {
        IMObjectBean bean = this.service.getBean((IMObject)schedule);
        return this.getSlotSize(bean);
    }

    public Entity getDefaultAppointmentType(Entity schedule) {
        return EntityRelationshipHelper.getDefaultTarget(schedule, "appointmentTypes", false, (ArchetypeService)this.service);
    }

    public Date calculateEndTime(Date startTime, Entity schedule, Entity appointmentType) {
        IMObjectBean bean = this.service.getBean((IMObject)schedule);
        int noSlots = this.getSlots(bean, appointmentType);
        int minutes = this.getSlotSize(bean) * noSlots;
        return DateRules.getDate(startTime, minutes, DateUnits.MINUTES);
    }

    public void updateTask(Act act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        List tasks = bean.getTargets("tasks", Act.class);
        if (!tasks.isEmpty()) {
            Act task = (Act)tasks.get(0);
            this.updateStatus(act, task);
        }
    }

    public void updateAppointment(Act act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        List appointments = bean.getSources("appointments", Act.class);
        if (!appointments.isEmpty()) {
            Act appointment = (Act)appointments.get(0);
            this.updateStatus(act, appointment);
        }
    }

    public Act getActivePatientAppointment(Party patient) {
        ArchetypeQuery query = new ArchetypeQuery("act.customerAppointment", true, true);
        query.add((IConstraint)Constraints.join((String)PATIENT).add((IConstraint)Constraints.eq((String)ENTITY, (Reference)patient.getObjectReference())));
        query.add((IConstraint)Constraints.not((IConstraint)Constraints.in((String)STATUS, (Object[])new Object[]{"PENDING", "CONFIRMED", "CANCELLED", "NO_SHOW"})));
        query.add((IConstraint)new NodeSortConstraint(START_TIME, false));
        query.setMaxResults(1);
        IMObjectQueryIterator iter = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iter.hasNext() ? (Act)iter.next() : null;
    }

    public Iterable<Act> getActiveCustomerAppointments(Party customer, Party location, Act exclude) {
        ArchetypeQuery query = new ArchetypeQuery("act.customerAppointment", true, true);
        query.add((IConstraint)Constraints.join((String)"customer").add((IConstraint)Constraints.eq((String)ENTITY, (Object)customer)));
        query.add((IConstraint)Constraints.join((String)"schedule").add((IConstraint)Constraints.join((String)ENTITY, (BaseArchetypeConstraint)Constraints.shortName((String)"party.organisationSchedule")).add((IConstraint)Constraints.join((String)"location").add((IConstraint)Constraints.eq((String)"target", (Object)location)))));
        if (exclude != null) {
            query.add((IConstraint)Constraints.ne((String)"id", (Object)exclude.getId()));
        }
        query.add((IConstraint)Constraints.not((IConstraint)Constraints.in((String)STATUS, (Object[])new Object[]{"PENDING", "CONFIRMED", "COMPLETED", "CANCELLED", "NO_SHOW"})));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(-1);
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    public Act copy(Act appointment) {
        AppointmentCopyHandler handler = new AppointmentCopyHandler();
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)handler, (ArchetypeService)this.service);
        return (Act)copier.apply((IMObject)appointment).get(0);
    }

    public boolean isRemindersEnabled(Entity entity) {
        if (entity != null) {
            IMObjectBean bean = this.service.getBean((IMObject)entity);
            return bean.getBoolean("sendReminders");
        }
        return false;
    }

    public Period getNoReminderPeriod() {
        AppointmentReminderConfig config = this.getAppointmentReminderConfig();
        return config != null ? config.getNoReminderPeriod() : null;
    }

    public AppointmentReminderConfig getAppointmentReminderConfig() {
        AppointmentReminderConfig config = null;
        Entity object = this.getAppointmentReminderJob();
        if (object != null) {
            config = new AppointmentReminderConfig(object, (ArchetypeService)this.service);
        }
        return config;
    }

    public boolean isBoardingAppointment(Act appointment) {
        return BoardingHelper.isBoardingAppointment(appointment, (ArchetypeService)this.service);
    }

    public int getBoardingDays(Act appointment) {
        return this.getBoardingDays(appointment.getActivityStartTime(), appointment.getActivityEndTime());
    }

    public int getBoardingDays(Date startTime, Date endTime) {
        DateMidnight end = new DateMidnight((Object)endTime);
        int days = Days.daysBetween((ReadableInstant)new DateMidnight((Object)startTime), (ReadableInstant)end).getDays();
        if (days < 0) {
            days = 0;
        } else if (DateRules.compareTo(endTime, end.toDate()) != 0) {
            ++days;
        }
        return days;
    }

    public int getBoardingNights(Date startTime, Date endTime) {
        int days = this.getBoardingDays(startTime, endTime);
        return days > 1 ? days - 1 : days;
    }

    public boolean checkRoster(Act appointment, Party location) {
        IMObjectBean bean;
        boolean check = false;
        Date startTime = appointment.getActivityStartTime();
        Date endTime = appointment.getActivityEndTime();
        if (startTime != null && endTime != null && DateRules.compareDateToToday(startTime) >= 0 && (bean = this.service.getBean((IMObject)location)).getBoolean("rostering")) {
            Date now = new Date();
            Period period = PeriodHelper.getPeriod(bean, "rosterCheckPeriod");
            if (period != null && DateRules.compareTo(startTime, DateRules.plus(now, period)) < 0) {
                check = true;
            }
        }
        return check;
    }

    public boolean rosterAreaHasSchedule(Entity rosterArea, Entity schedule) {
        IMObjectBean bean = this.service.getBean((IMObject)rosterArea);
        return bean.hasTarget("schedules", (IMObject)schedule);
    }

    public Act getEvent(Act appointment) {
        IMObjectBean bean = this.service.getBean((IMObject)appointment);
        return (Act)bean.getTarget("event", Act.class);
    }

    public Iterable<Act> getPendingCustomerAppointments(Party customer, int interval, DateUnits units) {
        ArchetypeQuery query = this.createPendingAppointmentQuery(customer, "customer", interval, units);
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    public Iterable<Act> getPendingPatientAppointments(Party patient, int interval, DateUnits units) {
        ArchetypeQuery query = this.createPendingAppointmentQuery(patient, PATIENT, interval, units);
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    public Act getNextPatientAppointment(Party patient, Date date) {
        ArchetypeQuery query = this.createPendingAppointmentQuery(patient, PATIENT, date);
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (Act)iterator.next() : null;
    }

    public int getSlotMinutes(Date time, int slotSize, boolean roundUp) {
        int mins = this.getMinutes(time);
        int result = this.getNearestSlot(mins, slotSize);
        if (result != mins && roundUp) {
            result += slotSize;
        }
        return result;
    }

    public Date getSlotTime(Date time, int slotSize, boolean roundUp) {
        Date result;
        int mins = this.getMinutes(time);
        int nearestSlot = this.getNearestSlot(mins, slotSize);
        if (nearestSlot != mins) {
            Date day = DateRules.getDate(time);
            if (slotSize != 1440) {
                if (roundUp && nearestSlot < mins) {
                    nearestSlot += slotSize;
                }
                ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(day.toInstant(), ZoneId.systemDefault()).plusMinutes(nearestSlot);
                result = Date.from(zonedDateTime.toInstant());
            } else {
                result = roundUp ? DateRules.getDate(day, 1, DateUnits.DAYS) : day;
            }
        } else {
            result = time;
        }
        return result;
    }

    public Times getOverlap(Date startTime, Date endTime, Entity schedule) {
        Times result = null;
        boolean limit = false;
        Date lowerbound = null;
        Date upperbound = null;
        IMObjectBean bean = this.service.getBean((IMObject)schedule);
        int maxDuration = bean.getInt("maxDuration", -1);
        DateUnits units = DateUnits.fromString(bean.getString("maxDurationUnits"), null);
        if (maxDuration > 0 && units != null) {
            limit = true;
            lowerbound = DateRules.getDate(startTime, -maxDuration, units);
            upperbound = DateRules.getDate(endTime, maxDuration, units);
        }
        ArchetypeQuery query = new ArchetypeQuery("act.customerAppointment");
        query.getArchetypeConstraint().setAlias("act");
        query.add((IConstraint)new ObjectRefSelectConstraint("act"));
        query.add((IConstraint)new NodeSelectConstraint(START_TIME));
        query.add((IConstraint)new NodeSelectConstraint("endTime"));
        JoinConstraint participation = Constraints.join((String)"schedule");
        participation.add((IConstraint)Constraints.eq((String)ENTITY, (Object)schedule));
        participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.customerAppointment"));
        if (limit) {
            participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.GTE, (Object)lowerbound));
            participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.LT, (Object)upperbound));
            participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.GT, (Object)lowerbound));
            participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.LTE, (Object)upperbound));
        }
        participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.LT, (Object)endTime));
        participation.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.GT, (Object)startTime));
        query.add((IConstraint)participation);
        query.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.lt((String)START_TIME, (Object)endTime), Constraints.gt((String)"endTime", (Object)startTime)}));
        query.add((IConstraint)Constraints.sort((String)START_TIME));
        query.add((IConstraint)Constraints.ne((String)STATUS, (Object)"CANCELLED"));
        query.setMaxResults(1);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        if (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            result = new Times((Reference)set.getReference("act.reference"), set.getDate("act.startTime"), set.getDate("act.endTime"));
        }
        return result;
    }

    public Act getAppointmentEventLongerThanDuration(Entity schedule, Date from, int duration, DateUnits units) {
        NamedQuery query = new NamedQuery("getAppointmentEventsLongerThanDuration", new String[]{"archetype", "id"});
        query.setParameter("scheduleId", (Object)schedule.getId());
        query.setParameter("from", (Object)from);
        query.setParameter("duration", (Object)units.toPeriod(duration).toStandardMinutes().getMinutes());
        query.setMaxResults(1);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator((IArchetypeQuery)query);
        ObjectSet set = iterator.hasNext() ? (ObjectSet)iterator.next() : null;
        return set != null ? (Act)this.service.get(set.getString("archetype"), set.getLong("id"), Act.class) : null;
    }

    public boolean sendReminder(Act appointment) {
        IMObjectBean bean = this.service.getBean((IMObject)appointment);
        return bean.getBoolean("sendReminder");
    }

    public void setSMSReminderSent(Act appointment, Date date) {
        IMObjectBean bean = this.service.getBean((IMObject)appointment);
        bean.setValue("reminderSent", (Object)date);
        bean.setValue("reminderError", null);
        if (!"RECEIVED".equals(bean.getString("smsStatus"))) {
            bean.setValue("smsStatus", (Object)"SENT");
        }
        bean.save();
    }

    protected int getNearestSlot(int mins, int slotSize) {
        return mins / slotSize * slotSize;
    }

    protected ArchetypeQuery createPendingAppointmentQuery(Party party, String node, int interval, DateUnits units) {
        Date from = new Date();
        ArchetypeQuery query = this.createPendingAppointmentQuery(party, node, from);
        Date to = DateRules.getDate(from, interval, units);
        query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)to));
        return query;
    }

    protected Entity getAppointmentReminderJob() {
        ArchetypeQuery query = new ArchetypeQuery(APPOINTMENT_REMINDER_JOB, true, true);
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (Entity)iterator.next() : null;
    }

    private int getMinutes(Date time) {
        ZonedDateTime zoned = ZonedDateTime.ofInstant(time.toInstant(), ZoneId.systemDefault());
        ZonedDateTime start = zoned.toLocalDate().atStartOfDay(ZoneId.systemDefault());
        return (int)Duration.between(start, zoned).toMinutes();
    }

    private ArchetypeQuery createPendingAppointmentQuery(Party party, String node, Date from) {
        ArchetypeQuery query = new ArchetypeQuery("act.customerAppointment");
        query.add((IConstraint)Constraints.join((String)node).add((IConstraint)Constraints.eq((String)ENTITY, (Object)party)));
        query.add((IConstraint)Constraints.in((String)STATUS, (Object[])new Object[]{"PENDING", "CONFIRMED"}));
        query.add((IConstraint)Constraints.gte((String)START_TIME, (Object)from));
        query.add((IConstraint)Constraints.sort((String)START_TIME));
        query.add((IConstraint)Constraints.sort((String)"id"));
        return query;
    }

    private int getSlotSize(IMObjectBean schedule) {
        int slotSize = schedule.getInt("slotSize");
        String slotUnits = schedule.getString("slotUnits");
        int result = "HOURS".equals(slotUnits) ? slotSize * 60 : slotSize;
        return result;
    }

    private int getSlots(IMObjectBean schedule, Entity appointmentType) {
        int noSlots = 0;
        EntityRelationship relationship = (EntityRelationship)schedule.getValue("appointmentTypes", EntityRelationship.class, Predicates.targetEquals((IMObject)appointmentType));
        if (relationship != null) {
            IMObjectBean bean = this.service.getBean((IMObject)relationship);
            noSlots = bean.getInt("noSlots");
        }
        return noSlots;
    }

    private void updateStatus(Act act, Act linked) {
        String status = act.getStatus();
        if (("IN_PROGRESS".equals(status) || "BILLED".equals(status) || "COMPLETED".equals(status) || "CANCELLED".equals(status)) && !status.equals(linked.getStatus())) {
            linked.setStatus(status);
            if (linked.isA("act.customerTask") && "COMPLETED".equals(status)) {
                linked.setActivityEndTime(new Date());
            }
            this.service.save((IMObject)linked);
        }
    }

    private static class AppointmentCopyHandler
    extends ActCopyHandler {
        public AppointmentCopyHandler() {
            this.setCopy(Act.class, Participation.class);
            this.setExclude(ActRelationship.class);
        }

        @Override
        protected boolean checkCopyable(ArchetypeDescriptor archetype, NodeDescriptor node) {
            return true;
        }
    }
}

