/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.MonitoringIMObjectCache;
import org.openvpms.component.business.service.security.AuthenticationContext;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SettingsCache
implements DisposableBean {
    private final ArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final SingletonService singletonService;
    private final AuthenticationContext context;
    private final UserRules userRules;
    private final Cache cache;

    public SettingsCache(IArchetypeService service, PlatformTransactionManager transactionManager, SingletonService singletonService, AuthenticationContext context, UserRules userRules) {
        this.service = service;
        this.transactionManager = transactionManager;
        this.singletonService = singletonService;
        this.context = context;
        this.userRules = userRules;
        this.cache = new Cache(service);
    }

    public IMObjectBean getGroup(String name) {
        return this.getGroup(name, false);
    }

    public IMObjectBean getGroup(String name, boolean useCached) {
        IMObjectBean bean = null;
        if (useCached) {
            bean = this.cache.get(name);
        }
        if (bean == null) {
            bean = this.loadGroup(name);
        }
        return bean;
    }

    public void destroy() {
        this.cache.destroy();
    }

    private IMObjectBean loadGroup(String name) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.setPropagationBehavior(3);
        boolean create = this.canSaveSettings(name);
        Entity result = (Entity)template.execute(status -> {
            Entity entity = (Entity)this.singletonService.get(name, Entity.class, create);
            if (entity == null) {
                entity = this.create(name);
            }
            return entity;
        });
        IMObjectBean bean = this.cache.cache(result);
        if (bean == null) {
            bean = this.service.getBean((IMObject)result);
        }
        return bean;
    }

    private Entity create(String archetype) {
        ArchetypeService archetypeService = null;
        if (AopUtils.isAopProxy((Object)this.service) && this.service instanceof Advised) {
            try {
                archetypeService = (ArchetypeService)((Advised)this.service).getTargetSource().getTarget();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (archetypeService == null) {
            archetypeService = this.service;
        }
        return (Entity)archetypeService.create(archetype, Entity.class);
    }

    private boolean canSaveSettings(String archetype) {
        User user = this.context.getUser();
        return user != null && this.userRules.canSave(this.context.getUser(), archetype);
    }

    private class Cache
    extends MonitoringIMObjectCache<Entity> {
        private final Map<String, IMObjectBean> groups;

        public Cache(IArchetypeService service) {
            super(service, "entity.globalSettings*", Entity.class, false);
            this.groups = Collections.synchronizedMap(new HashMap());
        }

        public IMObjectBean cache(Entity object) {
            this.addObject((IMObject)object);
            return this.groups.get(object.getArchetype());
        }

        public IMObjectBean get(String archetype) {
            return this.groups.get(archetype);
        }

        protected void added(Entity object) {
            IMObjectBean bean = SettingsCache.this.service.getBean((IMObject)object);
            this.groups.put(object.getArchetype(), bean);
        }

        protected void removed(Entity object) {
            this.groups.remove(object.getArchetype());
        }
    }
}

