/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.PriceCollector;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ProductPriceUpdaterException;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class ProductPriceUpdater {
    private final IArchetypeService service;
    private final ProductPriceRules rules;
    private final PracticeRules practiceRules;
    private Party practice;
    private Currency currency;

    public ProductPriceUpdater(ProductPriceRules priceRules, PracticeRules practiceRules, IArchetypeService service) {
        this.service = service;
        this.rules = priceRules;
        this.practiceRules = practiceRules;
    }

    public List<ProductPrice> update(Product product) {
        List<ProductPrice> result;
        PriceCollector collector = new PriceCollector((ArchetypeService)this.service);
        if (this.needsUpdate(product)) {
            IMObjectBean bean = this.service.getBean((org.openvpms.component.model.object.IMObject)product);
            List relationships = bean.getValues("suppliers", EntityLink.class);
            for (EntityLink relationship : relationships) {
                ProductSupplier ps = new ProductSupplier((Relationship)relationship, this.service);
                this.doUpdate(ps, product, false, collector);
            }
            result = collector.save();
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<ProductPrice> update(Product product, ProductSupplier productSupplier, boolean save) {
        return this.update(product, productSupplier, false, save);
    }

    public List<ProductPrice> update(Product product, ProductSupplier productSupplier, boolean ignoreCostDecrease, boolean save) {
        PriceCollector collector = new PriceCollector((ArchetypeService)this.service);
        this.update(product, productSupplier, ignoreCostDecrease, collector);
        return save ? collector.save() : collector.deriveValues();
    }

    public List<ProductPrice> update(Product product, BigDecimal cost, boolean ignoreCostDecrease, boolean save) {
        PriceCollector collector = new PriceCollector((ArchetypeService)this.service);
        this.doUpdate(product, cost, ignoreCostDecrease, collector);
        return save ? collector.save() : collector.deriveValues();
    }

    public void update(Product product, ProductSupplier productSupplier, boolean ignoreCostDecrease, PriceCollector collector) {
        this.doUpdate(productSupplier, product, ignoreCostDecrease, collector);
    }

    public Party getPractice() {
        if (this.practice == null) {
            this.practice = this.practiceRules.getPractice();
            if (this.practice == null) {
                throw new ProductPriceUpdaterException(ProductPriceUpdaterException.ErrorCode.NoPractice, new Object[0]);
            }
        }
        return this.practice;
    }

    private boolean needsUpdate(Product product) {
        Set<EntityLink> newSuppliers;
        Set<EntityLink> oldSuppliers;
        Product prior;
        boolean update = true;
        if (!product.isNew() && (prior = (Product)this.service.get(product.getObjectReference())) != null && (oldSuppliers = this.getProductSuppliers(prior)).equals(newSuppliers = this.getProductSuppliers(product))) {
            update = !this.checkEquals(oldSuppliers, newSuppliers);
        }
        return update;
    }

    private boolean checkEquals(Set<EntityLink> oldSuppliers, Set<EntityLink> newSuppliers) {
        Map<Reference, ProductSupplier> oldMap = this.getProductSuppliers(oldSuppliers);
        Map<Reference, ProductSupplier> newMap = this.getProductSuppliers(newSuppliers);
        for (Map.Entry<Reference, ProductSupplier> entry : newMap.entrySet()) {
            ProductSupplier supplier = entry.getValue();
            ProductSupplier old = oldMap.get(entry.getKey());
            if (old != null && MathRules.equals(supplier.getListPrice(), old.getListPrice()) && supplier.getPackageSize() == old.getPackageSize()) continue;
            return false;
        }
        return true;
    }

    private Map<Reference, ProductSupplier> getProductSuppliers(Set<EntityLink> suppliers) {
        HashMap<Reference, ProductSupplier> result = new HashMap<Reference, ProductSupplier>();
        for (EntityLink supplier : suppliers) {
            result.put(supplier.getObjectReference(), new ProductSupplier((Relationship)supplier, this.service));
        }
        return result;
    }

    private boolean canUpdate(ProductSupplier productSupplier) {
        return productSupplier.isAutoPriceUpdate() && !MathRules.isZero(productSupplier.getCostPrice()) && this.isActive(productSupplier.getSupplierRef());
    }

    private void doUpdate(ProductSupplier productSupplier, Product product, boolean ignoreCostDecrease, PriceCollector collector) {
        if (!product.getObjectReference().equals((Object)productSupplier.getRelationship().getSource())) {
            throw new IllegalArgumentException("Argument 'product' is not that referred to by 'productSupplier'");
        }
        if (this.canUpdate(productSupplier)) {
            BigDecimal cost = productSupplier.getCostPrice();
            this.doUpdate(product, cost, ignoreCostDecrease, collector);
        }
    }

    private void doUpdate(Product product, BigDecimal cost, boolean ignoreCostDecrease, PriceCollector collector) {
        List<ProductPrice> prices = this.rules.updateUnitPrices(product, cost, ignoreCostDecrease, this.getCurrency());
        if (!prices.isEmpty()) {
            collector.add(product, prices);
        }
    }

    private Currency getCurrency() {
        if (this.currency == null) {
            this.currency = this.practiceRules.getCurrency(this.getPractice());
        }
        return this.currency;
    }

    private boolean isActive(IMObjectReference reference) {
        boolean result = false;
        if (reference != null) {
            if (reference.isNew()) {
                IMObject object = this.service.get((Reference)reference);
                result = object == null || object.isActive();
            } else {
                ObjectRefConstraint constraint = new ObjectRefConstraint("o", (Reference)reference);
                ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)constraint);
                query.add((IConstraint)new NodeSelectConstraint("o.active"));
                query.setMaxResults(1);
                ObjectSetQueryIterator iter = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
                if (iter.hasNext()) {
                    ObjectSet set = (ObjectSet)iter.next();
                    result = set.getBoolean("o.active");
                }
            }
        }
        return result;
    }

    private Set<EntityLink> getProductSuppliers(Product product) {
        IMObjectBean bean = this.service.getBean((org.openvpms.component.model.object.IMObject)product);
        return new HashSet<EntityLink>(bean.getValues("suppliers", EntityLink.class));
    }
}

