/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.product.DemographicUpdateException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.NodeResolver;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;

public class DemographicUpdater {
    private final IArchetypeService service;

    public DemographicUpdater(IArchetypeService service) {
        this.service = service;
    }

    public void evaluate(IMObject object, Lookup update) {
        if (!update.isA("lookup.demographicUpdate")) {
            throw new DemographicUpdateException(DemographicUpdateException.ErrorCode.InvalidDemographicUpdate, update.getName(), update.getArchetype());
        }
        try {
            IMObjectBean bean = this.service.getBean((IMObject)update);
            String expression = bean.getString("expression");
            String node = bean.getString("nodeName");
            Object context = !StringUtils.isEmpty((CharSequence)node) ? new NodeResolver(object, (ArchetypeService)this.service).getObject(node) : object;
            if (context == null) {
                throw new DemographicUpdateException(DemographicUpdateException.ErrorCode.NoContext, update.getName());
            }
            JXPathHelper.newContext((Object)context).getValue(expression);
        }
        catch (DemographicUpdateException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new DemographicUpdateException(DemographicUpdateException.ErrorCode.FailedToEvaluate, exception, update.getName());
        }
    }

    public void evaluate(IMObject object, Collection<Lookup> updates) {
        for (Lookup update : updates) {
            this.evaluate(object, update);
        }
    }
}

