/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.practice;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class MailServer {
    private final long id;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final Security security;
    private final AuthenticationMethod authenticationMethod;
    private final String oauthClientRegistrationId;
    private final int timeout;

    public MailServer(Entity configuration, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)configuration);
        this.id = configuration.getId();
        this.host = bean.getString("host");
        this.port = bean.getInt("port");
        this.username = StringUtils.trimToNull((String)bean.getString("username"));
        this.password = StringUtils.trimToNull((String)bean.getString("password"));
        this.security = this.getSecurity(bean.getString("security"));
        this.authenticationMethod = this.getAuthenticationMethod(bean.getString("authenticationMethod"));
        this.oauthClientRegistrationId = bean.getString("oauth2ClientRegistration");
        this.timeout = bean.getInt("timeout");
    }

    public long getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Security getSecurity() {
        return this.security;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getOauthClientRegistrationId() {
        return this.oauthClientRegistrationId;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MailServer) {
            MailServer other = (MailServer)obj;
            return this.port == other.port && StringUtils.equals((CharSequence)this.host, (CharSequence)other.host) && StringUtils.equals((CharSequence)this.username, (CharSequence)other.username) && StringUtils.equals((CharSequence)this.password, (CharSequence)other.password) && this.security == other.security && this.authenticationMethod == other.authenticationMethod && StringUtils.equals((CharSequence)this.oauthClientRegistrationId, (CharSequence)other.oauthClientRegistrationId) && this.timeout == other.timeout;
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)this.host).append(this.port).append((Object)this.username).append((Object)this.password).append((Object)this.security).append((Object)this.authenticationMethod).append((Object)this.oauthClientRegistrationId).append(this.timeout);
        return builder.toHashCode();
    }

    private Security getSecurity(String security) {
        if ("STARTTLS".equals(security)) {
            return Security.STARTTLS;
        }
        if ("SSL_TLS".equals(security)) {
            return Security.SSL_TLS;
        }
        return Security.NONE;
    }

    private AuthenticationMethod getAuthenticationMethod(String authenticationMethod) {
        if (AuthenticationMethod.OAUTH2.toString().equals(authenticationMethod)) {
            return AuthenticationMethod.OAUTH2;
        }
        return AuthenticationMethod.PASSWORD;
    }

    public static enum AuthenticationMethod {
        PASSWORD,
        OAUTH2;

    }

    public static enum Security {
        NONE,
        STARTTLS,
        SSL_TLS;

    }
}

