/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectGraph;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.ObjectRelationship;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.bean.RelatedIMObjects;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.IterableIMObjectQuery;

public class ReminderRules {
    private final IArchetypeService service;
    private final PatientRules rules;
    private final ReminderTypes reminderTypes;
    private static final String PATIENT = "patient";
    private static final String ALERT_TYPE = "alertType";
    private static final String REMINDERS = "reminders";
    private static final String PRODUCT = "product";
    private static final String ENTITY = "entity";
    private static final String TYPE = "type";
    private static final String TARGET = "target";
    private static final String NAME = "name";
    private static final String REMINDER_TYPE = "reminderType";

    public ReminderRules(IArchetypeService service, PatientRules patientRules) {
        this(service, null, patientRules);
    }

    public ReminderRules(IArchetypeService service, ReminderTypes reminderTypes, PatientRules rules) {
        this.service = service;
        this.rules = rules;
        this.reminderTypes = reminderTypes;
    }

    public ReminderConfiguration getConfiguration(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        IMObject object = bean.getTarget("reminderConfiguration", IMObject.class);
        return object != null ? new ReminderConfiguration(object, (ArchetypeService)this.service) : null;
    }

    public void markMatchingRemindersCompleted(List<Act> reminders) {
        if (!reminders.isEmpty()) {
            reminders = new ArrayList<Act>(reminders);
            while (!reminders.isEmpty()) {
                Act reminder = reminders.remove(0);
                if (!"IN_PROGRESS".equals(reminder.getStatus())) continue;
                IMObjectBean bean = this.service.getBean((IMObject)reminder);
                ReminderType type = this.getReminderType(bean);
                Reference patient = bean.getTargetRef(PATIENT);
                if (type == null || patient == null) continue;
                for (Act other : reminders.toArray(new Act[0])) {
                    IMObjectBean otherBean = this.service.getBean((IMObject)other);
                    if (!Objects.equals(patient, otherBean.getTargetRef(PATIENT)) || !this.hasMatchingTypeOrGroup(other, type)) continue;
                    this.markCompleted(other);
                    reminders.remove(other);
                }
                this.doMarkMatchingRemindersCompleted(reminder, type, patient);
            }
        }
    }

    public void markMatchingRemindersCompleted(Act reminder) {
        this.doMarkMatchingRemindersCompleted(reminder);
    }

    public void markMatchingAlertsCompleted(Act alert) {
        if ("IN_PROGRESS".equals(alert.getStatus())) {
            IMObjectBean bean = this.service.getBean((IMObject)alert);
            Reference patient = bean.getTargetRef(PATIENT);
            Reference alertType = bean.getTargetRef(ALERT_TYPE);
            if (alertType != null && patient != null) {
                this.markMatchingAlertsCompleted(alert, patient, alertType);
            }
        }
    }

    public void markMatchingAlertsCompleted(List<Act> alerts) {
        if (!alerts.isEmpty()) {
            alerts = new ArrayList<Act>(alerts);
            while (!alerts.isEmpty()) {
                Act alert = alerts.remove(0);
                if (!"IN_PROGRESS".equals(alert.getStatus())) continue;
                IMObjectBean bean = this.service.getBean((IMObject)alert);
                Reference alertType = bean.getTargetRef(ALERT_TYPE);
                Reference patient = bean.getTargetRef(PATIENT);
                if (alertType != null && patient != null) {
                    for (Act other : alerts.toArray(new Act[0])) {
                        IMObjectBean otherBean = this.service.getBean((IMObject)other);
                        if (!Objects.equals(patient, otherBean.getTargetRef(PATIENT)) || !Objects.equals(alertType, otherBean.getTargetRef(ALERT_TYPE))) continue;
                        this.markAlertCompleted(other);
                        alerts.remove(other);
                    }
                }
                this.markMatchingAlertsCompleted(alert, patient, alertType);
            }
        }
    }

    public Date calculateReminderDueDate(Date date, Entity reminderType) {
        ReminderType type = new ReminderType(reminderType, (ArchetypeService)this.service);
        return type.getDueDate(date);
    }

    public Date getNextReminderDate(Date due, Entity reminderType, int reminderCount) {
        ReminderType type = new ReminderType(reminderType, (ArchetypeService)this.service);
        return type.getNextDueDate(due, reminderCount);
    }

    public Date calculateProductReminderDueDate(Date date, Relationship relationship) {
        IMObjectBean bean = this.service.getBean((IMObject)relationship);
        int period = bean.getInt("period");
        String uom = bean.getString("periodUom", "YEARS");
        return DateRules.getDate(date, period, DateUnits.valueOf(uom));
    }

    public boolean shouldCancel(Act reminder, Date date) {
        boolean result = true;
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        ReminderType reminderType = this.getReminderType(bean);
        if (reminderType != null) {
            Date due = reminder.getActivityStartTime();
            result = reminderType.shouldCancel(due, date);
        }
        if (!result) {
            Party patient = (Party)bean.getTarget(PATIENT, Party.class);
            result = patient == null || this.rules.isDeceased(patient);
        }
        return result;
    }

    public boolean updateReminder(Act reminder, Act item) {
        IMObjectBean itemBean;
        int count;
        boolean result = false;
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        if (!this.hasOutstandingItems(bean, item) && (count = (itemBean = this.service.getBean((IMObject)item)).getInt("count")) == bean.getInt("reminderCount")) {
            Date dueDate;
            bean.setValue("reminderCount", (Object)(++count));
            result = true;
            ReminderType reminderType = this.getReminderType(bean);
            if (reminderType != null && (dueDate = reminderType.getNextDueDate(reminder.getActivityEndTime(), count)) != null) {
                reminder.setActivityStartTime(dueDate);
            }
        }
        return result;
    }

    public Map<Entity, Relationship> getReminderTypes(Product product, String species) {
        Map<Entity, Relationship> map = this.getReminderTypes(product);
        HashMap<Entity, Relationship> result = new HashMap<Entity, Relationship>();
        for (Map.Entry<Entity, Relationship> entry : map.entrySet()) {
            Entity reminderType = entry.getKey();
            if (species != null && !this.reminderTypeIsForSpecies(reminderType, species)) continue;
            result.put(reminderType, entry.getValue());
        }
        return result;
    }

    public Act getDocumentFormReminder(DocumentAct form) {
        Act invoiceItem = null;
        for (ActRelationship relationship : form.getTargetActRelationships()) {
            if (!"actRelationship.invoiceItemDocument".equals(relationship.getArchetype())) continue;
            invoiceItem = (Act)this.service.get(relationship.getSource(), Act.class);
            break;
        }
        Act result = invoiceItem != null ? this.getInvoiceReminder(invoiceItem) : this.getProductReminder((Act)form);
        return result;
    }

    public DueState getDueState(Act reminder) {
        return this.getDueState(reminder, new Date());
    }

    public DueState getDueState(Act reminder, Date date) {
        IMObjectBean act = this.service.getBean((IMObject)reminder);
        DueState result = DueState.NOT_DUE;
        Entity reminderType = (Entity)act.getTarget(REMINDER_TYPE, Entity.class);
        if (reminderType != null) {
            IMObjectBean bean = this.service.getBean((IMObject)reminderType);
            String sensitivityUnits = bean.getString("sensitivityUnits");
            if (sensitivityUnits == null) {
                sensitivityUnits = DateUnits.DAYS.toString();
            }
            int interval = bean.getInt("sensitivityInterval");
            DateUnits units = DateUnits.valueOf(sensitivityUnits);
            Date from = DateRules.getDate(date, -interval, units);
            Date to = DateRules.getDate(date, interval, units);
            Date dueDate = reminder.getActivityEndTime();
            if (dueDate != null) {
                if (DateRules.compareTo(dueDate, from) < 0) {
                    result = DueState.OVERDUE;
                } else if (DateRules.compareTo(dueDate, to) <= 0) {
                    result = DueState.DUE;
                }
            }
        }
        return result;
    }

    public Iterable<Act> getReminders(Party patient, Date from, Date to) {
        ArchetypeQuery query = this.createQuery(patient);
        return this.getReminders(query, from, to);
    }

    public Iterable<Act> getReminders(Party patient, String productType, Date from, Date to) {
        ArchetypeQuery query = this.createQuery(patient);
        query.add((IConstraint)Constraints.join((String)PRODUCT).add((IConstraint)Constraints.join((String)ENTITY).add((IConstraint)Constraints.join((String)TYPE).add((IConstraint)Constraints.join((String)TARGET).add((IConstraint)Constraints.eq((String)NAME, (Object)productType))))));
        return this.getReminders(query, from, to);
    }

    public Act getReminderItem(Act reminder, int count, Contact contact) {
        Act result = null;
        boolean email = contact.isA("contact.email");
        boolean phone = contact.isA("contact.phoneNumber");
        boolean location = contact.isA("contact.location");
        if (email || phone || location) {
            IMObjectBean bean = this.service.getBean((IMObject)reminder);
            for (Act item : bean.getTargets("items", Act.class)) {
                if (!this.matchingReminderItem(item, count, email, phone, location)) continue;
                result = item;
                break;
            }
        }
        return result;
    }

    public IMObjectGraph copyReminderType(Entity reminderType) {
        IMObjectCopier copier = IMObjectCopier.newCopier((ArchetypeService)this.service).copy(new IMObject[]{reminderType}).copy(new String[]{"entity.reminderCount", "entity.reminderRule", "entityLink.reminderTypeCount", "entityLink.reminderCountRule", "entityLink.reminderCountTemplate"}).referenceByDefault().build();
        return copier.copy((IMObject)reminderType);
    }

    protected List<Act> getReminders(ArchetypeQuery query, Date from, Date to) {
        ArrayList<Act> result = new ArrayList<Act>();
        for (Act act : new IterableIMObjectQuery(this.service, (IArchetypeQuery)query)) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            Date date = bean.getDate("initialTime");
            if (date == null || !DateRules.between(date, from, to)) continue;
            result.add(act);
        }
        return result;
    }

    private Map<Entity, Relationship> getReminderTypes(Product product) {
        Map<Entity, Relationship> result;
        IMObjectBean bean = this.service.getBean((IMObject)product);
        if (bean.hasNode(REMINDERS)) {
            result = new HashMap();
            RelatedIMObjects reminders = bean.getRelated(REMINDERS, Entity.class);
            for (ObjectRelationship item : ((RelatedIMObjects)reminders.active()).getObjectRelationships()) {
                result.put((Entity)item.getObject(), (Relationship)item.getRelationship());
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private boolean reminderTypeIsForSpecies(Entity reminderType, String species) {
        boolean result = false;
        IMObjectBean bean = this.service.getBean((IMObject)reminderType);
        List supported = bean.getValues("species", Lookup.class);
        if (supported.isEmpty()) {
            result = true;
        } else {
            for (Lookup lookup : supported) {
                if (!species.equals(lookup.getCode())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean matchingReminderItem(Act item, int count, boolean email, boolean sms, boolean print) {
        boolean result = false;
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        if (itemBean.getInt("count") == count && (item.isA("act.patientReminderItemEmail") && email || item.isA("act.patientReminderItemSMS") && sms || item.isA("act.patientReminderItemPrint") && print)) {
            result = true;
        }
        return result;
    }

    private ArchetypeQuery createQuery(Party patient) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientReminder");
        query.add((IConstraint)Constraints.join((String)PATIENT).add((IConstraint)Constraints.eq((String)ENTITY, (Object)patient)));
        return query;
    }

    private Act getInvoiceReminder(Act invoiceItem) {
        Act result = null;
        IMObjectBean bean = this.service.getBean((IMObject)invoiceItem);
        List reminders = bean.getTargets(REMINDERS, Act.class);
        for (Act reminder : reminders) {
            Date dueDate = reminder.getActivityEndTime();
            if (dueDate == null || result != null && !this.hasCloserDueDate(result, reminder)) continue;
            result = reminder;
        }
        return result;
    }

    private boolean hasCloserDueDate(Act current, Act reminder) {
        boolean result = false;
        int compare = DateRules.compareTo(reminder.getActivityEndTime(), current.getActivityEndTime());
        if (compare < 0 || compare == 0 && reminder.getId() < current.getId()) {
            result = true;
        }
        return result;
    }

    private Act getProductReminder(Act form) {
        Act result = null;
        Date resultDueDate = null;
        IMObjectBean formBean = this.service.getBean((IMObject)form);
        Product product = (Product)formBean.getTarget(PRODUCT, Product.class);
        if (product != null) {
            Party patient = (Party)formBean.getTarget(PATIENT, Party.class);
            Date startTime = formBean.getDate("startTime");
            Map<Entity, Relationship> types = this.getReminderTypes(product);
            for (Map.Entry<Entity, Relationship> entry : types.entrySet()) {
                Entity reminderType = entry.getKey();
                Relationship relationship = entry.getValue();
                Date dueDate = this.calculateProductReminderDueDate(startTime, relationship);
                if (resultDueDate != null && DateRules.compareTo(dueDate, resultDueDate) >= 1) continue;
                result = this.createReminder(reminderType, startTime, dueDate, patient, product);
                resultDueDate = dueDate;
            }
        }
        return result;
    }

    private boolean hasMatchingTypeOrGroup(Act reminder, ReminderType reminderType) {
        boolean result = false;
        ReminderType otherType = this.getReminderType(reminder);
        if (otherType != null) {
            if (otherType.getEntity().equals(reminderType.getEntity())) {
                result = true;
            } else {
                List<Lookup> groups = reminderType.getGroups();
                for (Lookup group : otherType.getGroups()) {
                    if (!groups.contains(group)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private ReminderType getReminderType(Act act) {
        return this.getReminderType(this.service.getBean((IMObject)act));
    }

    private ReminderType getReminderType(IMObjectBean bean) {
        ReminderType reminderType = null;
        if (this.reminderTypes != null) {
            reminderType = this.reminderTypes.get(bean.getTargetRef(REMINDER_TYPE));
        } else {
            Entity entity = (Entity)bean.getTarget(REMINDER_TYPE, Entity.class);
            if (entity != null) {
                reminderType = new ReminderType(entity, (ArchetypeService)this.service);
            }
        }
        return reminderType;
    }

    private void markCompleted(Act reminder) {
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        reminder.setStatus("COMPLETED");
        bean.setValue("completedDate", (Object)new Date());
        this.service.save((IMObject)reminder);
    }

    private void doMarkMatchingRemindersCompleted(Act reminder) {
        if ("IN_PROGRESS".equals(reminder.getStatus())) {
            IMObjectBean bean = this.service.getBean((IMObject)reminder);
            ReminderType reminderType = this.getReminderType(bean);
            Reference patient = bean.getTargetRef(PATIENT);
            if (reminderType != null && patient != null) {
                this.doMarkMatchingRemindersCompleted(reminder, reminderType, patient);
            }
        }
    }

    private void doMarkMatchingRemindersCompleted(Act reminder, ReminderType reminderType, Reference patient) {
        Date now;
        ArchetypeQuery query = new ArchetypeQuery("act.patientReminder", false, true);
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"IN_PROGRESS"));
        query.add((IConstraint)Constraints.join((String)PATIENT).add((IConstraint)Constraints.eq((String)ENTITY, (Reference)patient)));
        if (!reminder.isNew()) {
            query.add((IConstraint)Constraints.ne((String)"id", (Object)reminder.getId()));
        }
        query.setMaxResults(-1);
        IMObjectQueryIterator reminders = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        while (reminders.hasNext()) {
            Act act = (Act)reminders.next();
            if (!this.hasMatchingTypeOrGroup(act, reminderType)) continue;
            this.markCompleted(act);
        }
        Date dueDate = reminder.getActivityEndTime();
        if (DateRules.compareTo(dueDate, now = new Date()) <= 0) {
            this.markCompleted(reminder);
        }
    }

    private void markMatchingAlertsCompleted(Act alert, Reference patient, Reference alertType) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientAlert", false, true);
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"IN_PROGRESS"));
        query.add((IConstraint)Constraints.join((String)PATIENT).add((IConstraint)Constraints.eq((String)ENTITY, (Reference)patient)));
        query.add((IConstraint)Constraints.join((String)ALERT_TYPE).add((IConstraint)Constraints.eq((String)ENTITY, (Reference)alertType)));
        if (!alert.isNew()) {
            query.add((IConstraint)Constraints.ne((String)"id", (Object)alert.getId()));
        }
        query.setMaxResults(-1);
        IMObjectQueryIterator alerts = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        while (alerts.hasNext()) {
            Act next = (Act)alerts.next();
            this.markAlertCompleted(next);
        }
        Date endTime = alert.getActivityEndTime();
        if (endTime != null && DateRules.compareTo(endTime, new Date()) < 0) {
            this.markAlertCompleted(alert);
        }
    }

    private void markAlertCompleted(Act alert) {
        alert.setStatus("COMPLETED");
        alert.setActivityEndTime(new Date());
        this.service.save((IMObject)alert);
    }

    private Act createReminder(Entity reminderType, Date date, Date dueDate, Party patient, Product product) {
        Act result = (Act)this.service.create("act.patientReminder", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)result);
        result.setCreated(date);
        bean.setTarget(REMINDER_TYPE, (IMObject)reminderType);
        bean.setTarget(PATIENT, (IMObject)patient);
        if (product != null) {
            bean.setTarget(PRODUCT, (IMObject)product);
        }
        result.setActivityStartTime(dueDate);
        result.setActivityEndTime(dueDate);
        return result;
    }

    private boolean hasOutstandingItems(IMObjectBean reminder, Act item) {
        Policy policy = Policies.all(Predicates.targetEquals((IMObject)item).negate());
        for (Act act : reminder.getTargets("items", Act.class, policy)) {
            String status = act.getStatus();
            if (!"PENDING".equals(status) && !"ERROR".equals(status)) continue;
            return true;
        }
        return false;
    }

    public static enum DueState {
        NOT_DUE,
        DUE,
        OVERDUE;

    }
}

