/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

public class ReminderGroupingPolicy {
    public static final ReminderGroupingPolicy ALL = new ReminderGroupingPolicy(true, true, true);
    public static final ReminderGroupingPolicy NONE = new ReminderGroupingPolicy(false, false, false);
    private final boolean print;
    private final boolean email;
    private final boolean sms;

    private ReminderGroupingPolicy(boolean print, boolean email, boolean sms) {
        this.print = print;
        this.email = email;
        this.sms = sms;
    }

    public boolean group(String archetype) {
        return this.print && "act.patientReminderItemPrint".equals(archetype) || this.email && "act.patientReminderItemEmail".equals(archetype) || this.sms && "act.patientReminderItemSMS".equals(archetype);
    }

    public static ReminderGroupingPolicy getPolicy(boolean print, boolean email, boolean sms) {
        if (print && email && sms) {
            return ALL;
        }
        if (!(print || email || sms)) {
            return NONE;
        }
        return new ReminderGroupingPolicy(print, email, sms);
    }
}

