/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.party;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openvpms.archetype.rules.party.ContactCopyHandler;
import org.openvpms.archetype.rules.party.IMObjectRelationshipCopyHandler;
import org.openvpms.archetype.rules.party.MergeException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DefaultIMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;

public abstract class PartyMerger {
    private final String type;
    private final IArchetypeService service;
    private final IMObjectCopier relationshipCopier;
    private final IMObjectCopier contactCopier;

    protected PartyMerger(String type, IArchetypeService service) {
        this.type = type;
        this.service = service;
        this.relationshipCopier = new IMObjectCopier((IMObjectCopyHandler)new IMObjectRelationshipCopyHandler(), (ArchetypeService)service);
        this.contactCopier = new IMObjectCopier((IMObjectCopyHandler)new ContactCopyHandler(), (ArchetypeService)service);
    }

    public void merge(Party from, Party to) {
        if (from.getObjectReference().equals((Object)to.getObjectReference())) {
            throw new MergeException(MergeException.ErrorCode.CannotMergeToSameObject, this.getDisplayName());
        }
        this.checkParty(from);
        this.checkParty(to);
        LinkedHashSet<IMObject> merged = new LinkedHashSet<IMObject>();
        this.merge(from, to, merged);
        this.service.save(merged);
        this.service.remove((IMObject)from);
    }

    protected void merge(Party from, Party to, Set<IMObject> merged) {
        this.copyContacts(from, to);
        this.copyClassifications(from, to);
        this.copyEntityRelationships(from, to);
        this.copyEntityLinks(from, to);
        this.copyIdentities(from, to);
        List<IMObject> participations = this.moveParticipations(from, to);
        merged.add((IMObject)to);
        merged.addAll(participations);
        for (EntityRelationship relationship : from.getEntityRelationships()) {
            Entity other = this.getRelated(from, to, (Relationship)relationship);
            if (other == null) continue;
            other.removeEntityRelationship(relationship);
            merged.add((IMObject)other);
        }
    }

    protected void copyContacts(Party from, Party to) {
        Contact[] contacts;
        for (Contact contact : contacts = from.getContacts().toArray(new Contact[0])) {
            List objects = this.contactCopier.apply((IMObject)contact);
            Contact copy = (Contact)objects.get(0);
            to.addContact(copy);
        }
    }

    protected void copyClassifications(Party from, Party to) {
        for (Lookup lookup : from.getClassifications()) {
            to.addClassification(lookup);
        }
    }

    protected void copyEntityRelationships(Party from, Party to) {
        for (EntityRelationship relationship : from.getEntityRelationships()) {
            EntityRelationship copy = this.copyEntityRelationship(relationship, from, to);
            if (this.exists((PeriodRelationship)copy, to.getEntityRelationships())) continue;
            to.addEntityRelationship(copy);
        }
    }

    protected void copyEntityLinks(Party from, Party to) {
        for (EntityLink relationship : this.getEntityLinks(from)) {
            EntityLink copy = this.copyEntityLink(relationship, from, to);
            if (this.exists((PeriodRelationship)copy, to.getEntityLinks())) continue;
            to.addEntityLink(copy);
        }
    }

    protected Set<EntityLink> getEntityLinks(Party from) {
        return from.getEntityLinks();
    }

    protected EntityRelationship copyEntityRelationship(EntityRelationship relationship, Party from, Party to) {
        Reference fromRef = from.getObjectReference();
        Reference toRef = to.getObjectReference();
        List objects = this.relationshipCopier.apply((IMObject)relationship);
        EntityRelationship copy = (EntityRelationship)objects.get(0);
        if (Objects.equals(copy.getSource(), fromRef)) {
            copy.setSource(toRef);
        } else {
            copy.setTarget(toRef);
        }
        return copy;
    }

    protected EntityLink copyEntityLink(EntityLink relationship, Party from, Party to) {
        Reference fromRef = from.getObjectReference();
        Reference toRef = to.getObjectReference();
        List objects = this.relationshipCopier.apply((IMObject)relationship);
        EntityLink copy = (EntityLink)objects.get(0);
        if (Objects.equals(copy.getSource(), fromRef)) {
            copy.setSource(toRef);
        } else {
            copy.setTarget(toRef);
        }
        return copy;
    }

    protected void copyIdentities(Party from, Party to) {
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new DefaultIMObjectCopyHandler(), (ArchetypeService)this.service);
        for (EntityIdentity identity : from.getIdentities()) {
            List objects = copier.apply((IMObject)identity);
            EntityIdentity copy = (EntityIdentity)objects.get(0);
            to.addIdentity(copy);
        }
    }

    protected List<IMObject> moveParticipations(Party from, Party to) {
        Reference fromRef = from.getObjectReference();
        Reference toRef = to.getObjectReference();
        ArchetypeQuery query = new ArchetypeQuery("participation.*", true, false);
        query.add((IConstraint)new ObjectRefNodeConstraint("entity", fromRef));
        query.setMaxResults(-1);
        List participations = this.service.get((IArchetypeQuery)query).getResults();
        for (IMObject object : participations) {
            Participation participation = (Participation)object;
            participation.setEntity(toRef);
        }
        return participations;
    }

    protected void checkParty(Party party) {
        if (!TypeHelper.isA((IMObject)party, (String)this.type)) {
            throw new MergeException(MergeException.ErrorCode.InvalidType, DescriptorHelper.getDisplayName((IMObject)party, (ArchetypeService)this.service));
        }
    }

    protected String getDisplayName() {
        return DescriptorHelper.getDisplayName((String)this.type, (ArchetypeService)this.service);
    }

    protected IArchetypeService getArchetypeService() {
        return this.service;
    }

    protected boolean exists(PeriodRelationship relationship, Set<? extends PeriodRelationship> relationships) {
        boolean result = false;
        String archetype = relationship.getArchetype();
        for (PeriodRelationship periodRelationship : relationships) {
            if (!Objects.equals(periodRelationship.getSource(), relationship.getSource()) || !Objects.equals(periodRelationship.getTarget(), relationship.getTarget()) || !periodRelationship.getArchetype().equals(archetype) || periodRelationship.getActiveEndTime() != null || relationship.getActiveEndTime() != null) continue;
            result = true;
            break;
        }
        return result;
    }

    private Entity getRelated(Party from, Party to, Relationship relationship) {
        Reference source = relationship.getSource();
        if (from.getObjectReference().equals((Object)source)) {
            Reference target = relationship.getTarget();
            if (to.getObjectReference().equals((Object)target)) {
                return to;
            }
            return this.getEntity(target);
        }
        if (to.getObjectReference().equals((Object)source)) {
            return to;
        }
        return this.getEntity(source);
    }

    private Entity getEntity(Reference reference) {
        return reference != null ? (Entity)this.service.get(reference, Entity.class) : null;
    }
}

