/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.insurance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections4.IteratorUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Path;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class InsuranceRules {
    private final IArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private static final String CUSTOMER = "customer";
    private static final String PATIENT = "patient";
    private static final String INSURER = "insurer";
    private static final String INSURER_ID = "insurerId";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String STATUS = "status";
    private static final String CLAIMS = "claims";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String ITEMS = "items";
    private static final String ENTITY = "entity";

    public InsuranceRules(IArchetypeService service, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.transactionManager = transactionManager;
    }

    public Act createPolicy(Party customer, Party patient, Party insurer, String policyNumber) {
        Act policy = (Act)this.service.create("act.patientInsurancePolicy", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)policy);
        bean.setTarget(CUSTOMER, (IMObject)customer);
        bean.setTarget(PATIENT, (IMObject)patient);
        bean.setTarget(INSURER, (IMObject)insurer);
        if (policyNumber != null) {
            ActIdentity identity = (ActIdentity)this.service.create("actIdentity.insurancePolicy", ActIdentity.class);
            identity.setIdentity(policyNumber);
            policy.addIdentity(identity);
        }
        return policy;
    }

    public Act getPolicyForClaim(Party customer, Party patient, Party insurer, String policyNumber, FinancialAct existingClaim, Act existingPolicy) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        return (Act)template.execute(transactionStatus -> {
            Act result = this.getPolicy(customer, patient, insurer, policyNumber);
            if (result == null) {
                if (existingPolicy != null) {
                    result = this.tryReusePolicy(existingPolicy, customer, patient, insurer, policyNumber, existingClaim);
                }
                if (result == null) {
                    Act policy = this.getPolicy(customer, patient);
                    if (policy != null) {
                        result = this.tryReusePolicy(policy, insurer, policyNumber, existingClaim);
                    }
                    if (result == null) {
                        result = this.createPolicy(customer, patient, insurer, policyNumber);
                    }
                }
            }
            result.setActivityEndTime(null);
            return result;
        });
    }

    public Act getPolicy(Party customer, Party patient) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        return (Act)template.execute(transactionStatus -> {
            Act policy = this.getCurrentPolicy(customer, patient);
            if (policy == null) {
                policy = this.getMostRecentPolicy(customer, patient, false);
            }
            return policy;
        });
    }

    public Act getPolicy(Party customer, Party patient, Party insurer) {
        ArchetypeQuery query = this.createPolicyQuery(customer, patient, insurer);
        return this.query(query);
    }

    public Act getPolicy(Party customer, Party patient, Party insurer, String policyNumber) {
        ArchetypeQuery query = this.createPolicyQuery(customer, patient, insurer);
        query.add((IConstraint)Constraints.join((String)INSURER_ID).add((IConstraint)Constraints.eq((String)"identity", (Object)policyNumber)));
        return this.query(query);
    }

    public Act getCurrentPolicy(Party customer, Party patient) {
        Date now = new Date();
        ArchetypeQuery query = this.createPolicyQuery(customer, patient);
        query.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.lte((String)START_TIME, (Object)now), Constraints.or((IConstraint[])new IConstraint[]{Constraints.isNull((String)END_TIME), Constraints.gt((String)END_TIME, (Object)now)})}));
        return this.query(query);
    }

    public List<Act> getCurrentPolicies(Party customer, Party patient) {
        Date now = new Date();
        ArchetypeQuery query = this.createPolicyQuery(customer, patient);
        query.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.lte((String)START_TIME, (Object)now), Constraints.or((IConstraint[])new IConstraint[]{Constraints.isNull((String)END_TIME), Constraints.gt((String)END_TIME, (Object)now)})}));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return IteratorUtils.toList((Iterator)iterator);
    }

    public Act getMostRecentPolicy(Party customer, Party patient, boolean excludeFuturePolicies) {
        Date now = new Date();
        ArchetypeQuery query = this.createPolicyQuery(customer, patient);
        if (excludeFuturePolicies) {
            query.add((IConstraint)Constraints.lte((String)START_TIME, (Object)now));
        }
        return this.query(query);
    }

    public Party getInsurer(Act act) {
        Party insurer = null;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (bean.isA(new String[]{"act.patientInsurancePolicy"})) {
            insurer = (Party)bean.getTarget(INSURER, Party.class);
        } else {
            Act policy = (Act)bean.getTarget("policy", Act.class);
            if (policy != null) {
                insurer = this.getInsurer(policy);
            }
        }
        return insurer;
    }

    public FinancialAct createClaim(Act policy) {
        FinancialAct claim = (FinancialAct)this.service.create("act.patientInsuranceClaim", FinancialAct.class);
        if (claim == null) {
            throw new IllegalStateException("Failed to create act.patientInsuranceClaim");
        }
        IMObjectBean bean = this.service.getBean((IMObject)claim);
        bean.addTarget("policy", (IMObject)policy, CLAIMS);
        return claim;
    }

    public boolean canChangePolicyNumber(Act policy) {
        ArchetypeQuery query = new ArchetypeQuery(policy.getObjectReference());
        query.add((IConstraint)Constraints.join((String)CLAIMS).add((IConstraint)Constraints.join((String)SOURCE).add((IConstraint)Constraints.not((IConstraint)Constraints.in((String)STATUS, (Object[])new Object[]{"PENDING", "POSTED"})))));
        query.add((IConstraint)new NodeSelectConstraint("id"));
        query.setMaxResults(1);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return !iterator.hasNext();
    }

    public String getPolicyNumber(Act policy) {
        IMObjectBean bean = this.service.getBean((IMObject)policy);
        Identity insurerId = (Identity)bean.getObject(INSURER_ID, Identity.class);
        return insurerId != null ? insurerId.getIdentity() : null;
    }

    public boolean isClaimed(FinancialAct invoice) {
        return this.isClaimed(invoice, false);
    }

    public boolean isClaimed(FinancialAct invoice, boolean excludePending) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientInsuranceClaim");
        query.setMaxResults(1);
        query.setDistinct(true);
        if (excludePending) {
            query.add((IConstraint)Constraints.not((IConstraint)Constraints.in((String)STATUS, (Object[])new Object[]{"PENDING", "CANCELLING", "CANCELLED"})));
        } else {
            query.add((IConstraint)Constraints.ne((String)STATUS, (Object)"CANCELLED"));
            query.add((IConstraint)Constraints.ne((String)STATUS, (Object)"CANCELLING"));
        }
        query.add((IConstraint)Constraints.join((String)ITEMS, (String)"conditions").add((IConstraint)Constraints.join((String)TARGET, (String)"condition").add((IConstraint)Constraints.join((String)ITEMS, (String)"charges").add((IConstraint)Constraints.join((String)TARGET, (String)"item").add((IConstraint)Constraints.join((String)"invoice").add((IConstraint)Constraints.eq((String)SOURCE, (Object)invoice)))))));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext();
    }

    public List<FinancialAct> getCurrentClaims(FinancialAct invoice) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientInsuranceClaim");
        query.setMaxResults(-1);
        query.setDistinct(true);
        query.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.ne((String)STATUS, (Object)"CANCELLED"), Constraints.ne((String)STATUS, (Object)"SETTLED"), Constraints.ne((String)STATUS, (Object)"DECLINED")}));
        query.add((IConstraint)Constraints.join((String)ITEMS, (String)"conditions").add((IConstraint)Constraints.join((String)TARGET, (String)"condition").add((IConstraint)Constraints.join((String)ITEMS, (String)"charges").add((IConstraint)Constraints.join((String)TARGET, (String)"item").add((IConstraint)Constraints.join((String)"invoice").add((IConstraint)Constraints.eq((String)SOURCE, (Object)invoice)))))));
        List result = this.service.get((IArchetypeQuery)query).getResults();
        return result;
    }

    public List<FinancialAct> getCurrentGapClaims(FinancialAct invoice) {
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        for (FinancialAct claim : this.getCurrentClaims(invoice)) {
            if (!this.isUnpaidGapClaim(claim)) continue;
            result.add(claim);
        }
        return result;
    }

    public boolean hasCurrentGapClaims(FinancialAct invoice) {
        boolean result = false;
        for (FinancialAct claim : this.getCurrentClaims(invoice)) {
            if (!this.isUnpaidGapClaim(claim)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasBenefitAmount(FinancialAct claim) {
        return claim.getStatus2() != null && !"PENDING".equals(claim.getStatus2()) && this.service.getBean((IMObject)claim).getBigDecimal("benefitAmount") != null;
    }

    public BigDecimal getGapAmount(FinancialAct claim) {
        IMObjectBean bean = this.service.getBean((IMObject)claim);
        BigDecimal total = bean.getBigDecimal("amount", BigDecimal.ZERO);
        BigDecimal benefit = bean.getBigDecimal("benefitAmount", BigDecimal.ZERO);
        return this.getGapAmount(total, benefit);
    }

    public BigDecimal getGapAmount(BigDecimal total, BigDecimal benefit) {
        return benefit.compareTo(total) <= 0 ? total.subtract(benefit) : BigDecimal.ZERO;
    }

    public Date getPriorTreatmentDate(Party patient, Party insurer, Act claim, Date treatmentDate) {
        Date result = null;
        Entity insuranceService = (Entity)this.service.getBean((IMObject)insurer).getTarget("service", Entity.class, Policies.active());
        if (insuranceService != null) {
            result = this.getPriorTreatmentDate(patient, treatmentDate, claim, insuranceService);
        }
        return result;
    }

    protected boolean isPaid(FinancialAct claim) {
        String status = claim.getStatus2();
        return "PAID".equals(status) || "NOTIFIED".equals(status);
    }

    protected ArchetypeQuery createPolicyQuery(Party customer, Party patient, Party insurer) {
        ArchetypeQuery query = this.createPolicyQuery(customer, patient);
        query.add((IConstraint)Constraints.join((String)INSURER).add((IConstraint)Constraints.eq((String)ENTITY, (Object)insurer)).add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientInsurancePolicy")));
        return query;
    }

    private Act tryReusePolicy(Act policy, Party customer, Party patient, Party insurer, String policyNumber, FinancialAct existingClaim) {
        Act result = null;
        IMObjectBean bean = this.service.getBean((IMObject)policy);
        if (this.canReusePolicy(bean, existingClaim, customer, patient)) {
            this.setPolicyNumber(policy, policyNumber, bean);
            bean.setTarget(INSURER, (IMObject)insurer);
            result = policy;
        }
        return result;
    }

    private Act tryReusePolicy(Act policy, Party insurer, String policyNumber, FinancialAct existingClaim) {
        Act result = null;
        IMObjectBean bean = this.service.getBean((IMObject)policy);
        if (!this.hasClaims(bean, (Act)existingClaim)) {
            this.setPolicyNumber(policy, policyNumber, bean);
            bean.setTarget(INSURER, (IMObject)insurer);
            result = policy;
        }
        return result;
    }

    private boolean canReusePolicy(IMObjectBean bean, FinancialAct claim, Party customer, Party patient) {
        return bean.getTargetRef(PATIENT).equals((Object)patient.getObjectReference()) && bean.getTargetRef(CUSTOMER).equals((Object)customer.getObjectReference()) && !this.hasClaims(bean, (Act)claim);
    }

    private boolean isUnpaidGapClaim(FinancialAct claim) {
        IMObjectBean bean = this.service.getBean((IMObject)claim);
        return bean.getBoolean("gapClaim") && !this.isPaid(claim);
    }

    private boolean hasClaims(IMObjectBean bean, Act claim) {
        Reference source;
        Predicate<Relationship> predicate;
        boolean result = claim == null ? !bean.getValues(CLAIMS).isEmpty() : bean.getValue(CLAIMS, Relationship.class, predicate = arg_0 -> InsuranceRules.lambda$hasClaims$2(source = claim.getObjectReference(), arg_0)) != null;
        return result;
    }

    private void setPolicyNumber(Act policy, String policyNumber, IMObjectBean bean) {
        ActIdentity identity = (ActIdentity)bean.getObject(INSURER_ID, ActIdentity.class);
        if (policyNumber != null) {
            if (identity == null) {
                identity = (ActIdentity)this.service.create("actIdentity.insurancePolicy", ActIdentity.class);
                policy.addIdentity(identity);
            }
            identity.setIdentity(policyNumber);
        } else if (identity != null) {
            policy.removeIdentity(identity);
        }
    }

    private Date getPriorTreatmentDate(Party patient, Date treatmentDate, Act claim, Entity insuranceService) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Date.class);
        Root from = query.from(Act.class, new String[]{"act.patientInsuranceClaim"});
        Join condition = from.join(ITEMS).join(TARGET);
        Path endTreatmentDate = condition.get(END_TIME);
        condition.on((Expression)builder.lessThanOrEqualTo((Expression)endTreatmentDate, (Comparable)treatmentDate));
        query.select((Selection)endTreatmentDate);
        Join withPatient = from.join(PATIENT).join(ENTITY);
        withPatient.on((Expression)builder.equal((Expression)withPatient.reference(), (Object)patient.getObjectReference()));
        Join withService = from.join("policy").join(TARGET).join(INSURER).join(ENTITY).join("service").join(TARGET);
        withService.on((Expression)builder.equal((Expression)withService.reference(), (Object)insuranceService.getObjectReference()));
        ArrayList<javax.persistence.criteria.Predicate> where = new ArrayList<javax.persistence.criteria.Predicate>();
        where.add(from.get(STATUS).in(new Object[]{"SUBMITTED", "ACCEPTED", "PRE_SETTLED", "SETTLED", "DECLINED"}));
        where.add(builder.notEqual((Expression)from.get("id"), (Object)claim.getId()));
        query.where(where);
        query.orderBy(new Order[]{builder.desc((Expression)endTreatmentDate), builder.desc((Expression)from.get("id"))});
        return (Date)this.service.createQuery(query).getFirstResult();
    }

    private Act query(ArchetypeQuery query) {
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (Act)iterator.next() : null;
    }

    private ArchetypeQuery createPolicyQuery(Party customer, Party patient) {
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"act", (String)"act.patientInsurancePolicy"));
        query.setMaxResults(1);
        query.add((IConstraint)Constraints.join((String)CUSTOMER).add((IConstraint)Constraints.eq((String)ENTITY, (Object)customer)).add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientInsurancePolicy")));
        query.add((IConstraint)Constraints.join((String)PATIENT).add((IConstraint)Constraints.eq((String)ENTITY, (Object)patient)).add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientInsurancePolicy")));
        query.add((IConstraint)Constraints.sort((String)START_TIME, (boolean)false));
        query.add((IConstraint)Constraints.sort((String)"id", (boolean)false));
        return query;
    }

    private static /* synthetic */ boolean lambda$hasClaims$2(Reference source, Relationship relationship) {
        return !Objects.equals(source, relationship.getSource());
    }
}

