/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.tax;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TaxRules {
    private final ArchetypeService service;
    private final Collection<Lookup> practiceTaxRates;
    private static final String TAXES = "taxes";

    public TaxRules(Party practice, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)practice);
        this.practiceTaxRates = Collections.unmodifiableList(bean.getValues(TAXES, Lookup.class));
        this.service = service;
    }

    public BigDecimal getTaxRate(Product product) {
        Collection<Lookup> rates = this.getProductTaxRates(product);
        return this.getTaxRate(rates);
    }

    public BigDecimal calculateTax(BigDecimal amount, Product product, boolean inclusive) {
        return this.calculateTax(amount, this.getProductTaxRates(product), inclusive);
    }

    public BigDecimal calculateTax(BigDecimal amount, Collection<Lookup> taxRates, boolean inclusive) {
        BigDecimal rate = this.getTaxRate(taxRates);
        BigDecimal tax = amount.multiply(rate);
        BigDecimal divisor = BigDecimal.valueOf(100L);
        if (inclusive) {
            divisor = divisor.add(rate);
        }
        tax = MathRules.divide(tax, divisor, 3);
        return tax;
    }

    public Collection<Lookup> getProductTaxRates(Product product) {
        Entity productType;
        IMObjectBean bean = this.service.getBean((IMObject)product);
        Collection<Lookup> taxes = new HashSet<Lookup>(bean.getValues(TAXES, Lookup.class));
        if (taxes.isEmpty() && (productType = (Entity)bean.getTarget("type", Entity.class)) != null) {
            taxes.addAll(this.getProductTypeTaxRates(productType));
        }
        if (taxes.isEmpty()) {
            taxes = this.getPracticeTaxRates();
        }
        return taxes;
    }

    protected BigDecimal getTaxRate(Collection<Lookup> taxRates) {
        BigDecimal result = BigDecimal.ZERO;
        for (IMObject iMObject : taxRates) {
            IMObjectBean taxBean = this.service.getBean(iMObject);
            BigDecimal rate = taxBean.getBigDecimal("rate", BigDecimal.ZERO);
            result = result.add(rate);
        }
        return result;
    }

    protected Collection<Lookup> getPracticeTaxRates() {
        return this.practiceTaxRates;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    private Collection<Lookup> getProductTypeTaxRates(Entity productType) {
        IMObjectBean bean = this.service.getBean((IMObject)productType);
        return bean.getValues(TAXES, Lookup.class);
    }
}

