/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.IterableIMObjectQuery;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.RelationalOp;

class StatementActHelper {
    private final IArchetypeService service;
    private static final String[] SHORT_NAMES;
    private static final String[] CHARGE_SHORT_NAMES;
    private static final String START_TIME = "startTime";
    private static final String ACT_START_TIME = "act.startTime";
    private static final String STATUS = "status";

    public StatementActHelper(IArchetypeService service) {
        this.service = service;
    }

    public Date getStatementTimestamp(Date statementDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(statementDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public boolean hasStatement(Party customer, Date date) {
        ActState state = this.getClosingBalanceAfter(customer, date);
        return state != null;
    }

    public FinancialAct getClosingBalance(Party customer, Date statementDate) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, new String[]{"act.customerAccountClosingBalance"});
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(statementDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        query.add((IConstraint)new NodeConstraint(ACT_START_TIME, RelationalOp.GTE, new Object[]{calendar.getTime()}));
        calendar.add(5, 1);
        query.add((IConstraint)new NodeConstraint(ACT_START_TIME, RelationalOp.LT, new Object[]{calendar.getTime()}));
        query.setMaxResults(1);
        IMObjectQueryIterator iter = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iter.hasNext() ? (FinancialAct)iter.next() : null;
    }

    public Iterable<Act> getActs(Party customer, Date statementDate) {
        Date open = this.getOpeningBalanceTimestamp(customer, statementDate);
        Date close = this.getClosingBalanceTimestamp(customer, statementDate, open);
        ArchetypeQuery query = this.createQuery(customer, open, close, true, null);
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    public Iterable<FinancialAct> getPostedActs(Party customer, Date openingBalanceTimestamp, Date closingBalanceTimestamp, boolean includeClosingBalance) {
        ArchetypeQuery query = this.createQuery(customer, openingBalanceTimestamp, closingBalanceTimestamp, includeClosingBalance, "POSTED");
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    public Iterable<Act> getCompletedCharges(Party customer, Date statementDate, Date openingBalanceTimestamp, Date closingBalanceTimestamp) {
        if (closingBalanceTimestamp == null) {
            closingBalanceTimestamp = this.getStatementTimestamp(statementDate);
        }
        ArchetypeQuery query = this.createQuery(customer, CHARGE_SHORT_NAMES, openingBalanceTimestamp, false, closingBalanceTimestamp, false, "COMPLETED");
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    public Iterable<FinancialAct> getPostedAndCompletedActs(Party customer, Date statementDate, Date openingBalanceTimestamp) {
        Date close = this.getStatementTimestamp(statementDate);
        ArchetypeQuery query = this.createQuery(customer, openingBalanceTimestamp, close, false, null);
        query.add((IConstraint)new OrConstraint().add((IConstraint)new NodeConstraint(STATUS, (Object)"POSTED")).add((IConstraint)new NodeConstraint(STATUS, (Object)"COMPLETED")));
        return new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
    }

    public Date getOpeningBalanceTimestamp(Party customer, Date statementDate) {
        ActState state = this.getOpeningBalanceState(customer, statementDate);
        return state != null ? state.getStartTime() : null;
    }

    public Date getClosingBalanceTimestamp(Party customer, Date statementDate, Date openingBalanceTimestamp) {
        ActState state = this.getClosingBalanceState(customer, statementDate, openingBalanceTimestamp);
        return state != null ? state.getStartTime() : null;
    }

    public ActState getOpeningBalanceState(Party customer, Date statementDate) {
        return this.getActState("act.customerAccountOpeningBalance", customer, statementDate, RelationalOp.LT, false);
    }

    public ActState getClosingBalanceState(Party customer, Date statementDate, Date openingBalanceTimestamp) {
        ActState result;
        if (openingBalanceTimestamp == null) {
            result = this.getClosingBalanceBefore(customer, statementDate);
            if (result == null) {
                result = this.getClosingBalanceAfter(customer, statementDate);
            }
        } else {
            result = this.getClosingBalanceAfter(customer, openingBalanceTimestamp);
        }
        return result;
    }

    public boolean hasAccountActivity(Party customer, Date openingBalanceTimestamp, Date closingBalanceTimestamp) {
        ArchetypeQuery query = this.createQuery(customer, SHORT_NAMES, openingBalanceTimestamp, false, closingBalanceTimestamp, false, null);
        query.add((IConstraint)new NodeSelectConstraint(ACT_START_TIME));
        query.setMaxResults(1);
        ObjectSetQueryIterator iter = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return iter.hasNext();
    }

    public ActState getActState(String shortName, Party customer, Date date, RelationalOp operator, boolean sortAscending) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, new String[]{shortName});
        if (date != null) {
            query.add((IConstraint)new NodeConstraint(ACT_START_TIME, operator, new Object[]{date}));
        }
        query.add((IConstraint)new NodeSelectConstraint(ACT_START_TIME));
        query.add((IConstraint)new NodeSelectConstraint("act.amount"));
        query.add((IConstraint)new NodeSelectConstraint("act.credit"));
        query.add((IConstraint)new NodeSelectConstraint("act.printed"));
        query.add((IConstraint)new NodeSortConstraint(START_TIME, sortAscending));
        query.setMaxResults(1);
        ObjectSetQueryIterator iter = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        if (iter.hasNext()) {
            ObjectSet set = (ObjectSet)iter.next();
            Date startTime = (Date)set.get(ACT_START_TIME);
            BigDecimal amount = (BigDecimal)set.get("act.amount");
            boolean credit = (Boolean)set.get("act.credit");
            boolean printed = (Boolean)set.get("act.printed");
            if (credit) {
                amount = amount.negate();
            }
            return new ActState(startTime, amount, printed);
        }
        return null;
    }

    private ActState getClosingBalanceBefore(Party customer, Date timestamp) {
        return this.getActState("act.customerAccountClosingBalance", customer, timestamp, RelationalOp.LT, false);
    }

    private ActState getClosingBalanceAfter(Party customer, Date timetamp) {
        return this.getActState("act.customerAccountClosingBalance", customer, timetamp, RelationalOp.GT, true);
    }

    private ArchetypeQuery createQuery(Party customer, Date openingBalanceTimestamp, Date closingBalanceTimestamp, boolean includeClosingBalance, String status) {
        return this.createQuery(customer, SHORT_NAMES, openingBalanceTimestamp, true, closingBalanceTimestamp, includeClosingBalance, status);
    }

    private ArchetypeQuery createQuery(Party customer, String[] shortNames, Date openingBalanceTimestamp, boolean includeOpeningBalance, Date closingBalanceTimestamp, boolean includeClosingBalance, String status) {
        RelationalOp op;
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, shortNames);
        if (openingBalanceTimestamp != null) {
            op = includeOpeningBalance ? RelationalOp.GTE : RelationalOp.GT;
            query.add((IConstraint)new NodeConstraint(START_TIME, op, new Object[]{openingBalanceTimestamp}));
        }
        if (closingBalanceTimestamp != null) {
            op = includeClosingBalance ? RelationalOp.LTE : RelationalOp.LT;
            query.add((IConstraint)new NodeConstraint(START_TIME, op, new Object[]{closingBalanceTimestamp}));
        }
        if (status != null) {
            query.add((IConstraint)Constraints.eq((String)STATUS, (Object)status));
        }
        query.add((IConstraint)Constraints.sort((String)START_TIME));
        query.add((IConstraint)Constraints.sort((String)"id"));
        return query;
    }

    static {
        CHARGE_SHORT_NAMES = new String[]{"act.customerAccountChargesInvoice", "act.customerAccountChargesCounter", "act.customerAccountChargesCredit"};
        ArrayList<String> shortNames = new ArrayList<String>(CustomerAccountArchetypes.DEBITS_CREDITS);
        shortNames.add("act.customerAccountOpeningBalance");
        shortNames.add("act.customerAccountClosingBalance");
        SHORT_NAMES = shortNames.toArray(new String[0]);
    }

    public static class ActState {
        private final Date startTime;
        private final BigDecimal amount;
        private final boolean printed;

        public ActState(Date startTime, BigDecimal amount, boolean printed) {
            this.startTime = startTime;
            this.amount = amount;
            this.printed = printed;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public boolean isPrinted() {
            return this.printed;
        }
    }
}

