/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import org.openvpms.component.model.act.FinancialAct;

public class PostStatus {
    private final Status status;
    private final FinancialAct item;
    private final FinancialAct transaction;

    private PostStatus(Status status) {
        this(status, null, null);
    }

    private PostStatus(Status status, FinancialAct item, FinancialAct transaction) {
        this.status = status;
        this.item = item;
        this.transaction = transaction;
    }

    public boolean canPost() {
        return this.status == Status.CAN_POST;
    }

    public boolean hasOutstandingEFTPOSTransaction() {
        return this.status == Status.OUTSTANDING_EFTPOS_TRANSACTION;
    }

    public boolean hasUnsubmittedPaymentProcessorTransaction() {
        return this.status == Status.UNSUBMITTED_PAYMENT_PROCESSOR_TRANSACTION;
    }

    public boolean hasOutstandingPaymentProcessorTransaction() {
        return this.status == Status.OUTSTANDING_PAYMENT_PROCESSOR_TRANSACTION;
    }

    public FinancialAct getItem() {
        return this.item;
    }

    public FinancialAct getTransaction() {
        return this.transaction;
    }

    public static PostStatus postingAllowed() {
        return new PostStatus(Status.CAN_POST);
    }

    public static PostStatus unsupported() {
        return new PostStatus(Status.UNSUPPORTED);
    }

    public static PostStatus posted() {
        return new PostStatus(Status.POSTED);
    }

    public static PostStatus outstandingEFTPOSTransaction(FinancialAct item, FinancialAct transaction) {
        return new PostStatus(Status.OUTSTANDING_EFTPOS_TRANSACTION, item, transaction);
    }

    public static PostStatus unsubmittedPaymentProcessorTransaction(FinancialAct item, FinancialAct transaction) {
        return new PostStatus(Status.UNSUBMITTED_PAYMENT_PROCESSOR_TRANSACTION, item, transaction);
    }

    public static PostStatus outstandingPaymentProcessorTransaction(FinancialAct item, FinancialAct transaction) {
        return new PostStatus(Status.OUTSTANDING_PAYMENT_PROCESSOR_TRANSACTION, item, transaction);
    }

    private static enum Status {
        UNSUPPORTED,
        POSTED,
        CAN_POST,
        OUTSTANDING_EFTPOS_TRANSACTION,
        UNSUBMITTED_PAYMENT_PROCESSOR_TRANSACTION,
        OUTSTANDING_PAYMENT_PROCESSOR_TRANSACTION;

    }
}

