/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.util.Arrays;
import java.util.List;
import org.openvpms.archetype.rules.act.ActCopyHandler;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

class CustomerActReversalHandler
extends ActCopyHandler {
    private final boolean supportPaymentProcessor;
    static final String[][] TYPE_MAP = new String[][]{{"act.customerAccountChargesInvoice", "act.customerAccountChargesCredit"}, {"act.customerAccountInvoiceItem", "act.customerAccountCreditItem"}, {"actRelationship.customerAccountInvoiceItem", "actRelationship.customerAccountCreditItem"}, {"act.customerAccountChargesCounter", "act.customerAccountChargesCredit"}, {"act.customerAccountCounterItem", "act.customerAccountCreditItem"}, {"actRelationship.customerAccountCounterItem", "actRelationship.customerAccountCreditItem"}, {"act.customerAccountPayment", "act.customerAccountRefund"}, {"actRelationship.customerAccountPaymentItem", "actRelationship.customerAccountRefundItem"}, {"act.customerAccountPaymentCash", "act.customerAccountRefundCash"}, {"act.customerAccountPaymentCheque", "act.customerAccountRefundCheque"}, {"act.customerAccountPaymentCredit", "act.customerAccountRefundCredit"}, {"act.customerAccountPaymentDiscount", "act.customerAccountRefundDiscount"}, {"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT"}, {"act.customerAccountPaymentOther", "act.customerAccountRefundOther"}, {"act.customerAccountPaymentPP", "act.customerAccountRefundPP"}, {"act.customerAccountDebitAdjust", "act.customerAccountCreditAdjust"}, {"act.customerAccountDebitAdjust", "act.customerAccountBadDebt"}, {"act.customerAccountInitialBalance", "act.customerAccountCreditAdjust"}};
    private final List<String> UNCOPYABLE = Arrays.asList("credit", "allocatedAmount", "accountBalance", "allocation", "reversals", "reverses", "estimates", "hide", "tillBalance", "audit", "transaction", "transactions", "reversal");

    CustomerActReversalHandler(Act act) {
        this(act, false);
    }

    CustomerActReversalHandler(Act act, boolean supportPaymentProcessor) {
        super(TYPE_MAP);
        this.setReverse(act.isA(new String[]{"act.customerAccountChargesCredit", "act.customerAccountRefund", "act.customerAccountCreditAdjust", "act.customerAccountBadDebt"}));
        this.supportPaymentProcessor = supportPaymentProcessor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IMObject getObject(IMObject object, ArchetypeService service) {
        IMObject result = super.getObject(object, service);
        if (object.isA("act.customerAccountRefundCash") && result.isA("act.customerAccountPaymentCash")) {
            IMObjectBean refund = service.getBean(object);
            IMObjectBean payment = service.getBean(result);
            payment.setValue("tendered", (Object)refund.getBigDecimal("roundedAmount"));
            return result;
        } else if (object.isA("act.customerAccountPaymentPP")) {
            if (!this.supportPaymentProcessor) {
                throw new IllegalStateException("Cannot reverse " + object.getArchetype());
            }
            if (!result.isA("act.customerAccountRefundPP")) throw new IllegalStateException("Invalid reversal " + result.getArchetype());
            IMObjectBean payment = service.getBean(object);
            payment.addTarget("reversal", result, "reverses");
            return result;
        } else {
            if (!object.isA("act.customerAccountRefundPP")) return result;
            throw new IllegalStateException("Cannot reverse " + object.getArchetype());
        }
    }

    @Override
    protected boolean isCopyable(ArchetypeDescriptor archetype, NodeDescriptor node, boolean source) {
        String name = node.getName();
        if (this.UNCOPYABLE.contains(name)) {
            return false;
        }
        return super.isCopyable(archetype, node, source);
    }
}

