/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.lang3.StringUtils;

public class PrinterReference
implements Comparable<PrinterReference> {
    private final String archetype;
    private final String serviceName;
    private final String id;
    private final String name;
    private static final String ESCAPE = Pattern.quote("\\");
    private static final String SEPARATOR = "(?<!" + ESCAPE + "):";

    public PrinterReference(String archetype, String id) {
        this(archetype, null, id, null);
    }

    public PrinterReference(String archetype, String serviceName, String id, String name) {
        this.archetype = archetype;
        this.serviceName = serviceName;
        this.id = id;
        this.name = name;
    }

    public String getArchetype() {
        return this.archetype;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name != null ? this.name : this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PrinterReference) {
            PrinterReference other = (PrinterReference)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.archetype, other.archetype);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.archetype);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.archetype != null) {
            result.append(this.escape(this.archetype));
        }
        result.append(':');
        if (this.serviceName != null) {
            result.append(this.escape(this.serviceName));
        }
        result.append(':');
        result.append(this.escape(this.id));
        result.append(':');
        if (this.name != null) {
            result.append(this.escape(this.name));
        }
        return result.toString();
    }

    @Override
    public int compareTo(PrinterReference obj) {
        int result;
        if (this == obj) {
            result = 0;
        } else {
            Comparator comparator = ComparatorUtils.nullLowComparator(null);
            result = comparator.compare(this.serviceName, obj.serviceName);
            if (result == 0 && (result = comparator.compare(this.archetype, obj.archetype)) == 0 && (result = comparator.compare(this.name, obj.name)) == 0) {
                result = comparator.compare(this.id, obj.id);
            }
        }
        return result;
    }

    public static PrinterReference fromString(String reference) {
        PrinterReference result = null;
        if (reference != null) {
            String[] parts = reference.split(SEPARATOR);
            String id = null;
            String archetype = null;
            String serviceName = null;
            String printerName = null;
            if (parts.length == 1) {
                id = PrinterReference.unescape(parts[0]);
            } else if (parts.length == 2) {
                archetype = PrinterReference.unescape(parts[0]);
                id = PrinterReference.unescape(parts[1]);
            } else if (parts.length == 3) {
                archetype = PrinterReference.unescape(parts[0]);
                serviceName = PrinterReference.unescape(parts[1]);
                id = PrinterReference.unescape(parts[2]);
            } else if (parts.length == 4) {
                archetype = PrinterReference.unescape(parts[0]);
                serviceName = PrinterReference.unescape(parts[1]);
                id = PrinterReference.unescape(parts[2]);
                printerName = PrinterReference.unescape(parts[3]);
            }
            if (id != null) {
                result = new PrinterReference(archetype, serviceName, id, printerName);
            }
        }
        return result;
    }

    private String escape(String value) {
        return value != null ? value.replace(":", "\\:") : null;
    }

    private static String unescape(String value) {
        return (value = StringUtils.trimToNull((String)value)) != null ? value.replaceAll(ESCAPE + ":", ":") : null;
    }
}

