/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class BaseDocumentTemplate {
    private final IMObjectBean bean;
    private final ArchetypeService service;
    private DocumentAct act;

    public BaseDocumentTemplate(Entity template, ArchetypeService service) {
        this.bean = service.getBean((IMObject)template);
        this.service = service;
    }

    public String getName() {
        return this.getEntity().getName();
    }

    public String getDescription() {
        return this.getEntity().getDescription();
    }

    public boolean isActive() {
        return this.getEntity().isActive();
    }

    public boolean hasDocument() {
        DocumentAct act = this.getDocumentAct();
        return act != null && act.getDocument() != null;
    }

    public String getFileName() {
        DocumentAct act = this.getDocumentAct();
        return act != null ? act.getFileName() : null;
    }

    public String getMimeType() {
        DocumentAct act = this.getDocumentAct();
        return act != null ? act.getMimeType() : null;
    }

    public String getDocumentName() {
        DocumentAct act = this.getDocumentAct();
        return act != null ? act.getName() : null;
    }

    public Document getDocument() {
        DocumentAct act = this.getDocumentAct();
        return act != null && act.getDocument() != null ? (Document)this.service.get(act.getDocument(), Document.class) : null;
    }

    public DocumentAct getDocumentAct() {
        if (this.act == null) {
            this.act = new TemplateHelper(this.service).getDocumentAct(this.getEntity());
        }
        return this.act;
    }

    public Entity getEntity() {
        return (Entity)this.bean.getObject(Entity.class);
    }

    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BaseDocumentTemplate && ((BaseDocumentTemplate)obj).getEntity().equals(this.getEntity());
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected IMObjectBean getBean() {
        return this.bean;
    }
}

