/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.contact;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.contact.AbstractAddressFormatter;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PracticeAddressFormatter
extends AbstractAddressFormatter {
    private final PracticeService practiceService;
    private static final Logger log = LoggerFactory.getLogger(PracticeAddressFormatter.class);

    public PracticeAddressFormatter(PracticeService practiceService, IArchetypeService service, LookupService lookups) {
        super((ArchetypeService)service, lookups);
        this.practiceService = practiceService;
    }

    @Override
    public String format(Contact location, boolean singleLine) {
        String result = null;
        try {
            result = super.format(location, singleLine);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return result;
    }

    @Override
    protected String format(Contact location, String address, String suburb, String stateCode, String stateName, String postcode, boolean singleLine) {
        String result = null;
        String format = this.getFormat(singleLine);
        if (format != null) {
            JXPathContext context = JXPathHelper.newContext((Object)location);
            Variables variables = context.getVariables();
            variables.declareVariable("address", (Object)StringUtils.trimToEmpty((String)address));
            variables.declareVariable("suburb", (Object)StringUtils.trimToEmpty((String)suburb));
            variables.declareVariable("state.code", (Object)StringUtils.trimToEmpty((String)stateCode));
            variables.declareVariable("state", (Object)StringUtils.trimToEmpty((String)stateName));
            variables.declareVariable("postcode", (Object)StringUtils.trimToEmpty((String)postcode));
            variables.declareVariable("nl", (Object)"\n");
            Object value = context.getValue(format);
            String string = result = value != null ? value.toString() : null;
            if (result != null && singleLine) {
                result = result.replace('\n', ' ');
            }
        }
        if (result == null) {
            result = this.formatDefault(address, suburb, stateName, postcode, singleLine);
        }
        return result;
    }

    private String getFormat(boolean singleLine) {
        Lookup lookup;
        String result = null;
        Party practice = this.practiceService.getPractice();
        if (practice != null && (lookup = this.getLookups().getLookup((IMObject)practice, "addressFormat")) != null) {
            IMObjectBean bean = this.getService().getBean((IMObject)lookup);
            result = singleLine ? bean.getString("singleLineFormat") : bean.getString("multiLineFormat");
        }
        return result;
    }
}

