/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.act;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ActStatusHelper {
    private ActStatusHelper() {
    }

    public static boolean isPosted(Act act, ArchetypeService service) {
        return !act.isNew() && ActStatusHelper.isPosted(act.getObjectReference(), service);
    }

    public static boolean isPosted(Reference reference, ArchetypeService service) {
        String status = ActStatusHelper.getStatus(reference, service);
        return "POSTED".equals(status);
    }

    public static String getStatus(Reference reference, ArchetypeService service) {
        String result = null;
        if (reference != null) {
            CriteriaBuilder builder = service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(String.class);
            Root from = query.from(Act.class, new String[]{reference.getArchetype()});
            query.where((Expression)builder.equal((Expression)from.get("id"), (Object)reference.getId()));
            query.select((Selection)from.get("status"));
            result = (String)service.createQuery(query).getFirstResult();
        }
        return result;
    }
}

