/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.i18n.time;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.i18n.time.DateDurationFormatter;
import org.openvpms.archetype.i18n.time.DurationFormatter;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;

public class CompositeDurationFormatter
implements DurationFormatter {
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private DurationFormatter defaultFormatter = DateDurationFormatter.YEAR;

    public void setDefaultFormatter(DurationFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("Argument 'formatter' is null");
        }
        this.defaultFormatter = formatter;
    }

    public void add(int interval, DateUnits units, DurationFormatter formatter) {
        this.formatters.add(new Formatter(interval, units, formatter));
    }

    @Override
    public String format(Date from, Date to) {
        DurationFormatter formatter = null;
        ArrayList<Formatter> l = new ArrayList<Formatter>(this.formatters);
        l.sort(Comparator.comparing(o -> o.getTo(from)));
        for (Formatter f : l) {
            formatter = f.durationFormatter;
            if (f.getTo(from).compareTo(to) < 0) continue;
            break;
        }
        if (formatter == null) {
            formatter = this.defaultFormatter;
        }
        return formatter.format(from, to);
    }

    private static class Formatter {
        private final int interval;
        private final DateUnits units;
        private final DurationFormatter durationFormatter;

        public Formatter(int interval, DateUnits units, DurationFormatter durationFormatter) {
            this.interval = interval;
            this.units = units;
            this.durationFormatter = durationFormatter;
        }

        public Date getTo(Date from) {
            return DateRules.getDate(from, this.interval, this.units);
        }
    }
}

