/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.history;

import java.util.Collections;
import java.util.Date;
import org.apache.commons.jxpath.Function;
import org.openvpms.archetype.rules.patient.PatientHistory;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;

public class HistoryFunctions
extends AbstractObjectFunctions {
    private final PatientHistory history;

    public HistoryFunctions(IArchetypeService service) {
        super("history");
        this.setObject((Object)this);
        this.history = new PatientHistory(service);
    }

    public Function getFunction(String namespace, String name, Object[] parameters) {
        if ("medication".equals(name) && parameters != null && parameters.length >= 2 && parameters[1] instanceof String) {
            name = "medicationByProductType";
        } else if ("charges".equals(name) && parameters != null && parameters.length >= 2 && parameters[1] instanceof String) {
            name = "chargesByProductType";
        }
        return super.getFunction(namespace, name, parameters);
    }

    public Iterable<Act> charges(Party patient) {
        return patient != null ? this.history.getCharges(patient) : Collections.emptyList();
    }

    public Iterable<Act> charges(Party patient, Date date) {
        if (patient != null && date != null) {
            Date from = DateRules.getDate(date);
            Date to = DateRules.getDate(from, 1, DateUnits.DAYS);
            return this.history.getCharges(patient, from, to);
        }
        return Collections.emptyList();
    }

    public Iterable<Act> charges(Party patient, Date from, Date to) {
        return patient != null ? this.history.getCharges(patient, from, to) : Collections.emptyList();
    }

    public Iterable<Act> chargesByProductType(Party patient, String productTypeName) {
        return patient != null ? this.history.getCharges(patient, productTypeName) : Collections.emptyList();
    }

    public Iterable<Act> chargesByProductType(Party patient, String productTypeName, Date date) {
        if (patient != null && date != null) {
            Date from = DateRules.getDate(date);
            Date to = DateRules.getDate(from, 1, DateUnits.DAYS);
            return this.history.getCharges(patient, productTypeName, from, to);
        }
        return Collections.emptyList();
    }

    public Iterable<Act> chargesByProductType(Party patient, String productTypeName, Date from, Date to) {
        return patient != null ? this.history.getCharges(patient, productTypeName, from, to) : Collections.emptyList();
    }

    public Iterable<Act> medication(Party patient) {
        return patient != null ? this.history.getMedication(patient) : Collections.emptyList();
    }

    public Iterable<Act> medication(Party patient, Date date) {
        if (patient != null && date != null) {
            Date from = DateRules.getDate(date);
            Date to = DateRules.getDate(from, 1, DateUnits.DAYS);
            return this.history.getMedication(patient, from, to);
        }
        return Collections.emptyList();
    }

    public Iterable<Act> medication(Party patient, Date from, Date to) {
        return patient != null ? this.history.getMedication(patient, from, to) : Collections.emptyList();
    }

    public Iterable<Act> medicationByProductType(Party patient, String productTypeName) {
        return patient != null ? this.history.getMedication(patient, productTypeName) : Collections.emptyList();
    }

    public Iterable<Act> medicationByProductType(Party patient, String productTypeName, Date date) {
        if (patient != null && date != null) {
            Date from = DateRules.getDate(date);
            Date to = DateRules.getDate(from, 1, DateUnits.DAYS);
            return this.history.getMedication(patient, productTypeName, from, to);
        }
        return Collections.emptyList();
    }

    public Iterable<Act> medicationByProductType(Party patient, String productTypeName, Date from, Date to) {
        return patient != null ? this.history.getMedication(patient, productTypeName, from, to) : Collections.emptyList();
    }
}

