/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.date;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.openvpms.archetype.function.date.RelativeDateParser;
import org.openvpms.archetype.rules.util.DateRules;

public class DateFunctions {
    public static final String SHORT = "short";
    public static final String MEDIUM = "medium";
    public static final String LONG = "long";
    private final Locale locale;
    private final TimeZone zone;
    private static final RelativeDateParser PARSER = new RelativeDateParser();

    public DateFunctions() {
        this(Locale.getDefault(), TimeZone.getDefault());
    }

    public DateFunctions(Locale locale, TimeZone zone) {
        this.locale = locale;
        this.zone = zone;
    }

    public Date now() {
        return new Date();
    }

    public Date today() {
        return DateRules.getToday();
    }

    public Date tomorrow() {
        return DateRules.getTomorrow();
    }

    public Date yesterday() {
        return DateRules.getYesterday();
    }

    public Date add(Date date, String period) {
        Date result = null;
        if (date != null && period != null) {
            result = PARSER.parse(period, date);
        }
        return result;
    }

    public String format(Date date, String pattern) {
        String result = null;
        if (date != null) {
            if (pattern == null) {
                result = this.formatDateTime(date);
            } else {
                SimpleDateFormat format = new SimpleDateFormat(pattern, this.getLocale());
                format.setTimeZone(this.getTimeZone());
                result = format.format(date);
            }
        }
        return result;
    }

    public String formatDate(Date date) {
        return this.formatDate(date, MEDIUM);
    }

    public String formatDate(Date date, String style) {
        if (date != null) {
            int type = this.getStyle(style);
            DateFormat format = DateFormat.getDateInstance(type, this.getLocale());
            format.setTimeZone(this.getTimeZone());
            return format.format(date);
        }
        return null;
    }

    public String formatTime(Date time) {
        return this.formatTime(time, MEDIUM);
    }

    public String formatTime(Date time, String style) {
        if (time != null) {
            int type = this.getStyle(style);
            DateFormat format = DateFormat.getTimeInstance(type, this.getLocale());
            format.setTimeZone(this.getTimeZone());
            return format.format(time);
        }
        return null;
    }

    public String formatDateTime(Date dateTime) {
        return this.formatDateTime(dateTime, MEDIUM);
    }

    public String formatDateTime(Date dateTime, String style) {
        return this.formatDateTime(dateTime, style, style);
    }

    public String formatDateTime(Date dateTime, String dateStyle, String timeStyle) {
        if (dateTime != null) {
            DateFormat format = DateFormat.getDateTimeInstance(this.getStyle(dateStyle), this.getStyle(timeStyle), this.getLocale());
            format.setTimeZone(this.getTimeZone());
            return format.format(dateTime);
        }
        return null;
    }

    protected TimeZone getTimeZone() {
        return this.zone;
    }

    protected Locale getLocale() {
        return this.locale;
    }

    private int getStyle(String style) {
        int result = SHORT.equals(style) ? 3 : (MEDIUM.equals(style) ? 2 : 1);
        return result;
    }
}

