/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.tools;

import java.io.File;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.archetype.test.builder.sms.TestSMSFactory;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.criteria.TypedQueryIterator;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class TestSMSReplyGenerator {
    public static void main(String[] args) {
        String contextPath = "openvpms-archetypes-test-context.xml";
        Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
        ArchetypeService archetypeService = (ArchetypeService)context.getBean(IArchetypeRuleService.class);
        TestSMSFactory smsFactory = (TestSMSFactory)context.getBean(TestSMSFactory.class);
        CriteriaBuilder builder = archetypeService.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root from = query.from(Act.class, new String[]{"act.smsMessage"});
        query.where((Expression)from.get("status").in(new Object[]{"SENT", "DELIVERED"}));
        query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
        int count = 0;
        TypedQueryIterator iterator = new TypedQueryIterator(archetypeService.createQuery(query), 50);
        while (iterator.hasNext()) {
            Act sms = (Act)iterator.next();
            IMObjectBean bean = archetypeService.getBean((IMObject)sms);
            if (!bean.getValues("replies").isEmpty()) continue;
            smsFactory.updateSMS(sms).addReply("this is a reply").build();
            ++count;
        }
        System.out.println("Added " + count + " replies");
    }
}

