/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.tools;

import java.io.File;
import java.util.Date;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class TestReminderGenerator {
    public static void main(String[] args) {
        String contextPath = "applicationContext.xml";
        if (!new File(contextPath).exists()) {
            new ClassPathXmlApplicationContext(contextPath);
        } else {
            new FileSystemXmlApplicationContext(contextPath);
        }
        Entity[] reminderTypes = new Entity[10];
        Entity documentTemplate = ReminderTestHelper.createDocumentTemplate();
        for (int i = 0; i < reminderTypes.length; ++i) {
            Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
            ReminderTestHelper.addReminderCount(reminderType, 0, 1, DateUnits.DAYS, documentTemplate, new Entity[0]);
            reminderTypes[i] = reminderType;
        }
        Date date = DateRules.getTomorrow();
        for (int i = 0; i < 100; ++i) {
            Party customer = TestHelper.createCustomer();
            Party patient = TestHelper.createPatient(customer);
            for (Entity reminderType : reminderTypes) {
                ReminderTestHelper.createReminderWithDueDate(patient, reminderType, date);
            }
        }
    }
}

