/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.user;

import java.util.Set;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestAuthorityBuilder
extends AbstractTestIMObjectBuilder<ArchetypeAwareGrantedAuthority, TestAuthorityBuilder> {
    private String serviceName = "archetypeService";
    private String method;
    private String archetype;

    public TestAuthorityBuilder(ArchetypeService service) {
        super("security.archetypeAuthority", ArchetypeAwareGrantedAuthority.class, service);
        this.name(ValueStrategy.random("zauthority"));
    }

    public TestAuthorityBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public TestAuthorityBuilder method(String method) {
        this.method = method;
        return this;
    }

    public TestAuthorityBuilder archetype(String archetype) {
        this.archetype = archetype;
        return this;
    }

    @Override
    protected void build(ArchetypeAwareGrantedAuthority object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        object.setServiceName(this.serviceName);
        object.setMethod(this.method);
        object.setShortName(this.archetype);
    }
}

