/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.supplier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestSupplierOrganisationBuilder
extends AbstractTestPartyBuilder<Party, TestSupplierOrganisationBuilder> {
    private final List<EntityRelationship> esciConfigs = new ArrayList<EntityRelationship>();
    private List<EntityRelationship> builtESCIConfigs = Collections.emptyList();

    public TestSupplierOrganisationBuilder(ArchetypeService service) {
        super("party.supplierorganisation", Party.class, service);
        this.name(ValueStrategy.random("zsupplier"));
    }

    public TestSupplierOrganisationBuilder(Party object, ArchetypeService service) {
        super(object, service);
    }

    public TestSupplierOrganisationBuilder addESCIConfiguration(Party stockLocation) {
        EntityRelationship config = this.create("entityRelationship.supplierStockLocationESCI", EntityRelationship.class);
        IMObjectBean bean = this.getBean((IMObject)config);
        bean.setValue("accountId", (Object)"ANACCOUNTID");
        bean.setValue("serviceURL", (Object)"http://localhost:8080/esci/RegistryService?wsdl");
        config.setTarget(stockLocation.getObjectReference());
        this.esciConfigs.add(config);
        return this;
    }

    public List<EntityRelationship> getESCIConfigs() {
        return this.builtESCIConfigs;
    }

    @Override
    protected void build(Party object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        for (EntityRelationship relationship : this.esciConfigs) {
            relationship.setSource(object.getObjectReference());
            object.addEntityRelationship(relationship);
        }
        this.builtESCIConfigs = new ArrayList<EntityRelationship>(this.esciConfigs);
        this.esciConfigs.clear();
    }
}

