/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.sms;

import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AbstractTestSMSBuilder<B extends AbstractTestSMSBuilder<B>>
extends AbstractTestActBuilder<Act, B> {
    private Party location;
    private Party contact;
    private ValueStrategy phone = ValueStrategy.unset();
    private ValueStrategy message = ValueStrategy.unset();

    public AbstractTestSMSBuilder(String archetype, ArchetypeService service) {
        super(archetype, Act.class, service);
    }

    public AbstractTestSMSBuilder(Act object, ArchetypeService service) {
        super(object, service);
        IMObjectBean bean = this.getBean((IMObject)object);
        this.location = (Party)bean.getTarget("location", Party.class);
        this.contact = (Party)bean.getTarget("contact", Party.class);
        this.phone = ValueStrategy.value(bean.getString("phone"));
    }

    public Party getLocation() {
        return this.location;
    }

    public B location(Party location) {
        this.location = location;
        return (B)((AbstractTestSMSBuilder)this.getThis());
    }

    public Party getContact() {
        return this.contact;
    }

    public B contact(Party contact) {
        this.contact = contact;
        return (B)((AbstractTestSMSBuilder)this.getThis());
    }

    public String getPhone() {
        return this.phone.toString();
    }

    public B phone(String phone) {
        this.phone = ValueStrategy.value(phone);
        return (B)((AbstractTestSMSBuilder)this.getThis());
    }

    public B message(String message) {
        this.message = ValueStrategy.value(message);
        return (B)((AbstractTestSMSBuilder)this.getThis());
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.contact != null) {
            bean.setTarget("contact", (IMObject)this.contact);
        }
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        this.phone.setValue(bean, "phone");
        this.message.setValue(bean, "message");
    }
}

