/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.lookup.TestSpeciesBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.product.TestDemographicUpdateBuilder;
import org.openvpms.archetype.test.builder.product.TestFixedPriceBuilder;
import org.openvpms.archetype.test.builder.product.TestProductReminderBuilder;
import org.openvpms.archetype.test.builder.product.TestProductStockLocationBuilder;
import org.openvpms.archetype.test.builder.product.TestProductSupplierBuilder;
import org.openvpms.archetype.test.builder.product.TestProductTaskBuilder;
import org.openvpms.archetype.test.builder.product.TestUnitPriceBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestProductBuilder<T extends TestProductBuilder<T>>
extends AbstractTestEntityBuilder<Product, T> {
    private final List<ProductPrice> prices = new ArrayList<ProductPrice>();
    private final List<EntityLink> priceTemplates = new ArrayList<EntityLink>();
    private final List<EntityLink> productStockLocations = new ArrayList<EntityLink>();
    private final List<EntityLink> builtProductStockLocations = new ArrayList<EntityLink>();
    private final List<EntityLink> productSuppliers = new ArrayList<EntityLink>();
    private final List<EntityLink> productReminders = new ArrayList<EntityLink>();
    private final List<Entity> documents = new ArrayList<Entity>();
    private final List<EntityLink> productTasks = new ArrayList<EntityLink>();
    private final List<Party> locations = new ArrayList<Party>();
    private final List<Entity> alertTypes = new ArrayList<Entity>();
    private final List<Entity> tests = new ArrayList<Entity>();
    private final List<Entity> discounts = new ArrayList<Entity>();
    private ValueStrategy printedName = ValueStrategy.unset();
    private final List<Lookup> demographicUpdates = new ArrayList<Lookup>();
    private List<EntityLink> builtProductReminders = new ArrayList<EntityLink>();
    private List<EntityLink> builtProductSuppliers = new ArrayList<EntityLink>();
    private List<EntityLink> builtProductTasks = new ArrayList<EntityLink>();
    private String[] species;
    private Entity type;
    private Lookup[] taxTypes;
    private Entity pharmacy;
    private ValueStrategy patientIdentity = ValueStrategy.unset();

    public TestProductBuilder(String archetype, ArchetypeService service) {
        super(archetype, Product.class, service);
        this.name("zproduct");
    }

    public TestProductBuilder(Product object, ArchetypeService service) {
        super(object, service);
    }

    public T printedName(String printedName) {
        this.printedName = ValueStrategy.value(printedName);
        return (T)((TestProductBuilder)this.getThis());
    }

    public T fixedPrice(int fixedPrice) {
        return this.fixedPrice(BigDecimal.valueOf(fixedPrice));
    }

    public T fixedPrice(String fixedPrice) {
        return this.fixedPrice(new BigDecimal(fixedPrice));
    }

    public T fixedPrice(BigDecimal fixedPrice) {
        return (T)((TestFixedPriceBuilder)this.newFixedPrice().price(fixedPrice)).add();
    }

    public T fixedPrice(int fixedCost, int fixedPrice) {
        return (T)((TestFixedPriceBuilder)this.newFixedPrice().costAndPrice(fixedCost, fixedPrice)).add();
    }

    public T fixedPrice(BigDecimal fixedCost, BigDecimal fixedPrice) {
        return (T)((TestFixedPriceBuilder)this.newFixedPrice().costAndPrice(fixedCost, fixedPrice)).add();
    }

    public TestFixedPriceBuilder<T> newFixedPrice() {
        return new TestFixedPriceBuilder<TestProductBuilder>((TestProductBuilder)this.getThis(), this.getService());
    }

    public T unitPrice(int unitPrice) {
        return this.unitPrice(BigDecimal.valueOf(unitPrice));
    }

    public T unitPrice(String unitPrice) {
        return this.unitPrice(new BigDecimal(unitPrice));
    }

    public T unitPrice(BigDecimal unitPrice) {
        return (T)((TestUnitPriceBuilder)this.newUnitPrice().price(unitPrice)).add();
    }

    public T unitPrice(int unitCost, int unitPrice) {
        return (T)((TestUnitPriceBuilder)this.newUnitPrice().costAndPrice(unitCost, unitPrice)).add();
    }

    public T unitPrice(BigDecimal unitCost, BigDecimal unitPrice) {
        return (T)((TestUnitPriceBuilder)this.newUnitPrice().costAndPrice(unitCost, unitPrice)).add();
    }

    public TestUnitPriceBuilder<T> newUnitPrice() {
        return new TestUnitPriceBuilder<TestProductBuilder>((TestProductBuilder)this.getThis(), this.getService());
    }

    public T addPrice(ProductPrice price) {
        this.prices.add(price);
        return (T)((TestProductBuilder)this.getThis());
    }

    public T addPrices(ProductPrice ... prices) {
        for (ProductPrice price : prices) {
            this.addPrice(price);
        }
        return (T)((TestProductBuilder)this.getThis());
    }

    public T type(Entity type) {
        this.type = type;
        return (T)((TestProductBuilder)this.getThis());
    }

    public T addTests(Collection<Entity> tests) {
        return this.addTests(tests.toArray(new Entity[0]));
    }

    public T addTests(Entity ... tests) {
        this.tests.addAll(Arrays.asList(tests));
        return (T)((TestProductBuilder)this.getThis());
    }

    public T addDiscounts(Entity ... discounts) {
        this.discounts.addAll(Arrays.asList(discounts));
        return (T)((TestProductBuilder)this.getThis());
    }

    public T addSpecies(String ... species) {
        this.species = species;
        return (T)((TestProductBuilder)this.getThis());
    }

    public T addPriceTemplate(Product template) {
        return this.addPriceTemplate(template, new Date(), null);
    }

    public T addPriceTemplate(Product template, String fromDate, String toDate) {
        return this.addPriceTemplate(template, this.parseDate(fromDate), this.parseDate(toDate));
    }

    public T addPriceTemplate(Product template, Date fromDate, Date toDate) {
        EntityLink link = this.create(this.getNodeArchetype("linked"), EntityLink.class);
        link.setTarget(template.getObjectReference());
        link.setActiveStartTime(fromDate);
        link.setActiveEndTime(toDate);
        this.priceTemplates.add(link);
        return (T)((TestProductBuilder)this.getThis());
    }

    public T stockQuantity(Party stockLocation, int quantity) {
        return this.stockQuantity(stockLocation, BigDecimal.valueOf(quantity));
    }

    public T stockQuantity(Party stockLocation, BigDecimal quantity) {
        return this.newProductStockLocation().stockLocation(stockLocation).quantity(quantity).add();
    }

    public T addLocations(Party ... locations) {
        this.locations.addAll(Arrays.asList(locations));
        return (T)((TestProductBuilder)this.getThis());
    }

    public TestProductStockLocationBuilder<T> newProductStockLocation() {
        return new TestProductStockLocationBuilder<TestProductBuilder>((TestProductBuilder)this.getThis(), this.getService());
    }

    public T addProductStockLocation(EntityLink productStockLocation) {
        this.productStockLocations.add(productStockLocation);
        return (T)((TestProductBuilder)this.getThis());
    }

    public List<EntityLink> getProductStockLocations() {
        return this.builtProductStockLocations;
    }

    public TestProductSupplierBuilder<T> newProductSupplier() {
        return new TestProductSupplierBuilder<TestProductBuilder>((TestProductBuilder)this.getThis(), this.getService());
    }

    public T addProductSupplier(EntityLink productSupplier) {
        this.productSuppliers.add(productSupplier);
        return (T)((TestProductBuilder)this.getThis());
    }

    public List<EntityLink> getProductSuppliers() {
        return this.builtProductSuppliers;
    }

    public T addProductReminder(Entity reminderType, int period, DateUnits units) {
        return this.newProductReminder().reminderType(reminderType).period(period, units).add();
    }

    public TestProductReminderBuilder<T> newProductReminder() {
        return new TestProductReminderBuilder<TestProductBuilder>((TestProductBuilder)this.getThis(), this.getService());
    }

    public T addProductReminder(EntityLink productReminder) {
        this.productReminders.add(productReminder);
        return (T)((TestProductBuilder)this.getThis());
    }

    public T addDocument(Entity document) {
        return this.addDocuments(document);
    }

    public T addDocuments(Entity ... documents) {
        this.documents.addAll(Arrays.asList(documents));
        return (T)((TestProductBuilder)this.getThis());
    }

    public List<EntityLink> getProductReminders() {
        return this.builtProductReminders;
    }

    public TestProductTaskBuilder<T> newProductTask() {
        return new TestProductTaskBuilder<TestProductBuilder>((TestProductBuilder)this.getThis(), this.getService());
    }

    public T addProductTask(EntityLink productTask) {
        this.productTasks.add(productTask);
        return (T)((TestProductBuilder)this.getThis());
    }

    public List<EntityLink> getProductTasks() {
        return this.builtProductTasks;
    }

    public T addAlertTypes(Entity ... alertTypes) {
        this.alertTypes.addAll(Arrays.asList(alertTypes));
        return (T)((TestProductBuilder)this.getThis());
    }

    public T addTaxTypes(Lookup ... taxTypes) {
        this.taxTypes = taxTypes;
        return (T)((TestProductBuilder)this.getThis());
    }

    public T addDemographicUpdate(String node, String expression) {
        Lookup lookup = (Lookup)new TestDemographicUpdateBuilder(this.getService()).node(node).expression(expression).build();
        return this.addDemographicUpdate(lookup);
    }

    public T addDemographicUpdate(Lookup lookup) {
        this.demographicUpdates.add(lookup);
        return (T)((TestProductBuilder)this.getThis());
    }

    public T pharmacy(Entity pharmacy) {
        this.pharmacy = pharmacy;
        return (T)((TestProductBuilder)this.getThis());
    }

    public T patientIdentity(String patientIdentity) {
        this.patientIdentity = ValueStrategy.value(patientIdentity);
        return (T)((TestProductBuilder)this.getThis());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void build(Product object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.printedName.setValue(bean, "printedName");
        for (ProductPrice productPrice : this.prices) {
            object.addProductPrice(productPrice);
        }
        for (EntityLink entityLink : this.priceTemplates) {
            entityLink.setSource(object.getObjectReference());
            object.addEntityLink(entityLink);
        }
        if (this.type != null) {
            bean.setTarget("type", (IMObject)this.type);
        }
        for (Entity entity : this.tests) {
            bean.addTarget("tests", (IMObject)entity);
        }
        for (Entity entity : this.discounts) {
            bean.addTarget("discounts", (IMObject)entity);
        }
        if (this.species != null) {
            TestSpeciesBuilder speciesBuilder = new TestSpeciesBuilder(this.getService());
            String[] stringArray = this.species;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String species = stringArray[i];
                object.addClassification((Lookup)((TestSpeciesBuilder)speciesBuilder.code(species)).build());
            }
        }
        if (this.locations != null) {
            for (Party party : this.locations) {
                bean.addTarget("locations", (IMObject)party);
            }
        }
        this.builtProductStockLocations.clear();
        for (EntityLink entityLink : this.productStockLocations) {
            void var6_20;
            EntityLink existing = (EntityLink)bean.getValue("stockLocations", EntityLink.class, Predicates.targetEquals((Reference)entityLink.getTarget()));
            if (existing != null) {
                new TestProductStockLocationBuilder<TestProductBuilder>((TestProductBuilder)this.getThis(), existing, this.getService()).copy(entityLink).build();
                EntityLink entityLink2 = existing;
            } else {
                entityLink.setSource(object.getObjectReference());
                object.addEntityLink(entityLink);
            }
            this.builtProductStockLocations.add((EntityLink)var6_20);
        }
        for (EntityLink entityLink : this.productSuppliers) {
            entityLink.setSource(object.getObjectReference());
            object.addEntityLink(entityLink);
        }
        for (EntityLink entityLink : this.productReminders) {
            entityLink.setSource(object.getObjectReference());
            object.addEntityLink(entityLink);
        }
        for (EntityLink entityLink : this.productTasks) {
            entityLink.setSource(object.getObjectReference());
            object.addEntityLink(entityLink);
        }
        for (Entity entity : this.documents) {
            bean.addTarget("documents", (IMObject)entity);
        }
        for (Entity entity : this.alertTypes) {
            bean.addTarget("alerts", (IMObject)entity);
        }
        if (this.taxTypes != null) {
            for (Lookup taxType : this.taxTypes) {
                object.addClassification(taxType);
            }
        }
        for (Lookup lookup : this.demographicUpdates) {
            object.addClassification(lookup);
        }
        if (this.pharmacy != null) {
            bean.setTarget("pharmacy", (IMObject)this.pharmacy);
        }
        this.patientIdentity.setValue(bean, "patientIdentity");
        for (Lookup lookup : this.demographicUpdates) {
            object.addClassification(lookup);
        }
        this.prices.clear();
        this.priceTemplates.clear();
        this.productStockLocations.clear();
        this.builtProductSuppliers = new ArrayList<EntityLink>(this.productSuppliers);
        this.productSuppliers.clear();
        this.builtProductReminders = new ArrayList<EntityLink>(this.productReminders);
        this.productReminders.clear();
        this.builtProductTasks = new ArrayList<EntityLink>(this.productTasks);
        this.productTasks.clear();
    }
}

