/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.product.TestDoseBuilder;
import org.openvpms.archetype.test.builder.product.TestDrugScheduleBuilder;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestMedicationProductBuilder
extends TestProductBuilder<TestMedicationProductBuilder> {
    private final List<Entity> doses = new ArrayList<Entity>();
    private ValueStrategy labelInstructions = ValueStrategy.unset();
    private String drugSchedule;
    private ValueStrategy concentration = ValueStrategy.unset();

    public TestMedicationProductBuilder(ArchetypeService service) {
        super("product.medication", service);
    }

    public TestMedicationProductBuilder(Product object, ArchetypeService service) {
        super(object, service);
    }

    public TestMedicationProductBuilder labelInstructions(String instructions) {
        this.labelInstructions = ValueStrategy.value(instructions);
        return this;
    }

    public TestMedicationProductBuilder drugSchedule(boolean restricted) {
        return restricted ? this.drugSchedule("S3") : this.drugSchedule("S4");
    }

    public TestMedicationProductBuilder drugSchedule(String drugSchedule) {
        this.drugSchedule = drugSchedule;
        return this;
    }

    public TestMedicationProductBuilder concentration(int concentration) {
        return this.concentration(BigDecimal.valueOf(concentration));
    }

    public TestMedicationProductBuilder concentration(BigDecimal concentration) {
        this.concentration = ValueStrategy.value(concentration);
        return this;
    }

    public TestMedicationProductBuilder addDose(Entity dose) {
        this.doses.add(dose);
        return this;
    }

    public TestDoseBuilder newDose() {
        return new TestDoseBuilder(this, this.getService());
    }

    @Override
    protected void build(Product object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.labelInstructions.setValue(bean, "dispInstructions");
        this.concentration.setValue(bean, "concentration");
        if (this.drugSchedule != null) {
            boolean restricted = "S3".equals(this.drugSchedule);
            Lookup lookup = (Lookup)((TestDrugScheduleBuilder)new TestDrugScheduleBuilder(this.getService()).code(this.drugSchedule)).restricted(restricted).build();
            bean.setValue("drugSchedule", (Object)lookup.getCode());
        }
        for (Entity dose : this.doses) {
            bean.addTarget("doses", (IMObject)dose);
            toSave.add((IMObject)dose);
        }
        this.doses.clear();
    }
}

