/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.practice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.practice.AbstractTestOrganisationBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestLocationBuilder
extends AbstractTestOrganisationBuilder<TestLocationBuilder> {
    private final List<EntityLink> serviceRatios = new ArrayList<EntityLink>();
    private final Map<Entity, Boolean> workListViews = new HashMap<Entity, Boolean>();
    private ValueStrategy stockControl = ValueStrategy.unset();
    private ValueStrategy onlineBooking = ValueStrategy.unset();
    private ValueStrategy disableDiscounts = ValueStrategy.unset();
    private Entity[] tills;
    private Entity gapBenefitTill;
    private Party stockLocation;
    private Entity mailServer;
    private Entity[] scheduleViews;
    private Party otc;
    private Entity letterhead;
    private PrinterReference defaultPrinter;
    private PrinterReference[] printers;

    public TestLocationBuilder(ArchetypeService service) {
        super("party.organisationLocation", service);
        this.name(ValueStrategy.random("zlocation"));
    }

    public TestLocationBuilder(Party object, ArchetypeService service) {
        super(object, service);
    }

    public TestLocationBuilder stockControl() {
        return this.stockControl(true);
    }

    public TestLocationBuilder stockControl(boolean stockControl) {
        this.stockControl = ValueStrategy.value(stockControl);
        return this;
    }

    public TestLocationBuilder onlineBooking() {
        return this.onlineBooking(true);
    }

    public TestLocationBuilder onlineBooking(boolean onlineBooking) {
        this.onlineBooking = ValueStrategy.value(onlineBooking);
        return this;
    }

    public TestLocationBuilder disableDiscounts(boolean disableDiscounts) {
        this.disableDiscounts = ValueStrategy.value(disableDiscounts);
        return this;
    }

    public TestLocationBuilder tills(Entity ... tills) {
        this.tills = tills;
        return this;
    }

    public TestLocationBuilder gapBenefitTill(Entity gapBenefitTill) {
        this.gapBenefitTill = gapBenefitTill;
        return this;
    }

    public TestLocationBuilder stockLocation(Party stockLocation) {
        this.stockLocation = stockLocation;
        return this;
    }

    public TestLocationBuilder setMailServer(Entity mailServer) {
        this.mailServer = mailServer;
        return this;
    }

    public TestLocationBuilder otc(Party otc) {
        this.otc = otc;
        return this;
    }

    public TestLocationBuilder scheduleViews(Entity ... scheduleViews) {
        this.scheduleViews = scheduleViews;
        return this;
    }

    public TestLocationBuilder workListViews(Entity ... workListViews) {
        for (Entity workListView : workListViews) {
            this.addWorkListView(workListView, false);
        }
        return this;
    }

    public TestLocationBuilder addWorkListView(Entity workListView, boolean isDefault) {
        this.workListViews.put(workListView, isDefault);
        return this;
    }

    public TestLocationBuilder letterhead(Entity letterhead) {
        this.letterhead = letterhead;
        return this;
    }

    public TestLocationBuilder defaultPrinter(PrinterReference defaultPrinter) {
        this.defaultPrinter = defaultPrinter;
        return this;
    }

    public TestLocationBuilder printers(PrinterReference ... printers) {
        this.printers = printers;
        return this;
    }

    public TestLocationBuilder addServiceRatio(Entity productType, int ratio) {
        return this.addServiceRatio(productType, BigDecimal.valueOf(ratio));
    }

    public TestLocationBuilder addServiceRatio(Entity productType, BigDecimal ratio) {
        return this.addServiceRatio(productType, ratio, null);
    }

    public TestLocationBuilder addServiceRatio(Entity productType, int ratio, Entity calendar) {
        return this.addServiceRatio(productType, BigDecimal.valueOf(ratio), calendar);
    }

    public TestLocationBuilder addServiceRatio(Entity productType, BigDecimal ratio, Entity calendar) {
        EntityLink link = this.create(this.getNodeArchetype("serviceRatios"), EntityLink.class);
        link.setTarget(productType.getObjectReference());
        IMObjectBean bean = this.getBean((IMObject)link);
        bean.setValue("ratio", (Object)ratio);
        if (calendar != null) {
            bean.setValue("calendar", (Object)calendar.getObjectReference());
        }
        this.serviceRatios.add(link);
        return this;
    }

    @Override
    protected void build(Party object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.stockControl.setValue(bean, "stockControl");
        this.onlineBooking.setValue(bean, "onlineBooking");
        this.disableDiscounts.setValue(bean, "disableDiscounts");
        if (this.tills != null) {
            for (Entity till : this.tills) {
                bean.addTarget("tills", (IMObject)till, "locations");
                toSave.add((IMObject)till);
            }
        }
        if (this.gapBenefitTill != null) {
            bean.setTarget("gapBenefitTill", (IMObject)this.gapBenefitTill);
        }
        if (this.stockLocation != null) {
            bean.addTarget("stockLocations", (IMObject)this.stockLocation, "locations");
            toSave.add((IMObject)this.stockLocation);
        }
        if (this.mailServer != null) {
            bean.setTarget("mailServer", (IMObject)this.mailServer);
        }
        if (this.otc != null) {
            bean.addTarget("OTC", (IMObject)this.otc, "location");
            toSave.add((IMObject)this.otc);
            this.otc = null;
        }
        if (this.scheduleViews != null) {
            for (Entity scheduleView : this.scheduleViews) {
                bean.addTarget("scheduleViews", (IMObject)scheduleView);
            }
        }
        for (Map.Entry entry : this.workListViews.entrySet()) {
            Relationship relationship = bean.addTarget("workListViews", (IMObject)entry.getKey());
            IMObjectBean relBean = this.getBean((IMObject)relationship);
            relBean.setValue("default", entry.getValue());
        }
        if (this.letterhead != null) {
            bean.setTarget("letterhead", (IMObject)this.letterhead);
        }
        bean.setValue("defaultPrinter", this.defaultPrinter != null ? this.defaultPrinter.toString() : null);
        if (this.printers != null) {
            for (PrinterReference printer : this.printers) {
                Entity entity = this.create("entity.printer", Entity.class);
                IMObjectBean printerBean = this.getBean((IMObject)entity);
                printerBean.setValue("name", (Object)printer.getName());
                printerBean.setValue("printer", (Object)printer.toString());
                bean.addTarget("printers", (IMObject)entity);
                toSave.add((IMObject)entity);
            }
        }
        for (EntityLink entityLink : this.serviceRatios) {
            entityLink.setSource(object.getObjectReference());
            bean.addValue("serviceRatios", (IMObject)entityLink);
        }
        this.serviceRatios.clear();
    }
}

