/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.patient.AbstractTestPatientActBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestPrescriptionBuilder
extends AbstractTestPatientActBuilder<Act, TestPrescriptionBuilder> {
    private ValueStrategy quantity = ValueStrategy.unset();
    private ValueStrategy repeats = ValueStrategy.unset();
    private Product product;
    private ValueStrategy label = ValueStrategy.unset();

    public TestPrescriptionBuilder(ArchetypeService service) {
        super("act.patientPrescription", Act.class, service);
    }

    public TestPrescriptionBuilder expiryDate(Date expiryDate) {
        return (TestPrescriptionBuilder)this.endTime(expiryDate);
    }

    public TestPrescriptionBuilder quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public TestPrescriptionBuilder quantity(BigDecimal quantity) {
        this.quantity = ValueStrategy.value(quantity);
        return this;
    }

    public TestPrescriptionBuilder repeats(int repeats) {
        this.repeats = ValueStrategy.value(repeats);
        return this;
    }

    public TestPrescriptionBuilder product(Product product) {
        this.product = product;
        return this;
    }

    public TestPrescriptionBuilder label(String label) {
        this.label = ValueStrategy.value(label);
        return this;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.quantity.setValue(bean, "quantity");
        this.repeats.setValue(bean, "repeats");
        if (this.product != null) {
            bean.setTarget("product", (IMObject)this.product);
        }
        this.label.setValue(bean, "label");
    }
}

