/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryTestBuilder;
import org.openvpms.archetype.test.builder.patient.AbstractTestPatientActBuilder;
import org.openvpms.archetype.test.builder.patient.TestInvestigationResultsBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestInvestigationBuilder
extends AbstractTestPatientActBuilder<DocumentAct, TestInvestigationBuilder> {
    private final LaboratoryRules laboratoryRules;
    private final List<Entity> tests = new ArrayList<Entity>();
    private final List<TestInvestigationResultsBuilder> results = new ArrayList<TestInvestigationResultsBuilder>();
    private Entity investigationType;
    private Entity laboratory;
    private Entity device;
    private String[] testNames;
    private Product[] products;
    private String orderStatus;
    private boolean cancellation;
    private Document report;

    public TestInvestigationBuilder(ArchetypeService service, LaboratoryRules laboratoryRules) {
        super("act.patientInvestigation", DocumentAct.class, service);
        this.laboratoryRules = laboratoryRules;
    }

    public TestInvestigationBuilder(DocumentAct object, ArchetypeService service, LaboratoryRules laboratoryRules) {
        super(object, service);
        this.laboratoryRules = laboratoryRules;
    }

    public TestInvestigationBuilder investigationType(Entity investigationType) {
        this.investigationType = investigationType;
        return this;
    }

    public TestInvestigationBuilder addTests(String ... names) {
        this.testNames = names;
        return this;
    }

    public TestInvestigationBuilder addTests(Entity ... tests) {
        this.tests.addAll(Arrays.asList(tests));
        return this;
    }

    public TestInvestigationBuilder laboratory(Entity laboratory) {
        this.laboratory = laboratory;
        return this;
    }

    public TestInvestigationBuilder device(Entity device) {
        this.device = device;
        return this;
    }

    public TestInvestigationBuilder products(Product ... products) {
        this.products = products;
        return this;
    }

    public TestInvestigationBuilder order() {
        return this.order("PENDING");
    }

    public TestInvestigationBuilder order(String status) {
        return this.order(status, false);
    }

    public TestInvestigationBuilder order(String status, boolean cancellation) {
        this.orderStatus = status;
        this.cancellation = cancellation;
        return this;
    }

    public TestInvestigationBuilder report(Document report) {
        this.report = report;
        return this;
    }

    public TestInvestigationResultsBuilder results() {
        return new TestInvestigationResultsBuilder(this, this.getService());
    }

    @Override
    public DocumentAct build(boolean save) {
        if (!save && this.testNames != null && this.testNames.length != 0) {
            throw new IllegalArgumentException("Argument 'save' must be true when creating tests");
        }
        if (!save && this.orderStatus != null) {
            throw new IllegalArgumentException("Argument 'save' must be true when ordering investigations");
        }
        DocumentAct result = (DocumentAct)super.build(save);
        if (this.orderStatus != null) {
            Act order = this.laboratoryRules.createOrder((Act)result);
            order.setStatus(this.orderStatus);
            if (this.cancellation) {
                IMObjectBean bean = this.getBean((IMObject)order);
                bean.setValue("type", (Object)"CANCEL");
            }
            this.getService().save(Arrays.asList(result, order));
        }
        return result;
    }

    protected void addResults(TestInvestigationResultsBuilder results) {
        this.results.add(results);
    }

    @Override
    protected void build(DocumentAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.investigationType != null) {
            bean.setTarget("investigationType", (IMObject)this.investigationType);
        }
        if (this.laboratory != null) {
            bean.setTarget("laboratory", (IMObject)this.laboratory);
        }
        if (this.device != null) {
            bean.setTarget("device", (IMObject)this.device);
        }
        ArrayList<Entity> allTests = new ArrayList<Entity>(this.tests);
        if (this.testNames != null && this.testNames.length != 0) {
            Product[] testBuilder = new TestLaboratoryTestBuilder(this.getService());
            String[] stringArray = this.testNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Object name = stringArray[i];
                Entity test = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)testBuilder.name((String)name)).investigationType(this.investigationType)).build();
                allTests.add(test);
                toSave.add((IMObject)test);
            }
        }
        for (Entity test : allTests) {
            bean.addTarget("tests", (IMObject)test);
        }
        if (this.products != null) {
            for (Product product : this.products) {
                bean.addTarget("products", (IMObject)product);
            }
        }
        if (this.report != null) {
            DocumentRules rules = new DocumentRules(this.getService());
            toSave.addAll(rules.addDocument(object, this.report));
            this.report = null;
        }
        int sequence = this.getNextSequence(bean, "results");
        for (TestInvestigationResultsBuilder builder : this.results) {
            Act act = (Act)builder.build(toSave, toRemove);
            if (!act.isNew()) continue;
            ActRelationship relationship = (ActRelationship)bean.addTarget("results", (IMObject)act, "investigation");
            relationship.setSequence(sequence++);
        }
        this.results.clear();
    }
}

