/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.party;

import java.util.Set;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractTestContactBuilder<T extends Party, P extends AbstractTestPartyBuilder<T, P>, B extends AbstractTestContactBuilder<T, P, B>>
extends AbstractTestIMObjectBuilder<Contact, B> {
    private final P parent;
    private ValueStrategy preferred = ValueStrategy.unset();
    private String[] purposes;

    public AbstractTestContactBuilder(String archetype, ArchetypeService service) {
        this(null, archetype, service);
    }

    public AbstractTestContactBuilder(P parent, String archetype, ArchetypeService service) {
        super(archetype, Contact.class, service);
        this.parent = parent;
    }

    public AbstractTestContactBuilder(Contact object, ArchetypeService service) {
        super(object, service);
        this.parent = null;
    }

    public B preferred() {
        return this.preferred(true);
    }

    public B preferred(boolean preferred) {
        this.preferred = ValueStrategy.value(preferred);
        return (B)((AbstractTestContactBuilder)this.getThis());
    }

    public B purposes(String ... purposes) {
        this.purposes = purposes;
        return (B)((AbstractTestContactBuilder)this.getThis());
    }

    @Override
    public Contact build() {
        return (Contact)this.build(false);
    }

    public P add() {
        return (P)((AbstractTestPartyBuilder)this.parent).addContact(this.build());
    }

    @Override
    protected void build(Contact object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.preferred.setValue(bean, "preferred");
        if (this.purposes != null) {
            TestLookupBuilder builder = new TestLookupBuilder("lookup.contactPurpose", this.getService());
            for (String purpose : this.purposes) {
                object.addClassification((Lookup)((TestLookupBuilder)builder.code(purpose)).build());
            }
        }
    }
}

